use strict;
use warnings;
use Test::More tests => 8;

use Net::SNMP qw(:asn1);
use Device::ZyXEL::IES;
use Data::Dumper;

my $d = Device::ZyXEL::IES->new(
  hostname => 'localhost',  
  get_community => 'public');

my $s_adsl = Device::ZyXEL::IES::Slot->new(
  id => 3, ies => $d);

my $s_vdsl = Device::ZyXEL::IES::Slot->new(
  id => 4, ies => $d);

my $p_adsl = Device::ZyXEL::IES::Port->new(
  id => 301, slot => $s_adsl );

my $p_vdsl = Device::ZyXEL::IES::Port->new(
  id => 401, slot => $s_vdsl );

# Hooking for test ============================================================
# hook allows snmpget from Net::SNMP::Util
{
 no warnings;

 *{Net::SNMP::_send_pdu} = sub {
    my ( $this ) = @_;
    foreach my $oid ( keys %{$this->{_pdu}{_var_bind_list}} ){
      if ( $oid =~ /^\.1\.3\.6\.1\.4\.1\.890\.1\.5\.13\.5\.6\.3\.1\.3\.0\.3$/ ) {
	    $this->{_pdu}{_var_bind_list}{ $oid } = 'ALC1248G-51'; # slot 3 ADSL
	  }
      elsif ( $oid =~ /^\.1\.3\.6\.1\.4\.1\.890\.1\.5\.13\.5\.6\.3\.1\.3\.0\.4$/ ) {
	    $this->{_pdu}{_var_bind_list}{ $oid } = 'VLC1348G-51'; # slot 4 VDSL
	  }
      elsif ( $oid =~ /^\.1\.3\.6\.1\.4\.1\.890\.1\.5\.13\.5\.13\.8\.2\.1\.(29|30)\.401$/ ) { # VDSL port snr down and up
				 my @w = (255, 255, 193, 192, 195, 198, 198, 199, 200, 201, 201, 201, 201, 201, 203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 213, 214, 214, 214, 213, 214, 213, 214, 213, 213, 213, 213, 214, 213, 214, 213, 212, 214, 214, 214, 213, 214, 213, 215, 214, 213, 214, 213, 212, 214, 213, 214, 215, 213, 214, 213, 214, 214, 215, 214, 213, 214, 213, 213, 214, 213, 213, 213, 213, 213, 213, 210, 212, 213, 213, 214, 213, 214, 214, 214, 214, 213, 213, 213, 213, 214, 214, 214, 213, 214, 214, 213, 214, 213, 213, 213, 214, 214, 213, 213, 212, 213, 213, 212, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255);
         $this->{_pdu}{_var_bind_list}{ $oid } = pack("(C)*", @w);
      }
      elsif ( $oid =~ /^\.1\.3\.6\.1\.4\.1\.890\.1\.5\.13\.5\.13\.8\.2\.1\.4[01]\.401$/ ) { # VDSL port hlog down and up group size
         $this->{_pdu}{_var_bind_list}{ $oid } = 4;
			}
      else {
         $this->{_pdu}{_var_bind_list}{ $oid } = "?";
      }
    }
								
    return ($this->{_nonblocking}) ? 1 : $this->var_bind_list();
 }

};
								  
my ($pdr, $t);

$pdr = $p_adsl->read_snr_near();
$t = $p_adsl->snr_near();
ok( scalar( @{$t} ) == 0 );
ok( $p_adsl->qln_near_grpsize() == 1);

$pdr = $p_vdsl->read_snr_near();
$t = $p_vdsl->snr_near();
ok( $t->[2] == 64.5 );
ok( $p_vdsl->snr_near_grpsize() == 4);

$pdr = $p_adsl->read_snr_far();
$t = $p_adsl->snr_far();
ok( scalar( @{$t} ) == 0 );
ok( $p_adsl->qln_far_grpsize() == 1);

$pdr = $p_vdsl->read_snr_far();
$t = $p_vdsl->snr_far();
ok( $t->[2] == 64.5 );
ok( $p_vdsl->snr_far_grpsize() == 4);
