/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicate;

public final class AnyNodeTest
extends NodeTest
implements QNameTest {
    private static AnyNodeTest THE_INSTANCE = new AnyNodeTest();

    public static AnyNodeTest getInstance() {
        return THE_INSTANCE;
    }

    private AnyNodeTest() {
    }

    public UType getUType() {
        return UType.ANY_NODE;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return nodeKind != 12;
    }

    public IntPredicate getMatcher(NodeVectorTree tree) {
        final byte[] nodeKindArray = tree.getNodeKindArray();
        return new IntPredicate(){

            public boolean matches(int nodeNr) {
                return nodeKindArray[nodeNr] != 12;
            }
        };
    }

    public boolean matchesNode(NodeInfo node) {
        return true;
    }

    public boolean matches(StructuredQName qname) {
        return true;
    }

    public final double getDefaultPriority() {
        return -0.5;
    }

    public int getNodeKindMask() {
        return 9102;
    }

    public String toString() {
        return "node()";
    }

    public int hashCode() {
        return "AnyNodeTest".hashCode();
    }

    public String generateJavaScriptNameTest(int targetVersion) {
        return "true";
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        return "return SaxonJS.U.isNode(item);";
    }
}

