#Test conversion of numbers to Unicode strings
load tcl_uninum.so uninum
#package require uninum 2.2
fconfigure  stdout -encoding utf-8
set nslist {
Aegean
Arabic_Western
Arabic_Persian
Armenian
Bengali
Burmese
Chinese_Regular_Simplified
Chinese_Regular_Traditional
Chinese_Legal_Simplified
Chinese_Legal_Traditional
Chinese_Regular_Place
Common_Braille
Cyrillic
Devanagari
French_Braille
Glagolitic
Gujarati
Gurmukhi
Hebrew_Early
Hebrew_Late
Kannada
Kharoshthi
Khmer
Klingon
Lao
Limbu
Malayalam
Mongolian
New_Tai_Lue
Nko
Old_Italic
Old_Persian
Oriya
Osmanya
Phoenician
Roman_Upper
Russian_Braille
Suzhou
Tamil_Place
Tamil_Traditional
Telugu
Tengwar
Thai
Tibetan
}

proc UninumErrorToString {n} {
    switch $n {
	128 {return "bad character"}
	129 {return "does not fit"}
	130 {return "unknown number system"}
	131 {return "invalid base"}
	132 {return "digit inconsistent with base"}
	133 {return "out of memory"}
	134 {return "number out of range of writing system"}
	135 {return "result contains character outside BMP"}
    }
}

foreach ns $nslist {
    set s [WNStrToUNStr 236 $ns]
    if {$::uninum_err == 0} {
	puts [format "%-30s\t%-15s" $ns $s]
    } else {
	puts [format "%-30s\t%15s" $ns [UninumErrorToString $::uninum_err]]
    }
}
