/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.DocumentValidatorFactory;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import java.io.File;
import java.io.IOException;

public class EpubCheckFactory
implements DocumentValidatorFactory {
    private static EpubCheckFactory instance = new EpubCheckFactory();

    public static EpubCheckFactory getInstance() {
        return instance;
    }

    @Override
    public DocumentValidator newInstance(Report report, String path, GenericResourceProvider resourceProvider, String mimeType, EPUBVersion version) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            try {
                return new EpubCheck(resourceProvider.getInputStream(path), report, path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new EpubCheck(new File(path), report);
    }
}

