use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"           => "chat with AI from the command line",
  "author"             => ["Toby Inkster (TOBYINK) <tobyink\@cpan.org>"],
  "dynamic_config"     => 0,
  "generated_by"       => "Dist::Inkt::Profile::TOBYINK version 0.024, CPAN::Meta::Converter version 2.150010",
  "keywords"           => [],
  "license"            => ["perl_5"],
  "meta-spec"          => {
                            url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                            version => 2,
                          },
  "name"               => "App-Chit",
  "no_index"           => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"            => {
                            configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                            develop   => { recommends => { "Dist::Inkt" => 0.001 } },
                            runtime   => {
                                           requires => {
                                             "AI::Chat"             => 0,
                                             "App::Cmd"             => 0,
                                             "Cwd"                  => 0,
                                             "Path::Tiny"           => 0,
                                             "perl"                 => "5.020000",
                                             "Term::ANSIColor"      => 0,
                                             "Term::Spinner::Color" => 0,
                                             "utf8::all"            => 0,
                                             "YAML::XS"             => 0,
                                           },
                                         },
                            test      => {
                                           requires => {
                                             "Test2::Plugin::BailOnFail"     => 0,
                                             "Test2::Require::AuthorTesting" => 0,
                                             "Test2::Require::Module"        => 0,
                                             "Test2::Tools::Spec"            => 0,
                                             "Test2::V0"                     => 0,
                                           },
                                         },
                          },
  "provides"           => {
                            "App::Chit"                       => { file => "lib/App/Chit.pm", version => 0.001001 },
                            "App::Chit::Command::chat"        => { file => "lib/App/Chit/Command/chat.pm", version => 0.001001 },
                            "App::Chit::Command::init"        => { file => "lib/App/Chit/Command/init.pm", version => 0.001001 },
                            "App::Chit::Command::maxhistory"  => { file => "lib/App/Chit/Command/maxhistory.pm", version => 0.001001 },
                            "App::Chit::Command::model"       => { file => "lib/App/Chit/Command/model.pm", version => 0.001001 },
                            "App::Chit::Command::role"        => { file => "lib/App/Chit/Command/role.pm", version => 0.001001 },
                            "App::Chit::Command::show"        => { file => "lib/App/Chit/Command/show.pm", version => 0.001001 },
                            "App::Chit::Command::temperature" => { file => "lib/App/Chit/Command/temperature.pm", version => 0.001001 },
                            "App::Chit::Command::which"       => { file => "lib/App/Chit/Command/which.pm", version => 0.001001 },
                            "App::Chit::Util"                 => { file => "lib/App/Chit/Util.pm", version => 0.001001 },
                          },
  "release_status"     => "stable",
  "resources"          => {
                            bugtracker   => { web => "https://github.com/tobyink/p5-app-chit/issues" },
                            homepage     => "https://metacpan.org/release/App-Chit",
                            license      => ["http://dev.perl.org/licenses/"],
                            repository   => {
                                              type => "git",
                                              url  => "git://github.com/tobyink/p5-app-chit.git",
                                              web  => "https://github.com/tobyink/p5-app-chit",
                                            },
                            x_identifier => "http://purl.org/NET/cpan-uri/dist/App-Chit/project",
                          },
  "version"            => 0.001001,
  "x_provides_scripts" => { chit => { file => "bin/chit" } },
};

my %dynamic_config;

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}


my $mm = WriteMakefile(%WriteMakefileArgs);

exit(0);

