require 'spec_helper'

require Metasploit::Framework.root.join('tools/dev/report_generation/support_matrix/generate.rb').to_path

RSpec.describe ReportGeneration::SupportMatrix do
  let(:data) { {} }
  subject { described_class.new(data) }

  describe '#all_commands' do
    it 'equals the list of available Meterpreter commands' do
      expect(subject.all_commands).to eq(Rex::Post::Meterpreter::CommandMapper.get_command_names)
    end
  end

  describe '#table' do
    # Results generated by scripts/resource/meterpreter_compatibility.rc
    let(:data) do
      {
        sessions: [
          {
            session_type: 'php/linux',
            metadata: { foo: 10 },
            commands: [
              { id: 4, name: 'core_channel_open' },
              { id: 2, name: 'core_channel_eof' },
              { id: 5, name: 'core_channel_read' },
              { id: 8, name: 'core_channel_write' }
            ]
          },
          {
            session_type: 'x64/linux',
            metadata: { foo: 20 },
            commands: [
              { id: 10, name: 'core_enumextcmd' },
              { id: 13, name: 'core_machine_id' },
              { id: 22, name: 'core_set_uuid' },
              { id: 11, name: 'core_get_session_guid' }
            ]
          }
        ]
      }
    end

    it 'returns the matrix as a table' do
      expected_table = {
        columns: [{ heading: '' }, { heading: 'php/linux', metadata: { foo: 10 } }, { heading: 'x64/linux', metadata: { foo: 20 } }],
        rows: array_including([
          { heading: ['core', '11%', '11%'], values: array_including([['core_channel_open', true, false], ['core_enumextcmd', false, true]]) },
          { heading: ['stdapi', '0%', '0%'], values: array_including([['stdapi_sys_eventlog_read', false, false]]) },
          { heading: ['bofloader', '0%', '0%'], values: [['bofloader_execute', false, false]] }
        ])
      }

      expect(subject.table).to include(expected_table)
    end
  end
end
