# Setup

Material for MkDocs offers a wide range of options for customizing your
documentation. In this section, we will explain how you can create a meaningful
structure for your site, change the look and feel, add a blog and comment system,
and build a highly optimized site.

## Site structure

Set up and customize the structure of your documentation by configuring the
header and footer to your taste, choosing among many modes of navigation,
setting up site search, and more.

<div class="grid cards" markdown>

- :fontawesome-solid-earth-americas: __[Language]__ – Choose out of the 60+ supported languages or add a new one
- :material-page-layout-sidebar-left: __[Navigation]__ – Create a clear, concise, and comprehensive navigation structure
- :material-page-layout-header: __[Header]__ – Customize the behavior of the header, add an announcement bar
- :material-page-layout-footer: __[Footer]__ – Add links to your social media profiles or websites in the footer
- :material-tab-search: __[Search]__ – Set up and configure search, running entirely in the user's browser
- :material-tag-plus-outline: __[Tags]__ – Categorize your pages with tags and group related pages

</div>

  [Language]: changing-the-language.md
  [Navigation]: setting-up-navigation.md
  [Header]: setting-up-the-header.md
  [Footer]: setting-up-the-footer.md
  [Search]: setting-up-site-search.md
  [Tags]: setting-up-tags.md


## Appearance

Match your brand's colors, fonts, icons, logo, and more with a few lines of
configuration – Material for MkDocs makes it easy to extend the basic
configuration or alter the appearance.

<div class="grid cards" markdown>

- :material-brush-variant: __[Colors]__ – Change colors with an existing color palette or customize with CSS
- :material-format-font: __[Fonts]__ – Choose among 1,000 Google Fonts or load self-hosted fonts
- :material-google-downasaur: __[Logo & Icons]__ – Change the logo, use any of the 8,000+ icons, or add new ones
- :material-cards-variant: __[Social Cards]__ – Automatically create social media previews when sharing links

</div>

  [Colors]: changing-the-colors.md
  [Fonts]: changing-the-fonts.md
  [Logo & Icons]: changing-the-logo-and-icons.md
  [Social Cards]: setting-up-social-cards.md

## Content

Create a blog, integrate a comment system, connect a git repository, and set up
versioned documentation that matches your project's versioning methodology.

<div class="grid cards" markdown>

- :material-book-open-outline: __[Blog]__ – Set up a standalone blog or host it alongside your documentation
- :material-comment-text-outline: __[Comment System]__ – Add a third-party comment system on any page or footer
- :octicons-versions-16: __[Versioning]__ – Deploy multiple versions by integrating with external utilities
- :octicons-repo-16: __[Repository]__ – Connect your documentation to your git repository

</div>

  [Blog]: setting-up-a-blog.md
  [Comment System]: adding-a-comment-system.md
  [Versioning]: setting-up-versioning.md
  [Repository]: adding-a-git-repository.md

## Optimization

Add site analytics and build an optimized site by adding automatic image
compression, complying with GDPR data privacy regulations, and making it
offline-capable.

<div class="grid cards" markdown>

- :material-google-analytics: __[Site analytics]__ – Learn how your users experience your documentation
- :material-screwdriver: __[Optimized site]__ – Create optimized sites that rank great on search engines
- :octicons-lock-16: __[Data Privacy]__ – Ensure compliance with data privacy regulations
- :octicons-cloud-offline-16: __[Offline usage]__ – Build an online and offline-capable documentation

</div>

  [Site analytics]: setting-up-site-analytics.md
  [Optimized site]: building-an-optimized-site.md
  [Data Privacy]: ensuring-data-privacy.md
  [Offline usage]: building-for-offline-usage.md
