# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy

from . import models as _models
from ._configuration import NetworkCloudMgmtClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AgentPoolsOperations,
    BareMetalMachineKeySetsOperations,
    BareMetalMachinesOperations,
    BmcKeySetsOperations,
    CloudServicesNetworksOperations,
    ClusterManagersOperations,
    ClustersOperations,
    ConsolesOperations,
    KubernetesClusterFeaturesOperations,
    KubernetesClustersOperations,
    L2NetworksOperations,
    L3NetworksOperations,
    MetricsConfigurationsOperations,
    Operations,
    RackSkusOperations,
    RacksOperations,
    StorageAppliancesOperations,
    TrunkedNetworksOperations,
    VirtualMachinesOperations,
    VolumesOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class NetworkCloudMgmtClient:  # pylint: disable=too-many-instance-attributes
    """The Network Cloud APIs provide management of the Azure Operator Nexus compute resources such as
    on-premises clusters, hardware resources, and workload infrastructure resources.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.networkcloud.operations.Operations
    :ivar bare_metal_machines: BareMetalMachinesOperations operations
    :vartype bare_metal_machines: azure.mgmt.networkcloud.operations.BareMetalMachinesOperations
    :ivar cloud_services_networks: CloudServicesNetworksOperations operations
    :vartype cloud_services_networks:
     azure.mgmt.networkcloud.operations.CloudServicesNetworksOperations
    :ivar cluster_managers: ClusterManagersOperations operations
    :vartype cluster_managers: azure.mgmt.networkcloud.operations.ClusterManagersOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.networkcloud.operations.ClustersOperations
    :ivar kubernetes_clusters: KubernetesClustersOperations operations
    :vartype kubernetes_clusters: azure.mgmt.networkcloud.operations.KubernetesClustersOperations
    :ivar l2_networks: L2NetworksOperations operations
    :vartype l2_networks: azure.mgmt.networkcloud.operations.L2NetworksOperations
    :ivar l3_networks: L3NetworksOperations operations
    :vartype l3_networks: azure.mgmt.networkcloud.operations.L3NetworksOperations
    :ivar rack_skus: RackSkusOperations operations
    :vartype rack_skus: azure.mgmt.networkcloud.operations.RackSkusOperations
    :ivar racks: RacksOperations operations
    :vartype racks: azure.mgmt.networkcloud.operations.RacksOperations
    :ivar storage_appliances: StorageAppliancesOperations operations
    :vartype storage_appliances: azure.mgmt.networkcloud.operations.StorageAppliancesOperations
    :ivar trunked_networks: TrunkedNetworksOperations operations
    :vartype trunked_networks: azure.mgmt.networkcloud.operations.TrunkedNetworksOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.networkcloud.operations.VirtualMachinesOperations
    :ivar volumes: VolumesOperations operations
    :vartype volumes: azure.mgmt.networkcloud.operations.VolumesOperations
    :ivar bare_metal_machine_key_sets: BareMetalMachineKeySetsOperations operations
    :vartype bare_metal_machine_key_sets:
     azure.mgmt.networkcloud.operations.BareMetalMachineKeySetsOperations
    :ivar bmc_key_sets: BmcKeySetsOperations operations
    :vartype bmc_key_sets: azure.mgmt.networkcloud.operations.BmcKeySetsOperations
    :ivar metrics_configurations: MetricsConfigurationsOperations operations
    :vartype metrics_configurations:
     azure.mgmt.networkcloud.operations.MetricsConfigurationsOperations
    :ivar agent_pools: AgentPoolsOperations operations
    :vartype agent_pools: azure.mgmt.networkcloud.operations.AgentPoolsOperations
    :ivar kubernetes_cluster_features: KubernetesClusterFeaturesOperations operations
    :vartype kubernetes_cluster_features:
     azure.mgmt.networkcloud.operations.KubernetesClusterFeaturesOperations
    :ivar consoles: ConsolesOperations operations
    :vartype consoles: azure.mgmt.networkcloud.operations.ConsolesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-10-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = NetworkCloudMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.bare_metal_machines = BareMetalMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_services_networks = CloudServicesNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cluster_managers = ClusterManagersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.kubernetes_clusters = KubernetesClustersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.l2_networks = L2NetworksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.l3_networks = L3NetworksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rack_skus = RackSkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.racks = RacksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.storage_appliances = StorageAppliancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.trunked_networks = TrunkedNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.volumes = VolumesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.bare_metal_machine_key_sets = BareMetalMachineKeySetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.bmc_key_sets = BmcKeySetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.metrics_configurations = MetricsConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.agent_pools = AgentPoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.kubernetes_cluster_features = KubernetesClusterFeaturesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.consoles = ConsolesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
