# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._migrations_operations import (
    build_create_request,
    build_delete_request,
    build_get_request,
    build_list_by_target_server_request,
    build_update_request,
)
from .._configuration import PostgreSQLManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class MigrationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.postgresqlflexibleservers.aio.PostgreSQLManagementClient`'s
        :attr:`migrations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PostgreSQLManagementClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        parameters: _models.MigrationResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Creates a new migration.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :param parameters: The required parameters for creating a migration. Required.
        :type parameters: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Creates a new migration.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :param parameters: The required parameters for creating a migration. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        parameters: Union[_models.MigrationResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Creates a new migration.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :param parameters: The required parameters for creating a migration. Is either a
         MigrationResource type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource or IO[bytes]
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MigrationResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "MigrationResource")

        _request = build_create_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            target_db_server_name=target_db_server_name,
            migration_name=migration_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MigrationResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Gets details of a migration.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.MigrationResource] = kwargs.pop("cls", None)

        _request = build_get_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            target_db_server_name=target_db_server_name,
            migration_name=migration_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MigrationResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        parameters: _models.MigrationResourceForPatch,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Updates an existing migration. The request body can contain one to many of the mutable
        properties present in the migration definition. Certain property updates initiate migration
        state transitions.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :param parameters: The required parameters for updating a migration. Required.
        :type parameters: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResourceForPatch
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Updates an existing migration. The request body can contain one to many of the mutable
        properties present in the migration definition. Certain property updates initiate migration
        state transitions.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :param parameters: The required parameters for updating a migration. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        parameters: Union[_models.MigrationResourceForPatch, IO[bytes]],
        **kwargs: Any
    ) -> _models.MigrationResource:
        """Updates an existing migration. The request body can contain one to many of the mutable
        properties present in the migration definition. Certain property updates initiate migration
        state transitions.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :param parameters: The required parameters for updating a migration. Is either a
         MigrationResourceForPatch type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResourceForPatch or
         IO[bytes]
        :return: MigrationResource or the result of cls(response)
        :rtype: ~azure.mgmt.postgresqlflexibleservers.models.MigrationResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MigrationResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "MigrationResourceForPatch")

        _request = build_update_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            target_db_server_name=target_db_server_name,
            migration_name=migration_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MigrationResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_name: str,
        **kwargs: Any
    ) -> None:
        """Deletes a migration.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_name: The name of the migration. Required.
        :type migration_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            target_db_server_name=target_db_server_name,
            migration_name=migration_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_by_target_server(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        migration_list_filter: Optional[Union[str, _models.MigrationListFilter]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.MigrationResource"]:
        """List all the migrations on a given target server.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param migration_list_filter: Migration list filter. Retrieves either active migrations or all
         migrations. Known values are: "Active" and "All". Default value is None.
        :type migration_list_filter: str or
         ~azure.mgmt.postgresqlflexibleservers.models.MigrationListFilter
        :return: An iterator like instance of either MigrationResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.postgresqlflexibleservers.models.MigrationResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.MigrationResourceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_target_server_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    target_db_server_name=target_db_server_name,
                    migration_list_filter=migration_list_filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("MigrationResourceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
