% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSubset.R
\name{checkSubset}
\alias{checkSubset}
\alias{check_subset}
\alias{assertSubset}
\alias{assert_subset}
\alias{testSubset}
\alias{test_subset}
\alias{expect_subset}
\title{Check if an argument is a subset of a given set}
\usage{
checkSubset(x, choices, empty.ok = TRUE, fmatch = FALSE)

check_subset(x, choices, empty.ok = TRUE, fmatch = FALSE)

assertSubset(
  x,
  choices,
  empty.ok = TRUE,
  fmatch = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_subset(
  x,
  choices,
  empty.ok = TRUE,
  fmatch = FALSE,
  .var.name = vname(x),
  add = NULL
)

testSubset(x, choices, empty.ok = TRUE, fmatch = FALSE)

test_subset(x, choices, empty.ok = TRUE, fmatch = FALSE)

expect_subset(
  x,
  choices,
  empty.ok = TRUE,
  fmatch = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{choices}{[\code{atomic}]\cr
Set of possible values. May be empty.}

\item{empty.ok}{[\code{logical(1)}]\cr
Treat zero-length \code{x} as subset of any set \code{choices} (this includes \code{NULL})?
Default is \code{TRUE}.}

\item{fmatch}{[\code{logical(1)}]\cr
Use the set operations implemented in \code{\link[fastmatch]{fmatch}} in package \pkg{fastmatch}.
If \pkg{fastmatch} is not installed, this silently falls back to \code{\link[base]{match}}.
\code{\link[fastmatch]{fmatch}} modifies \code{y} by reference:
A hash table is added as attribute which is used in subsequent calls.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertSubset}/\code{assert_subset} return 
 \code{x} invisibly, whereas
 \code{checkSubset}/\code{check_subset} and 
 \code{testSubset}/\code{test_subset} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertSubset}/\code{assert_subset}
 throws an error message, 
 \code{testSubset}/\code{test_subset}
 returns \code{FALSE},
 and \code{checkSubset}/\code{check_subset} 
 return a string with the error message.
 The function \code{expect_subset} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a subset of a given set
}
\note{
The object \code{x} must be of the same type as the set w.r.t. \code{\link[base]{typeof}}.
Integers and doubles are both treated as numeric.
}
\examples{
testSubset(c("a", "z"), letters)
testSubset("ab", letters)
testSubset("Species", names(iris))

# x is not converted before the comparison (except for numerics)
testSubset(factor("a"), "a")
testSubset(1, "1")
testSubset(1, as.integer(1))
}
\seealso{
Other set: 
\code{\link{checkChoice}()},
\code{\link{checkDisjunct}()},
\code{\link{checkPermutation}()},
\code{\link{checkSetEqual}()}
}
\concept{set}
