% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extprod3d.R
\name{extprod3d}
\alias{extprod3d}
\title{Compute external- or \sQuote{cross}- product of 3D vectors.}
\usage{
extprod3d(x, y, drop = TRUE)
}
\arguments{
\item{x}{\code{n}-by-3 matrix. Each row is one \bold{x}-vector}

\item{y}{\code{n}-by-3 matrix. Each row is one \bold{y}-vector}

\item{drop}{logical. If \code{TRUE} and if the inputs are one row
matrices or vectors, then delete the dimensions of the array
returned.}
}
\value{
If \code{n} is greater than 1 or \code{drop} is
  \code{FALSE}, \code{n}-by-3 matrix; if \code{n} is 1 and
  \code{drop} is \code{TRUE}, a vector of length 3.
}
\description{
Computes the external product
\deqn{ \left(x_2 y_3 - x_3 y_2,\;
             x_3 y_1 - x_1 y_3,\;
             x_1 y_2 - x_2 y_1 \right) }{
            (x2 * y3 - x3 * y2,
             x3 * y1 - x1 * y3,
             x1 * y2 - x2 * y1) }
of the 3D vectors in \bold{x} and \bold{y}.
}
\seealso{
\code{\link[base]{drop}}
}
\author{
Raoul Grasman
}
\keyword{arith}
\keyword{array}
\keyword{math}
