## RabbitMQ 3.8.8

RabbitMQ `3.8.8` is a maintenance release.
It focuses on bug fixes and usability improvements.

This releases introduces a [new node operation mode](https://github.com/rabbitmq/rabbitmq-server/issues/2321), called the *maintenance mode*.
This feature is useful when performing rolling upgrades and is covered
in more detail below.

This is the [last RabbitMQ release to support Erlang 21.3](https://groups.google.com/forum/#!topic/rabbitmq-users/v3K5nZNsfwM).

### Erlang 23 Compatibility

This release is [compatible](https://groups.google.com/forum/#!topic/rabbitmq-users/wlPIWz3UYHQ) with [Erlang 23](http://blog.erlang.org/OTP-23-Highlights/).

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.3` or `23.0` releases are recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 22.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 22.x or 23.x, then RabbitMQ to most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes Worth Mentioning

### Core Server

#### Enhancements

 * Maintenance mode. This is a [new mode operation mode for RabbitMQ nodes](https://github.com/rabbitmq/rabbitmq-server/issues/2321). The mode is explicitly turned
   on and off by the operator using a bunch of new CLI commands (see below). For mixed-version cluster
   compatibility, this feature must be [enabled using a feature flag](https://www.rabbitmq.com/feature-flags.html).

   When a node is being put down for maintenance and in maintenance mode, it will not be available for
   serving client traffic and will try to transfer as many of its responsibilities as practically possible
   and safe.

   Currently this involves the following steps:

    * Suspend all client connection listeners (no new client connections will be accepted)
    * Close all existing client connections: applications are expected to reconnect to other nodes and recover
    * Transfer primary replicas of all classic mirrored queues hosted on the target node
    * Transfer primary replicas of all quorum queues hosted on the target node, and prevent them from participating
      in the subsequently triggered Raft elections
    * Mark the node as down for maintenance
    * At this point, a node shutdown will be least disruptive as the node has already transferred most of its
      responsibilities

   A node in maintenance mode will not be considered for new primary queue replica placement,
   regardless of queue type and the [queue leader locator policy](https://www.rabbitmq.com/ha.html#leader-migration-data-locality) used.

   A node in maintenance mode is expected to be shut down, upgraded or reconfigured, and restarted in a short
   period of time. Nodes are not expected to be running in this mode for long periods of time.

   A node in maintenance mode can be revived, that is, brough back into its regular operational state.
   When a node is revived restarted (e.g. after an upgrade), it will again accept client connections
   and be considered for primary queue replica placements. It will not recover previous client connections
   as RabbitMQ never initiates connections to clients, but clients will be able to reconnect to it.

   This feature is expected to evolve based on the feedback from the community, the field and the
   RabbitMQ core team at VMware. For example, it can be adjusted based on the learnings when
   adding upgrades support to the [RabbitMQ Cluster Operator for Kubernetes](https://www.rabbitmq.com/kubernetes/operator/operator-overview.html).

   GitHub issue: [rabbitmq/rabbitmq-server#2321](https://github.com/rabbitmq/rabbitmq-server/issues/2321)


### CLI

#### Enhancements

 * `rabbitmq-upgrade drain` is a new command that puts a node in maintenance mode (see above).
   `rabbitmq-upgrade revive` is its counterpart that "revives" a node by putting it into the regular
   operating mode.

   `rabbitmqctl suspend_listeners` is a new command that suspends all [client connection listeners](https://www.rabbitmq.com/networking.html#ports)
   (ports) on the node. This means that existing connections won't be affected but no new connections
   will be accepted. This can be useful during upgrades, in particular using the
   [Blue/Green deployment strategy](https://www.rabbitmq.com/blue-green-upgrade.html).

   `rabbitmqctl resume_listeners` resumes all client listeners so that they accept new client connections
   again.

   All these commands will have an effect only if the `maintenance_mode_status` flag is enabled.

   GitHub issue: [rabbitmq/rabbitmq-cli#419](https://github.com/rabbitmq/rabbitmq-cli/pull/419)


### MQTT Plugin

#### Bug Fixes

 * Abrupt client connection termination could result in an Erlang process leak. This resource leak
   affects RabbitMQ versions between `3.8.5` and `3.8.7`, inclusive.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#239](https://github.com/rabbitmq/rabbitmq-mqtt/pull/239)


### Management Plugin

#### Bug Fixes

 * A node that had a lot of on disk data and constrainted resources could spend a very long time
   activating the plugin while queue primary replicas were busy recovering the data.

   GitHub issue: [rabbitmq/rabbitmq-server#2437](https://github.com/rabbitmq/rabbitmq-server/issues/2437)


### OAuth 2 AuthN/AuthZ Plugin

#### Enhancements

 * Simplified scope merging code specific to Keycloak.

   Contributed by Simon @SimonAlling Alling.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-oauth2#52](https://github.com/rabbitmq/rabbitmq-auth-backend-oauth2/pull/52)


## Dependency Upgrades

 * `cuttlefish` was upgraded [from 2.3.0 to 2.4.1](https://github.com/Kyorai/cuttlefish/compare/v2.3.0...v2.4.1)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.8.tar.xz`.
