﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/OutputFile.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentRuntime {
namespace Model {

/**
 * <p>Contains intermediate response for code interpreter if any files have been
 * generated.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InlineAgentFilePart">AWS
 * API Reference</a></p>
 */
class InlineAgentFilePart {
 public:
  AWS_BEDROCKAGENTRUNTIME_API InlineAgentFilePart() = default;
  AWS_BEDROCKAGENTRUNTIME_API InlineAgentFilePart(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API InlineAgentFilePart& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Files containing intermediate response for the user.</p>
   */
  inline const Aws::Vector<OutputFile>& GetFiles() const { return m_files; }
  inline bool FilesHasBeenSet() const { return m_filesHasBeenSet; }
  template <typename FilesT = Aws::Vector<OutputFile>>
  void SetFiles(FilesT&& value) {
    m_filesHasBeenSet = true;
    m_files = std::forward<FilesT>(value);
  }
  template <typename FilesT = Aws::Vector<OutputFile>>
  InlineAgentFilePart& WithFiles(FilesT&& value) {
    SetFiles(std::forward<FilesT>(value));
    return *this;
  }
  template <typename FilesT = OutputFile>
  InlineAgentFilePart& AddFiles(FilesT&& value) {
    m_filesHasBeenSet = true;
    m_files.emplace_back(std::forward<FilesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<OutputFile> m_files;
  bool m_filesHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
