/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.HyperlinkMessages;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.program.Program;

public class URLHyperlink
implements IHyperlink {
    private final String fURLString;
    private final IRegion fRegion;

    public URLHyperlink(IRegion region, String urlString) {
        Assert.isNotNull((Object)urlString);
        Assert.isNotNull((Object)region);
        this.fRegion = region;
        this.fURLString = urlString;
    }

    @Override
    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    @Override
    public void open() {
        if (this.fURLString != null) {
            Program.launch((String)this.fURLString);
            return;
        }
    }

    @Override
    public String getTypeLabel() {
        return null;
    }

    @Override
    public String getHyperlinkText() {
        return MessageFormat.format(HyperlinkMessages.getString("URLHyperlink.hyperlinkText"), this.fURLString);
    }

    public String getURLString() {
        return this.fURLString;
    }
}

