/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class StatisticsPresentation
extends AbstractPresentation {
    private Table table;
    private DBDAttributeBinding curAttribute;

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        this.table = new Table(parent, 65538);
        this.table.setLinesVisible(!UIStyles.isDarkTheme());
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsPresentation.this.curAttribute = null;
                TableItem[] selection = StatisticsPresentation.this.table.getSelection();
                Object[] elements = new Object[selection.length];
                for (int i = 0; i < selection.length; ++i) {
                    elements[i] = selection[i].getData();
                    if (StatisticsPresentation.this.curAttribute != null) continue;
                    StatisticsPresentation.this.curAttribute = (DBDAttributeBinding)elements[i];
                }
                StatisticsPresentation.this.fireSelectionChanged((ISelection)new StructuredSelection(elements));
            }
        });
        UIUtils.createTableColumn((Table)this.table, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)this.table, (int)16384, (String)"Value");
        UIWidgets.setControlContextMenu((Control)this.table, manager -> UIWidgets.fillDefaultTableContextMenu((IContributionManager)manager, (Table)this.table));
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        this.table.removeAll();
        if (this.controller.getModel().getRowCount() > 0) {
            ResultSetRow row = this.controller.getModel().getRow(0);
            List<DBDAttributeBinding> visibleAttributes = this.controller.getModel().getVisibleAttributes();
            for (int i = 0; i < visibleAttributes.size(); ++i) {
                DBDAttributeBinding attr = visibleAttributes.get(i);
                Object value = row.getValues()[i];
                String valueString = DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI);
                String[] lines = valueString.split("\n");
                for (int k = 0; k < lines.length; ++k) {
                    String line = lines[k];
                    if (CommonUtils.isEmptyTrimmed((String)line)) continue;
                    line = line.replace("\t", "    ");
                    TableItem item = new TableItem(this.table, 16384);
                    item.setText(0, k == 0 ? attr.getName() : "");
                    item.setText(1, line);
                    item.setData((Object)attr);
                }
            }
        }
        UIUtils.packColumns((Table)this.table);
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        return Collections.emptyMap();
    }
}

