/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJob;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class PostgreJobStep
implements PostgreObject,
PostgreScriptObject,
DBPNamedObject2,
DBPRefreshableObject,
DBPSaveableObject,
DBPStatefulObject {
    private final PostgreJob job;
    private final long id;
    private String name;
    private String description;
    private String code;
    private StepKind kind;
    private ActionKind onError;
    private String remoteConnectionString;
    private PostgreDatabase targetDatabase;
    private boolean enabled;
    private boolean persisted;

    public PostgreJobStep(@NotNull PostgreJob job, @NotNull ResultSet dbResult) {
        this.job = job;
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"jstid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstname");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstdesc");
        this.code = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstcode");
        this.kind = (StepKind)CommonUtils.valueOf(StepKind.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstkind"));
        this.onError = (ActionKind)CommonUtils.valueOf(ActionKind.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstonerror"));
        this.remoteConnectionString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstconnstr");
        this.targetDatabase = this.getDataSource().getDatabase(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jstdbname"));
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"jstenabled");
        this.persisted = true;
    }

    public PostgreJobStep(@NotNull PostgreJob job, @NotNull String name) {
        this.job = job;
        this.id = 0L;
        this.name = name;
        this.description = "";
        this.code = "";
        this.kind = StepKind.s;
        this.onError = ActionKind.f;
        this.remoteConnectionString = "";
        this.targetDatabase = job.getDatabase();
        this.enabled = true;
        this.persisted = false;
    }

    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, editable=true, updatable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String description) {
        this.description = description;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    @NotNull
    public StepKind getKind() {
        return this.kind;
    }

    public void setKind(@NotNull StepKind kind) {
        this.kind = kind;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4)
    @NotNull
    public ActionKind getOnError() {
        return this.onError;
    }

    public void setOnError(@NotNull ActionKind onError) {
        this.onError = onError;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    @NotNull
    public String getRemoteConnectionString() {
        return this.remoteConnectionString;
    }

    public void setRemoteConnectionString(@NotNull String remoteConnectionString) {
        this.remoteConnectionString = remoteConnectionString;
    }

    @Property(viewable=true, editable=true, updatable=true, order=6, listProvider=DatabaseListProvider.class)
    @Nullable
    public PostgreDatabase getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(@Nullable PostgreDatabase targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.job.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.job.getDatabase();
    }

    @NotNull
    public PostgreJob getParentObject() {
        return this.job;
    }

    @Property(hidden=true, editable=true, updatable=true)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.code;
    }

    @Override
    public void setObjectDefinitionText(String source) {
        this.code = source;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.job.getStepCache().refreshObject(monitor, this.job, this);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.enabled ? DBSObjectState.ACTIVE : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    public static enum StepKind implements DBPNamedObject
    {
        s("SQL"),
        b("Batch");

        private final String name;

        private StepKind(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }

    public static enum ActionKind implements DBPNamedObject
    {
        f("Fail"),
        s("Success"),
        i("Ignore");

        private final String name;

        private ActionKind(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }

    public static class DatabaseListProvider
    implements IPropertyValueListProvider<PostgreJobStep> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(PostgreJobStep object) {
            ArrayList<PostgreDatabase> objects = new ArrayList<PostgreDatabase>(object.getDataSource().getDatabases());
            objects.add(null);
            return objects.toArray();
        }
    }
}

