/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;

public abstract class ObjectBrowserDialogBase
extends Dialog {
    private static final int TREE_EXPANSION_DEPTH = 2;
    private final String title;
    private final DBNNode rootNode;
    private final DBNNode[] selectedNodes;
    private final boolean singleSelection;
    private final List<DBNNode> selectedObjects = new ArrayList<DBNNode>();
    private TreeNodeSpecial specialNode;
    private DatabaseNavigatorTree navigatorTree;
    private static boolean showConnected;

    protected ObjectBrowserDialogBase(@NotNull Shell parentShell, @NotNull String title, @NotNull DBNNode rootNode, @NotNull List<? extends DBNNode> selectedNodes, boolean singleSelection) {
        super(parentShell);
        this.title = title;
        this.rootNode = rootNode;
        this.selectedNodes = (DBNNode[])selectedNodes.toArray(DBNNode[]::new);
        this.singleSelection = singleSelection;
    }

    public static boolean isShowConnected() {
        return showConnected;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        DatabaseNavigatorTreeFilter navigatorFilter = this.createNavigatorFilter();
        this.navigatorTree = new DatabaseNavigatorTree(group, this.rootNode, (this.singleSelection ? 4 : 2) | 0x800, false, navigatorFilter);
        gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 500;
        this.navigatorTree.setLayoutData(gd);
        this.navigatorTree.setFilterObjectType(DatabaseNavigatorTreeFilterObjectType.connection);
        final TreeViewer treeViewer = this.navigatorTree.getViewer();
        ViewerFilter viewerFilter = this.createViewerFilter();
        if (viewerFilter != null) {
            treeViewer.addFilter(viewerFilter);
        }
        if (this.selectedNodes.length > 0) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object[])this.selectedNodes));
            Collections.addAll(this.selectedObjects, this.selectedNodes);
            for (DBNNode node : this.selectedNodes) {
                DBNDataSource dataSource;
                if (node instanceof DBNDataSource && !(dataSource = (DBNDataSource)node).getDataSourceContainer().isConnected()) continue;
                treeViewer.expandToLevel((Object)this.selectedNodes, 1);
            }
        }
        treeViewer.addSelectionChangedListener(event -> {
            this.selectedObjects.clear();
            this.specialNode = null;
            IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
            for (Object node : selection) {
                if (node instanceof DBNNode) {
                    if (this.matchesResultNode((DBNNode)node)) {
                        this.selectedObjects.add((DBNNode)node);
                        continue;
                    }
                    this.selectedObjects.clear();
                    continue;
                }
                if (!(node instanceof TreeNodeSpecial)) continue;
                this.specialNode = (TreeNodeSpecial)node;
            }
            this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
        });
        treeViewer.addDoubleClickListener(event -> {
            if (!this.selectedObjects.isEmpty()) {
                this.okPressed();
            } else if (this.specialNode != null) {
                this.specialNode.handleDefaultAction(this.navigatorTree);
            }
        });
        treeViewer.getTree().setFocus();
        if (this.rootNode instanceof DBNContainer && ((DBNContainer)this.rootNode).getChildrenClass() == DBPDataSourceContainer.class) {
            final Button showConnectedCheck = new Button(group, 32);
            showConnectedCheck.setText(UINavigatorMessages.label_show_connected);
            showConnectedCheck.setSelection(showConnected);
            showConnectedCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    showConnected = showConnectedCheck.getSelection();
                    treeViewer.getControl().setRedraw(false);
                    try {
                        treeViewer.refresh();
                        if (showConnected) {
                            treeViewer.expandToLevel(2, false);
                        }
                    }
                    finally {
                        treeViewer.getControl().setRedraw(true);
                    }
                }
            });
        }
        return group;
    }

    protected boolean matchesResultNode(DBNNode node) {
        if (node instanceof DBSWrapper) {
            DBSObject object = ((DBSWrapper)node).getObject();
            if (object != null && this.matchesType(object, true)) {
                return true;
            }
            return (object = (DBSObject)DBUtils.getAdapter(DBSObject.class, (Object)object)) != null && this.matchesType(object, true);
        }
        if (node instanceof DBNObjectNode) {
            return this.matchesType(((DBNObjectNode)node).getNodeObject(), true);
        }
        return this.matchesType(node, true);
    }

    protected boolean matchesType(Object object, boolean result) {
        return true;
    }

    protected DatabaseNavigatorTreeFilter createNavigatorFilter() {
        return null;
    }

    protected ViewerFilter createViewerFilter() {
        return null;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
        return contents;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<DBNNode> getSelectedObjects() {
        return this.selectedObjects;
    }
}

