/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import tim.prune.gui.colour.DiscretePointColourer;
import tim.prune.gui.colour.PointColourer;

public class ColourerPreview
extends JPanel {
    private static final Dimension _size = new Dimension(400, 30);
    private PointColourer _colourer = null;

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._colourer == null) {
            this.paintWithoutColourer(graphics);
        } else if (this._colourer.isDiscrete()) {
            this.paintWithDiscreteColourer(graphics);
        } else {
            this.paintWithContinuousColourer(graphics);
        }
    }

    private void paintWithoutColourer(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void paintWithDiscreteColourer(Graphics graphics) {
        if (this._colourer instanceof DiscretePointColourer) {
            DiscretePointColourer discretePointColourer = (DiscretePointColourer)this._colourer;
            int n = Math.max(10, this._colourer.getMaxColours());
            discretePointColourer.generateDiscreteColours(n);
            int n2 = this.getWidth() / n;
            int n3 = 0;
            while (n3 < n) {
                graphics.setColor(discretePointColourer.getDiscreteColour(n3));
                graphics.fillRect(n3 * n2, 0, n2, this.getHeight());
                ++n3;
            }
        }
    }

    private void paintWithContinuousColourer(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 0;
        while (n3 < n) {
            graphics.setColor(this._colourer.mixColour((float)n3 * 1.0f / (float)n));
            graphics.fillRect(n3, 0, 2, n2);
            n3 += 2;
        }
    }

    void setColourer(PointColourer pointColourer) {
        this._colourer = pointColourer;
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return _size;
    }
}

