/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.util.TimerTask;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.jdbc.PgStatement;

class StatementCancelTimerTask
extends TimerTask {
    private @Nullable PgStatement statement;

    StatementCancelTimerTask(PgStatement statement) {
        this.statement = statement;
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        this.statement = null;
        return result;
    }

    @Override
    public void run() {
        PgStatement statement = this.statement;
        if (statement != null) {
            try {
                statement.cancelIfStillNeeded(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.statement = null;
    }
}

