/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.RAW;
import oracle.sql.SQLUtil;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.ShardConnectionStatistics;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.DirectoryShardingKeys;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ListShardingKeys;
import oracle.ucp.routing.ListSuperShardingKeys;
import oracle.ucp.routing.RangeShardingKeys;
import oracle.ucp.routing.RangeSuperShardingKeys;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardConnectionStatisticsImpl;
import oracle.ucp.routing.ShardRoutingCacheBase;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.MappedLongAdder;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPErrorHandler;

public abstract class ShardRoutingCache
extends ShardRoutingCacheBase
implements DataDependentRoutingCache,
Diagnosable {
    static final String CLASS_NAME = ShardRoutingCache.class.getName();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    protected final ChunkEventHandler chunkEventHandler = this.prepareChunkEventHandler();
    protected final AtomicReference<ShardingMetadata> shardingMetadata = new AtomicReference<Object>(null);
    private final MappedLongAdder<String> shardConnectionCounter = new MappedLongAdder();
    private final MappedLongAdder<String> shardPendingConnectionCounter = new MappedLongAdder();
    private final MappedLongAdder<String> shardBorrowedConnectionCounter = new MappedLongAdder();
    private final Map<String, String> currentActiveShards = new ConcurrentHashMap<String, String>();
    protected static final short DB_VERSION_19c = 19000;
    public static final int ORAERROR_INVALIDATE_INSTANCE = 45582;
    public static final int ORAERROR_INVALIDATE_CHUNK = 45583;
    public static final int ORA_ERROR_12516 = 12516;
    public static final int ORA_ERROR_12523 = 12523;
    public static final int ORA_ERROR_12521 = 12521;
    public static final int ORA_ERROR_03974 = 3974;
    private static final Set<Integer> ERRORS_TO_HANDLE = new HashSet<Integer>();

    public ShardRoutingCache(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    public ShardRoutingCache() {
        this(DiagnosticsCollectorImpl.getCommon());
    }

    private RoutingKey routingKeysForVersionedChunk(String chunkName) {
        Optional keys = this.keyForChunk(chunkName).stream().findFirst();
        return keys.isPresent() ? (RoutingKey)keys.get() : null;
    }

    protected boolean hasKeyMapped(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        return !this.chunks(superKey, shardingKey).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private Chunk update(RoutingKey routingKey, String string) {
        try {
            void chunkName;
            void routingKey2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "update", "entering args ({0}, {1})", null, null, routingKey, string);
            if (routingKey2 == null || chunkName == null || chunkName.equals("")) {
                Chunk chunk = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "update", "returning {0}", null, null, chunk);
                return chunk;
            }
            Chunk newChunk = new Chunk((String)chunkName);
            Chunk cachedChunk = this.get((RoutingKey)routingKey2);
            if (cachedChunk != null && !cachedChunk.name().equals(chunkName)) {
                this.replace((RoutingKey)routingKey2, cachedChunk, newChunk);
                Chunk chunk = newChunk;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "update", "returning {0}", null, null, chunk);
                return chunk;
            }
            if (cachedChunk == null) {
                Chunk chunkToCheck;
                RoutingKey chunkRoutingKey = this.routingKeysForVersionedChunk((String)chunkName);
                if (this.putIfAbsent((RoutingKey)routingKey2, newChunk) == null && chunkRoutingKey != null && !routingKey2.equals(chunkRoutingKey) && null != (chunkToCheck = this.get(chunkRoutingKey))) {
                    int maxVersion = ((Chunk)this.chunks((String)chunkName).stream().max((o1, o2) -> o1.version() - o2.version()).get()).version();
                    chunkToCheck.setVersion(maxVersion + 1);
                    this.trace(Level.FINEST, CLASS_NAME, "update", "Chunk keys: {0} has split,hence updated chunk name to: {1}", null, null, chunkRoutingKey, chunkToCheck.name());
                }
            }
            Chunk chunk = this.get((RoutingKey)routingKey2);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "update", "returning {0}", null, null, chunk);
            return chunk;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "update", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onConnectionBorrow(Connection connection, ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
        try {
            void cri;
            void connection2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionBorrow", "entering args ({0}, {1})", null, null, connection, connectionRetrievalInfo);
            String shardUniqueId = this.getConnectionInstance((Connection)connection2).dbUniqueId();
            this.shardBorrowedConnectionCounter.get(shardUniqueId).increment();
            if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionBorrow", "returning void", null, null, new Object[0]);
                return;
            }
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            OracleShardingKey key = jdbcCri.getShardingKey();
            OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
            OracleConnection oConn = (OracleConnection)connection2;
            if (oConn != null && jdbcCri.getShardingKey() != null) {
                String chunk = this.getChunkNameForKey(jdbcCri);
                oConn.setChunkInfo(key, superKey, chunk);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionBorrow", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionBorrow", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onConnectionReturn(Connection connection) throws SQLException {
        try {
            void connection2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionReturn", "entering args ({0})", null, null, connection);
            String shardUniqueId = this.getConnectionInstance((Connection)connection2).dbUniqueId();
            this.shardBorrowedConnectionCounter.get(shardUniqueId).decrement();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionReturn", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionReturn", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected void clearCache() {
        super.clear();
    }

    protected boolean isMaxPerShardReached(ServiceMember member) {
        String shardUniqueId = member.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return false;
        }
        int maxPerShard = this.service().connectionSource().limits().getMaxPerShard();
        return this.shardConnectionCounter.get(shardUniqueId).sum() + this.shardPendingConnectionCounter.get(shardUniqueId).sum() >= (long)maxPerShard;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onConnectionRequest(ServiceMember serviceMember) {
        try {
            void instance;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequest", "entering args ({0})", null, null, serviceMember);
            String shardUniqueId = instance.dbUniqueId();
            if (shardUniqueId == null || shardUniqueId.equals("")) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequest", "returning void", null, null, new Object[0]);
                return;
            }
            this.shardPendingConnectionCounter.get(shardUniqueId).increment();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequest", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequest", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onConnectionRequestComplete(ServiceMember serviceMember) {
        try {
            void instance;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequestComplete", "entering args ({0})", null, null, serviceMember);
            String shardUniqueId = instance.dbUniqueId();
            if (shardUniqueId == null || shardUniqueId.equals("")) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequestComplete", "returning void", null, null, new Object[0]);
                return;
            }
            this.shardPendingConnectionCounter.get(shardUniqueId).decrement();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequestComplete", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionRequestComplete", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo cri) {
        ServiceMember affInst = WLSJTAPlugin.getXAInstance();
        if (affInst != null && !this.isMaxPerShardReached(affInst)) {
            return affInst;
        }
        return this.instancesToGrow(cri).stream().sorted((i1, i2) -> i1.activeCount.get() - i2.activeCount.get()).findFirst().orElse(null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onConnectionCreation(Connection var1_1, ConnectionRetrievalInfo var2_2) throws UniversalConnectionPoolException {
        try {
            block21: {
                block20: {
                    block18: {
                        block19: {
                            block17: {
                                block15: {
                                    block16: {
                                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "entering args ({0}, {1})", null, null, new Object[]{var1_1, var2_2});
                                        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                                            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
                                            return;
                                        }
                                        serviceName = this.service().connectionSource().defaultServiceName();
                                        this.shardingMetadata.getAndUpdate((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onConnectionCreation$2(java.sql.Connection java.lang.String oracle.jdbc.pool.ShardingMetadata ), (Loracle/jdbc/pool/ShardingMetadata;)Loracle/jdbc/pool/ShardingMetadata;)((ShardRoutingCache)this, (Connection)connection, (String)serviceName));
                                        connInstance = this.getConnectionInstance((Connection)connection);
                                        shardUniqueId = connInstance.dbUniqueId();
                                        shardName = ShardRoutingCache.getShardNameFromConnection((Connection)connection);
                                        if (this.isMaxPerShardReached(connInstance)) {
                                            UCPErrorHandler.throwUniversalConnectionPoolException(389);
                                        }
                                        this.shardConnectionCounter.get(shardUniqueId).increment();
                                        this.currentActiveShards.putIfAbsent(shardUniqueId, shardName);
                                        jdbcCri = (JDBCConnectionRetrievalInfo)cri;
                                        this.trace(Level.FINEST, ShardRoutingCache.CLASS_NAME, "onConnectionCreation", "Created connection with OracleShardingKey ({0}, {1}) to instance ({2})", null, null, new Object[]{jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey(), Objects.toString(connInstance, "")});
                                        if (this.allInstances(jdbcCri).contains(connInstance)) break block15;
                                        this.buildTopologyForInstance((Connection)connection, serviceName);
                                        if (!this.isLoggingLevelFinest()) break block16;
                                        this.trace(Level.FINEST, ShardRoutingCache.CLASS_NAME, "onConnectionCreation", "connection is created to a new instance, updated routing topology is {0}", null, null, new Object[]{this.cacheEntries()});
                                    }
                                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
                                    return;
                                }
                                if (jdbcCri.getShardingKey() != null) break block17;
                                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
                                return;
                            }
                            WLSJTAPlugin.checkXAAffinity(connInstance);
                            connChunkName = this.fetchDatabaseChunkName((Connection)connection);
                            topoChunkName = this.getChunkNameForKey(jdbcCri);
                            if (topoChunkName != null) break block18;
                            this.buildTopologyForInstance((Connection)connection, serviceName);
                            if (!this.isLoggingLevelFinest()) break block19;
                            this.trace(Level.FINEST, ShardRoutingCache.CLASS_NAME, "onConnectionCreation", "matching chunk not found for borrow CRI sharding key, updated routing topology is {0}", null, null, new Object[]{this.cacheEntries()});
                        }
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
                        return;
                    }
                    if (connChunkName != null) break block20;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
                    return;
                }
                routingKey = this.routingKeysForVersionedChunk(connChunkName);
                metadata = null;
                if (routingKey != null) ** GOTO lbl71
                metadata = this.fetchChunkMetadata((Connection)connection, connChunkName, serviceName);
                if (metadata != null) break block21;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
                return;
            }
            try {
                routingKey = this.makeRoutingKey(metadata);
lbl71:
                // 2 sources

                if ((connChunk = this.update(routingKey, connChunkName)) != null && !connChunk.hasInstance(connInstance)) {
                    if (metadata == null) {
                        metadata = this.fetchChunkMetadata((Connection)connection, connChunkName, serviceName);
                    }
                    connChunk.addInstanceWithPriority(connInstance, metadata.priority);
                    this.addToInstanceRelatedCaches(connChunk, connInstance);
                    connChunk.setAffinitizedInstId(metadata.affinitizedInstId);
                    connChunk.setId(metadata.chunkId);
                    connChunk.setUniqueId(metadata.chunkUniqueId);
                    if (metadata.shardName != null) {
                        connChunk.addShardInfo(metadata.shardName, metadata.priority);
                    }
                    this.populateChunkIdToChunkCache();
                }
                if (this.isLoggingLevelFinest()) {
                    this.trace(Level.FINEST, ShardRoutingCache.CLASS_NAME, "onConnectionCreation", "routing topology sync-up done on create connection, updated routing topology is {0}", null, null, new Object[]{this.cacheEntries()});
                }
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, ShardRoutingCache.CLASS_NAME, "onConnectionCreation", "", null, e, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable var13_14) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionCreation", "throwing", null, var13_14, new Object[0]);
            throw var13_14;
        }
    }

    private static String getShardNameFromConnection(Connection conn) throws SQLException {
        return ((OracleConnection)conn).getServerSessionInfo().getProperty("SHARD_NAME", "");
    }

    protected ServiceMember getConnectionInstance(Connection conn) {
        ServiceMember member = null;
        try {
            Properties props = ((OracleConnection)conn).getServerSessionInfo();
            if (this.service() != null) {
                member = this.service().getMember(props.getProperty("INSTANCE_NAME"), props.getProperty("DATABASE_NAME"), props.getProperty("SERVER_HOST"), props.getProperty("SERVICE_NAME"));
            }
            if (member == null) {
                member = new ServiceMember(props, this.service());
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "getConnectionInstance", "", null, e, new Object[0]);
        }
        return member;
    }

    /*
     * Exception decompiling
     */
    @Debug(level=Debug.Level.FINEST)
    private String fetchDatabaseChunkName(Connection var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private String getChunkNameForKey(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "getChunkNameForKey", "entering args ({0})", null, null, connectionRetrievalInfo);
            List<Chunk> chunks = this.chunks((ConnectionRetrievalInfo)cri);
            if (chunks == null || chunks.size() == 0) {
                String string = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "getChunkNameForKey", "returning {0}", null, null, string);
                return string;
            }
            String string = chunks.get(0).absoluteName();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "getChunkNameForKey", "returning {0}", null, null, string);
            return string;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "getChunkNameForKey", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onConnectionClosure(Connection connection) {
        try {
            void connection2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionClosure", "entering args ({0})", null, null, connection);
            ServiceMember connInstance = this.getConnectionInstance((Connection)connection2);
            if (connInstance == null) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionClosure", "returning void", null, null, new Object[0]);
                return;
            }
            String shardUniqueId = connInstance.dbUniqueId();
            this.shardConnectionCounter.get(shardUniqueId).decrement();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionClosure", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onConnectionClosure", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected void buildTopologyForInstance(Connection connection, String string) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "buildTopologyForInstance", "entering args ({0}, {1})", null, null, connection, string);
            try {
                void serviceName;
                void connection2;
                ServiceMember connInstance = this.getConnectionInstance((Connection)connection2);
                this.trace(Level.FINEST, CLASS_NAME, "buildTopologyForInstance", "Building topo for Instance {0}", null, null, connInstance.name());
                List<Chunk.Metadata> chunkInfoList = this.fetchInstanceChunksMetadata((Connection)connection2, (String)serviceName);
                for (Chunk.Metadata chunkInfo : chunkInfoList) {
                    String chunkName = chunkInfo.chunkName;
                    RoutingKey key = this.makeRoutingKey(chunkInfo);
                    if (this.update(key, chunkName) == null) continue;
                    Chunk connChunk = this.get(key);
                    connChunk.addInstanceWithPriority(connInstance, chunkInfo.priority);
                    this.addToInstanceRelatedCaches(connChunk, connInstance);
                    connChunk.setAffinitizedInstId(chunkInfo.affinitizedInstId);
                    connChunk.setId(chunkInfo.chunkId);
                    connChunk.setUniqueId(chunkInfo.chunkUniqueId);
                    if (chunkInfo.shardName != null) {
                        connChunk.addShardInfo(chunkInfo.shardName, chunkInfo.priority);
                    }
                    this.populateChunkIdToChunkCache();
                }
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "buildTopologyForInstance", "", null, e, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "buildTopologyForInstance", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "buildTopologyForInstance", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected abstract Service service();

    protected ShardingMetadata shardingMetadata() {
        return this.shardingMetadata.get();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Debug(level=Debug.Level.FINEST)
    protected RoutingKey makeRoutingKey(Chunk.Metadata metadata) throws SQLException {
        try {
            void var6_10;
            SuperShardingKeys superShardingKeys;
            void chunkInfo;
            ShardingMetadata sm;
            block14: {
                block15: {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "makeRoutingKey", "entering args ({0})", null, null, metadata);
                    sm = this.shardingMetadata();
                    ShardingMetadata.ShardingType ssType = this.shardingMetadata().getSuperShardingType();
                    if (ssType == ShardingMetadata.ShardingType.NONE) break block15;
                    if (ssType == ShardingMetadata.ShardingType.LIST) {
                        superShardingKeys = new ListSuperShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.superKeyHigh, (ShardingMetadata)sm, (boolean)true, (boolean)true));
                        break block14;
                    } else if (ssType == ShardingMetadata.ShardingType.RANGE) {
                        superShardingKeys = new RangeSuperShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.superKeyHigh, (ShardingMetadata)sm, (boolean)true, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.superKeyLow, (ShardingMetadata)sm, (boolean)true, (boolean)false).get(0));
                        break block14;
                    } else {
                        if (ssType == ShardingMetadata.ShardingType.DIRECTORY) {
                            throw new IllegalStateException("Super Sharding Type DIRECTORY is not supported");
                        }
                        throw new IllegalStateException("Super Shard Type in database not recognized");
                    }
                }
                superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
            }
            ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
            if (sType == ShardingMetadata.ShardingType.LIST) {
                ListShardingKeys listShardingKeys = new ListShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true));
            } else if (sType == ShardingMetadata.ShardingType.RANGE) {
                RangeShardingKeys rangeShardingKeys = new RangeShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyLow, (ShardingMetadata)sm, (boolean)false, (boolean)false).get(0));
            } else if (sType == ShardingMetadata.ShardingType.HASH) {
                HashRangeShardingKeys hashRangeShardingKeys = new HashRangeShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyLow, (ShardingMetadata)sm, (boolean)false, (boolean)false).get(0));
            } else {
                if (sType != ShardingMetadata.ShardingType.DIRECTORY) {
                    throw new IllegalStateException("Shard Type in database not recognized");
                }
                DirectoryShardingKeys directoryShardingKeys = new DirectoryShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true));
            }
            RoutingKey routingKey = new RoutingKey((ShardingKeys)var6_10, superShardingKeys);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "makeRoutingKey", "returning {0}", null, null, routingKey);
            return routingKey;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "makeRoutingKey", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void startEventHandler(ONSDriver oNSDriver) {
        try {
            void onsDriver;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "startEventHandler", "entering args ({0})", null, null, oNSDriver);
            if (onsDriver != null) {
                this.chunkEventHandler.start((ONSDriver)onsDriver);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "startEventHandler", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "startEventHandler", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private Chunk matchingChunk(String chunkName, ServiceMember instance) {
        Optional chunks = this.chunks(instance, chunkName).stream().findFirst();
        return chunks.isPresent() ? (Chunk)chunks.get() : null;
    }

    protected ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(DiagnosticsCollectorImpl.getCommon()){

            /*
             * WARNING - void declaration
             */
            @Override
            @Debug(level=Debug.Level.FINEST)
            protected void onEvent(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "onEvent", "entering args ({0})", null, null, event);
                    String eType = event2.eventType();
                    if (eType.equalsIgnoreCase("routing")) {
                        ShardRoutingCache.this.clearCache();
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "onEvent", "returning void", null, null, new Object[0]);
                        return;
                    }
                    if (!eType.equalsIgnoreCase("chunk")) {
                        throw new ChunkEventHandler.EventProcessingException("Not chunk event, ignoring it");
                    }
                    switch (event2.status()) {
                        case ADD: {
                            this.doAdd((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case ADDVALUES: {
                            this.doAddValues((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case DROP: 
                        case INVALIDATE: {
                            this.doDrop((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case DROPVALUES: {
                            this.doDropValues((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case UP: {
                            this.doUp((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case READONLY: {
                            if (ShardRoutingCache.this.service().connectionSource().isReadOnlyInstanceAllowed()) break;
                            this.doDown((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case DOWN: {
                            this.doDown((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case MERGE: {
                            this.doMerge((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case SPLIT: {
                            this.doSplit((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case PSET_SPLIT: {
                            this.doSplitPartitionSet((ChunkEventHandler.Event)event2);
                            break;
                        }
                        case NEW_PSET: {
                            this.doAddNewPartitionSet((ChunkEventHandler.Event)event2);
                            break;
                        }
                        default: {
                            throw new ChunkEventHandler.EventProcessingException("unknown event status " + (Object)((Object)event2.status()));
                        }
                    }
                    if (this.isLoggingLevelFinest()) {
                        this.trace(Level.FINEST, CLASS_NAME, "prepareChunkEventHandler", "routing topology after processing chunk event {0}", null, null, ShardRoutingCache.this.cacheEntries());
                    }
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "onEvent", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "onEvent", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doAdd(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAdd", "entering args ({0})", null, null, event);
                    ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                    if (ShardingMetadata.ShardingType.LIST != st && ShardingMetadata.ShardingType.RANGE != st) {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                    }
                    String chunkName = event2.chunkName();
                    Chunk chunk = ShardRoutingCache.this.update(this.decodeUserShardingKeys(event2.keys()), chunkName);
                    if (Objects.isNull(chunk)) {
                        throw new ChunkEventHandler.EventProcessingException("unable to update a chunk");
                    }
                    ServiceMember inst = this.probeServiceMember((ChunkEventHandler.Event)event2);
                    if (Objects.isNull(inst)) {
                        inst = ShardRoutingCache.this.service().insertMember(new ServiceMember(event2.instanceName(), event2.database(), event2.host(), ShardRoutingCache.this.service().getFullServiceName(), ShardRoutingCache.this.service()));
                    }
                    chunk.addInstanceWithPriority(inst, event2.priority());
                    ShardRoutingCache.this.addToInstanceRelatedCaches(chunk, inst);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAdd", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAdd", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doAddValues(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    ShardingKeys shardingKeys;
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAddValues", "entering args ({0})", null, null, event);
                    ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                    if (ShardingMetadata.ShardingType.LIST != st && ShardingMetadata.ShardingType.DIRECTORY != st) {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                    }
                    String chunkName = event2.chunkName();
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    Chunk chunk = this.resolveChunk(chunkName, inst);
                    RoutingKey oldRoutingKey = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                    ArrayList<OracleShardingKeyImpl> shardingKeyList = new ArrayList<OracleShardingKeyImpl>();
                    for (Pair<OracleShardingKey, OracleShardingKey> keyPair : oldRoutingKey.getShardingKeys().getKeys()) {
                        shardingKeyList.add((OracleShardingKeyImpl)keyPair.get1st());
                    }
                    shardingKeyList.addAll(this.processShardingKeyValues(event2.keys()));
                    if (ShardingMetadata.ShardingType.LIST == st) {
                        shardingKeys = new ListShardingKeys(shardingKeyList);
                    } else if (ShardingMetadata.ShardingType.DIRECTORY == st) {
                        shardingKeys = new DirectoryShardingKeys(shardingKeyList);
                    } else {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                    }
                    RoutingKey newRoutingKey = new RoutingKey(shardingKeys, oldRoutingKey.getSuperShardingKeys());
                    ShardRoutingCache.this.updateChunkRoutingKey(chunk, newRoutingKey);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAddValues", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAddValues", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doDrop(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDrop", "entering args ({0})", null, null, event);
                    ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                    if (ShardingMetadata.ShardingType.LIST != st && ShardingMetadata.ShardingType.RANGE != st && ShardingMetadata.ShardingType.DIRECTORY != st) {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                    }
                    String chunkName = event2.chunkName();
                    Chunk chunk = this.resolveChunk(chunkName);
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    ShardRoutingCache.this.remove(chunk);
                    chunk.removeInstance(inst);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDrop", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDrop", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doDropValues(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    ShardingKeys shardingKeys;
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDropValues", "entering args ({0})", null, null, event);
                    ShardingMetadata.ShardingType st = ShardRoutingCache.this.shardingMetadata().getShardingType();
                    if (ShardingMetadata.ShardingType.LIST != st && ShardingMetadata.ShardingType.DIRECTORY != st) {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                    }
                    String chunkName = event2.chunkName();
                    Chunk chunk = this.resolveChunk(chunkName);
                    RoutingKey oldRoutingKey = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                    ArrayList<OracleShardingKeyImpl> shardingKeyList = new ArrayList<OracleShardingKeyImpl>();
                    for (Pair<OracleShardingKey, OracleShardingKey> keyPair : oldRoutingKey.getShardingKeys().getKeys()) {
                        shardingKeyList.add((OracleShardingKeyImpl)keyPair.get1st());
                    }
                    shardingKeyList.removeAll(this.processShardingKeyValues(event2.keys()));
                    if (ShardingMetadata.ShardingType.LIST == st) {
                        shardingKeys = new ListShardingKeys(shardingKeyList);
                    } else if (ShardingMetadata.ShardingType.DIRECTORY == st) {
                        shardingKeys = new DirectoryShardingKeys(shardingKeyList);
                    } else {
                        throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
                    }
                    RoutingKey newRoutingKey = new RoutingKey(shardingKeys, oldRoutingKey.getSuperShardingKeys());
                    ShardRoutingCache.this.updateChunkRoutingKey(chunk, newRoutingKey);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDropValues", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDropValues", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            private List<OracleShardingKeyImpl> processShardingKeyValues(String[] sKeys) throws ChunkEventHandler.EventProcessingException {
                ShardingMetadata sm = ShardRoutingCache.this.shardingMetadata();
                ShardingMetadata.ShardingType sType = sm.getShardingType();
                OracleShardingKeyImpl.Decoder decoder = new OracleShardingKeyImpl.Decoder(sm);
                ArrayList<byte[]> bKeys = new ArrayList<byte[]>();
                if (ShardingMetadata.ShardingType.DIRECTORY == sType) {
                    try {
                        for (String sKey : sKeys) {
                            bKeys.add(new RAW((Object)sKey).shareBytes());
                        }
                        return decoder.buildShardKeys(bKeys, false, true);
                    }
                    catch (SQLException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "processShardingKeyValues", "", null, e, new Object[0]);
                        throw new ChunkEventHandler.EventProcessingException(e);
                    }
                }
                if (ShardingMetadata.ShardingType.LIST == sType) {
                    for (String sKey : sKeys) {
                        bKeys.add(Base64.getDecoder().decode(sKey));
                    }
                    try {
                        return decoder.buildShardKeys(bKeys, false, true);
                    }
                    catch (SQLException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "processShardingKeyValues", "", null, e, new Object[0]);
                        throw new ChunkEventHandler.EventProcessingException(e);
                    }
                }
                this.trace(Level.WARNING, CLASS_NAME, "processShardingKeyValues", "wrong sharding type = {0}", null, (Throwable)null, sType);
                throw new ChunkEventHandler.EventProcessingException("wrong sharding type");
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doUp(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doUp", "entering args ({0})", null, null, event);
                    Chunk chunk = this.resolveChunk(event2.chunkName());
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    chunk.addInstanceWithPriority(inst, event2.priority());
                    ShardRoutingCache.this.addToInstanceRelatedCaches(chunk, inst);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doUp", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doUp", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doDown(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDown", "entering args ({0})", null, null, event);
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    Chunk chunk = this.resolveChunk(event2.chunkName(), inst);
                    chunk.removeInstance(inst);
                    ShardRoutingCache.this.removeFromInstanceRelatedCaches(chunk, inst);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDown", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doDown", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doMerge(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    RoutingKey mergedKey;
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doMerge", "entering args ({0})", null, null, event);
                    String chunkName = event2.chunkName();
                    RoutingKey key = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                    String toChunkName = event2.toChunkName();
                    RoutingKey toKey = ShardRoutingCache.this.routingKeysForVersionedChunk(toChunkName);
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    Chunk chunk = this.resolveChunk(chunkName, inst);
                    Chunk toChunk = this.resolveChunk(toChunkName, inst);
                    int priority = chunk.instancePriority(inst);
                    switch (ShardRoutingCache.this.shardingMetadata().getShardingType()) {
                        case LIST: {
                            ArrayList<OracleShardingKeyImpl> combinedList = new ArrayList<OracleShardingKeyImpl>();
                            for (Pair<OracleShardingKey, OracleShardingKey> keyPair : key.getShardingKeys().getKeys()) {
                                combinedList.add((OracleShardingKeyImpl)keyPair.get1st());
                            }
                            for (Pair<OracleShardingKey, OracleShardingKey> keyPair : toKey.getShardingKeys().getKeys()) {
                                combinedList.add((OracleShardingKeyImpl)keyPair.get1st());
                            }
                            mergedKey = new RoutingKey(new ListShardingKeys(combinedList), key.superShardingKeys);
                            break;
                        }
                        case RANGE: {
                            OracleShardingKeyImpl keyLow = (OracleShardingKeyImpl)key.getShardingKeys().getKeys().get(0).get1st();
                            OracleShardingKeyImpl keyHigh = (OracleShardingKeyImpl)toKey.getShardingKeys().getKeys().get(0).get2nd();
                            mergedKey = new RoutingKey(new RangeShardingKeys((OracleShardingKey)keyHigh, (OracleShardingKey)keyLow), key.superShardingKeys);
                            break;
                        }
                        case HASH: {
                            throw new ChunkEventHandler.EventProcessingException("wrong sharding type for merge");
                        }
                        default: {
                            throw new ChunkEventHandler.EventProcessingException("unknown sharding type");
                        }
                    }
                    ShardRoutingCache.this.remove(chunk);
                    chunk.removeInstance(inst);
                    ShardRoutingCache.this.remove(toChunk);
                    toChunk.removeInstance(inst);
                    Chunk mergedChunk = ShardRoutingCache.this.update(mergedKey, toChunkName);
                    if (!Objects.nonNull(mergedChunk)) {
                        throw new ChunkEventHandler.EventProcessingException("unable to update routingKey=" + mergedKey + " for chunk=" + toChunkName);
                    }
                    mergedChunk.addInstanceWithPriority(inst, priority);
                    ShardRoutingCache.this.addToInstanceRelatedCaches(mergedChunk, inst);
                    this.trace(Level.FINEST, CLASS_NAME, "prepareChunkEventHandler", "added Routing key: {0} for chunk: {1}", null, null, mergedKey, toChunkName);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doMerge", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doMerge", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doSplit(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    RoutingKey splitKey2;
                    RoutingKey splitKey1;
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doSplit", "entering args ({0})", null, null, event);
                    String chunkName = event2.chunkName();
                    RoutingKey oldRoutingKey = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    Chunk chunk = this.resolveChunk(chunkName, inst);
                    int priority = chunk.instancePriority(inst);
                    String newChunkName = event2.newChunkName();
                    String hashSplitBoundary = event2.hashSplitBoundary();
                    switch (ShardRoutingCache.this.shardingMetadata().getShardingType()) {
                        case RANGE: 
                        case HASH: {
                            if (null != hashSplitBoundary) {
                                long oraHash = Long.parseLong(hashSplitBoundary);
                                OracleShardingKeyImpl oracleShardingKeyImpl = new OracleShardingKeyBuilderImpl().oraHash(oraHash).subkey((Object)hashSplitBoundary, (SQLType)OracleType.NUMBER).build();
                                List<ShardingKeys> splitKeys = ((HashRangeShardingKeys)oldRoutingKey.shardingKeys).split((OracleShardingKey)oracleShardingKeyImpl);
                                if (splitKeys.size() != 2) {
                                    throw new ChunkEventHandler.EventProcessingException("Hash boundary could not be used to split the chunk");
                                }
                                splitKey1 = new RoutingKey(splitKeys.get(0), oldRoutingKey.superShardingKeys);
                                splitKey2 = new RoutingKey(splitKeys.get(1), oldRoutingKey.superShardingKeys);
                                break;
                            }
                            RoutingKey splitRoutingKey = this.decodeUserShardingKeys(event2.splitvalue());
                            OracleShardingKey splitKey = splitRoutingKey.getShardingKeys().getKeys().get(0).get1st();
                            OracleShardingKeyImpl oracleShardingKeyImpl = (OracleShardingKeyImpl)oldRoutingKey.getShardingKeys().getKeys().get(0).get1st();
                            OracleShardingKeyImpl key2 = (OracleShardingKeyImpl)oldRoutingKey.getShardingKeys().getKeys().get(0).get2nd();
                            splitKey1 = new RoutingKey(new RangeShardingKeys(splitKey, (OracleShardingKey)oracleShardingKeyImpl), oldRoutingKey.superShardingKeys);
                            splitKey2 = new RoutingKey(new RangeShardingKeys((OracleShardingKey)key2, splitKey), oldRoutingKey.superShardingKeys);
                            break;
                        }
                        case LIST: {
                            splitKey2 = this.decodeUserShardingKeys(event2.splitvalue());
                            ArrayList<OracleShardingKeyImpl> remainingList = new ArrayList<OracleShardingKeyImpl>();
                            for (Pair pair : oldRoutingKey.getShardingKeys().getKeys()) {
                                OracleShardingKeyImpl k = (OracleShardingKeyImpl)pair.get1st();
                                if (splitKey2.getShardingKeys().contains((OracleShardingKey)k)) continue;
                                remainingList.add(k);
                            }
                            splitKey1 = new RoutingKey(new ListShardingKeys(remainingList), oldRoutingKey.superShardingKeys);
                            break;
                        }
                        default: {
                            throw new ChunkEventHandler.EventProcessingException("unknown sharding type");
                        }
                    }
                    ShardRoutingCache.this.remove(chunk);
                    chunk.removeInstance(inst);
                    Chunk splittedChunk1 = ShardRoutingCache.this.update(splitKey1, chunkName);
                    if (!Objects.nonNull(splittedChunk1)) {
                        throw new ChunkEventHandler.EventProcessingException("unable to update routingKey=" + splitKey1 + " for chunk=" + chunkName);
                    }
                    splittedChunk1.addInstanceWithPriority(inst, priority);
                    ShardRoutingCache.this.addToInstanceRelatedCaches(splittedChunk1, inst);
                    this.trace(Level.FINEST, CLASS_NAME, "prepareChunkEventHandler", "added Routing key: {0} for chunk: {1}", null, null, splitKey1, chunkName);
                    Chunk splittedChunk2 = ShardRoutingCache.this.update(splitKey2, newChunkName);
                    if (!Objects.nonNull(splittedChunk2)) {
                        throw new ChunkEventHandler.EventProcessingException("unable to update routingKey=" + splitKey2 + " for chunk=" + newChunkName);
                    }
                    splittedChunk2.addInstanceWithPriority(inst, priority);
                    ShardRoutingCache.this.addToInstanceRelatedCaches(splittedChunk2, inst);
                    this.trace(Level.FINEST, CLASS_NAME, "prepareChunkEventHandler", "added Routing key: {0} for chunk: {1}", null, null, splitKey2, newChunkName);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doSplit", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doSplit", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private ServiceMember probeServiceMember(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "probeServiceMember", "entering args ({0})", null, null, event);
                    if (Objects.isNull(event2)) {
                        throw new ChunkEventHandler.EventProcessingException("no event to process");
                    }
                    ServiceMember serviceMember = ShardRoutingCache.this.service().getMember(event2.instanceName(), event2.database(), ShardRoutingCache.this.service().getFullServiceName());
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "probeServiceMember", "returning {0}", null, null, serviceMember);
                    return serviceMember;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "probeServiceMember", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doSplitPartitionSet(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doSplitPartitionSet", "entering args ({0})", null, null, event);
                    SuperShardingKeys superShardingKeys = this.decodeSuperShardingKeys(event2.keys());
                    String chunkName = event2.chunkName();
                    RoutingKey oldRoutingKey = ShardRoutingCache.this.routingKeysForVersionedChunk(chunkName);
                    ServiceMember inst = this.resolveServiceMember((ChunkEventHandler.Event)event2);
                    Chunk chunk = this.resolveChunk(chunkName);
                    RoutingKey newRoutingKey = new RoutingKey(oldRoutingKey.getShardingKeys(), superShardingKeys);
                    ShardRoutingCache.this.updateChunkRoutingKey(chunk, newRoutingKey);
                    chunk.addInstanceWithPriority(inst, event2.priority());
                    ShardRoutingCache.this.addToInstanceRelatedCaches(chunk, inst);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doSplitPartitionSet", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doSplitPartitionSet", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private void doAddNewPartitionSet(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    String chunkName;
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAddNewPartitionSet", "entering args ({0})", null, null, event);
                    SuperShardingKeys superShardingKeys = this.decodeSuperShardingKeys(event2.keys());
                    long lowHash = event2.lowHash();
                    long highHash = event2.highHash();
                    if (lowHash == -1L || highHash == -1L) {
                        throw new ChunkEventHandler.EventProcessingException("invalid low and high hash value in NEW_PSET event");
                    }
                    ShardingKeys shardingKeys = this.buildShardingKeysFromHash(lowHash, highHash);
                    RoutingKey newRoutingKey = new RoutingKey(shardingKeys, superShardingKeys);
                    Chunk chunk = ShardRoutingCache.this.update(newRoutingKey, chunkName = event2.chunkName());
                    if (Objects.nonNull(chunk)) {
                        ServiceMember inst = this.probeServiceMember((ChunkEventHandler.Event)event2);
                        if (Objects.isNull(inst)) {
                            inst = ShardRoutingCache.this.service().insertMember(new ServiceMember(event2.instanceName(), event2.database(), event2.host(), ShardRoutingCache.this.service().getFullServiceName(), ShardRoutingCache.this.service()));
                        }
                        chunk.addInstanceWithPriority(inst, event2.priority());
                        ShardRoutingCache.this.addToInstanceRelatedCaches(chunk, inst);
                    }
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAddNewPartitionSet", "returning void", null, null, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "doAddNewPartitionSet", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private ShardingKeys buildShardingKeysFromHash(long l, long l2) {
                try {
                    void high;
                    void low;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "buildShardingKeysFromHash", "entering args ({0}, {1})", null, null, l, l2);
                    OracleShardingKeyImpl shardingKeyLow = new OracleShardingKeyBuilderImpl().oraHash((long)low).subkey((Object)((long)low), (SQLType)OracleType.NUMBER).build();
                    OracleShardingKeyImpl shardingKeyHigh = new OracleShardingKeyBuilderImpl().oraHash((long)high).subkey((Object)((long)high), (SQLType)OracleType.NUMBER).build();
                    HashRangeShardingKeys hashRangeShardingKeys = new HashRangeShardingKeys((OracleShardingKey)shardingKeyHigh, (OracleShardingKey)shardingKeyLow);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "buildShardingKeysFromHash", "returning {0}", null, null, hashRangeShardingKeys);
                    return hashRangeShardingKeys;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "buildShardingKeysFromHash", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private ServiceMember resolveServiceMember(ChunkEventHandler.Event event) throws ChunkEventHandler.EventProcessingException {
                try {
                    void event2;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveServiceMember", "entering args ({0})", null, null, event);
                    ServiceMember eventInst = this.probeServiceMember((ChunkEventHandler.Event)event2);
                    if (Objects.isNull(eventInst)) {
                        throw new ChunkEventHandler.EventProcessingException("wrong instance in the event");
                    }
                    ServiceMember serviceMember = eventInst;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveServiceMember", "returning {0}", null, null, serviceMember);
                    return serviceMember;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveServiceMember", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private Chunk resolveChunk(String string) throws ChunkEventHandler.EventProcessingException {
                try {
                    void chunkName;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveChunk", "entering args ({0})", null, null, string);
                    Chunk chunk = this.resolveChunk((String)chunkName, null);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveChunk", "returning {0}", null, null, chunk);
                    return chunk;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveChunk", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private Chunk resolveChunk(String string, ServiceMember serviceMember) throws ChunkEventHandler.EventProcessingException {
                try {
                    void inst;
                    void chunkName;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveChunk", "entering args ({0}, {1})", null, null, string, serviceMember);
                    if (Objects.isNull(chunkName) || chunkName.length() == 0) {
                        throw new ChunkEventHandler.EventProcessingException("no chunk name");
                    }
                    Chunk chunk = ShardRoutingCache.this.matchingChunk((String)chunkName, (ServiceMember)inst);
                    if (Objects.isNull(chunk)) {
                        throw new ChunkEventHandler.EventProcessingException("no matching chunk for name=" + (String)chunkName);
                    }
                    Chunk chunk2 = chunk;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveChunk", "returning {0}", null, null, chunk2);
                    return chunk2;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "resolveChunk", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private RoutingKey decodeUserShardingKeys(String[] stringArray) throws ChunkEventHandler.EventProcessingException {
                try {
                    ShardingKeys shardingKeys;
                    SuperShardingKeys superShardingKeys;
                    block18: {
                        ShardingMetadata.ShardingType sType;
                        block20: {
                            List keys;
                            ArrayList<byte[]> bKeys;
                            OracleShardingKeyImpl.Decoder decoder;
                            block19: {
                                void sKeys;
                                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeUserShardingKeys", "entering args ({0})", null, null, new Object[]{stringArray});
                                superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
                                ShardingMetadata sm = ShardRoutingCache.this.shardingMetadata();
                                sType = sm.getShardingType();
                                decoder = new OracleShardingKeyImpl.Decoder(sm);
                                bKeys = new ArrayList<byte[]>();
                                if (ShardingMetadata.ShardingType.DIRECTORY == sType) {
                                    List keys2;
                                    try {
                                        for (void sKey : sKeys) {
                                            bKeys.add(RAW.newRAW((Object)sKey).shareBytes());
                                        }
                                        keys2 = decoder.buildShardKeys(bKeys, false, true);
                                    }
                                    catch (SQLException e) {
                                        this.trace(Level.WARNING, CLASS_NAME, "decodeUserShardingKeys", "", null, e, new Object[0]);
                                        throw new ChunkEventHandler.EventProcessingException(e);
                                    }
                                    DirectoryShardingKeys shardingKeys2 = new DirectoryShardingKeys(keys2);
                                    RoutingKey routingKey = new RoutingKey(shardingKeys2, superShardingKeys);
                                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeUserShardingKeys", "returning {0}", null, null, routingKey);
                                    return routingKey;
                                }
                                for (void sKey : sKeys) {
                                    bKeys.add(Base64.getDecoder().decode((String)sKey));
                                }
                                if (ShardingMetadata.ShardingType.LIST != sType) break block19;
                                try {
                                    keys = decoder.buildShardKeys(bKeys, false, false);
                                }
                                catch (SQLException e) {
                                    this.trace(Level.WARNING, CLASS_NAME, "prepareChunkEventHandler", "", null, e, new Object[0]);
                                    throw new ChunkEventHandler.EventProcessingException(e);
                                }
                                shardingKeys = new ListShardingKeys(keys);
                                break block18;
                            }
                            if (ShardingMetadata.ShardingType.RANGE != sType) break block20;
                            switch (bKeys.size()) {
                                case 1: {
                                    try {
                                        keys = decoder.buildShardKeys(bKeys, false, false);
                                    }
                                    catch (SQLException e) {
                                        this.trace(Level.WARNING, CLASS_NAME, "prepareChunkEventHandler", "", null, e, new Object[0]);
                                        throw new ChunkEventHandler.EventProcessingException(e);
                                    }
                                    shardingKeys = new ListShardingKeys(keys);
                                    break block18;
                                }
                                case 2: {
                                    try {
                                        List keysLow = decoder.buildShardKeys(Arrays.asList(new byte[][]{(byte[])bKeys.get(0)}), false, false);
                                        List keysHigh = decoder.buildShardKeys(Arrays.asList(new byte[][]{(byte[])bKeys.get(1)}), false, false);
                                        shardingKeys = new RangeShardingKeys((OracleShardingKey)keysHigh.get(0), (OracleShardingKey)keysLow.get(0));
                                        break block18;
                                    }
                                    catch (SQLException e) {
                                        this.trace(Level.WARNING, CLASS_NAME, "prepareChunkEventHandler", "", null, e, new Object[0]);
                                        throw new ChunkEventHandler.EventProcessingException(e);
                                    }
                                }
                                default: {
                                    throw new ChunkEventHandler.EventProcessingException("wrong range keys/splitvalue");
                                }
                            }
                        }
                        if (ShardingMetadata.ShardingType.HASH == sType) {
                            throw new ChunkEventHandler.EventProcessingException("hash range is not allowed for user-defined sharding");
                        }
                        throw new ChunkEventHandler.EventProcessingException("improper shard type");
                    }
                    RoutingKey routingKey = new RoutingKey(shardingKeys, superShardingKeys);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeUserShardingKeys", "returning {0}", null, null, routingKey);
                    return routingKey;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeUserShardingKeys", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Debug(level=Debug.Level.FINEST)
            private SuperShardingKeys decodeSuperShardingKeys(String[] stringArray) throws ChunkEventHandler.EventProcessingException {
                try {
                    SuperShardingKeys superShardingKeys;
                    void ssKeys;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeSuperShardingKeys", "entering args ({0})", null, null, new Object[]{stringArray});
                    ShardingMetadata sm = ShardRoutingCache.this.shardingMetadata();
                    ShardingMetadata.ShardingType ssType = sm.getSuperShardingType();
                    OracleShardingKeyImpl.Decoder decoder = new OracleShardingKeyImpl.Decoder(sm);
                    ArrayList<byte[]> bKeys = new ArrayList<byte[]>();
                    for (void sKey : ssKeys) {
                        bKeys.add(Base64.getDecoder().decode((String)sKey));
                    }
                    if (ShardingMetadata.ShardingType.LIST == ssType) {
                        List keys;
                        try {
                            keys = decoder.buildShardKeys(bKeys, true, true);
                        }
                        catch (SQLException e) {
                            this.trace(Level.WARNING, CLASS_NAME, "prepareChunkEventHandler", "", null, e, new Object[0]);
                            throw new ChunkEventHandler.EventProcessingException(e);
                        }
                        superShardingKeys = new ListSuperShardingKeys(keys);
                    } else if (ShardingMetadata.ShardingType.RANGE == ssType) {
                        try {
                            List keysHigh = decoder.buildShardKeys(Arrays.asList(new byte[][]{(byte[])bKeys.get(1)}), true, true);
                            List keysLow = decoder.buildShardKeys(Arrays.asList(new byte[][]{(byte[])bKeys.get(0)}), true, false);
                            superShardingKeys = new RangeSuperShardingKeys((OracleShardingKey)keysHigh.get(0), (OracleShardingKey)keysLow.get(0));
                        }
                        catch (SQLException e) {
                            this.trace(Level.WARNING, CLASS_NAME, "prepareChunkEventHandler", "", null, e, new Object[0]);
                            throw new ChunkEventHandler.EventProcessingException(e);
                        }
                    } else {
                        if (ShardingMetadata.ShardingType.HASH == ssType) {
                            throw new ChunkEventHandler.EventProcessingException("hash is not a valid super sharding key type");
                        }
                        throw new ChunkEventHandler.EventProcessingException("invalid super sharding type");
                    }
                    ListSuperShardingKeys listSuperShardingKeys = superShardingKeys;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeSuperShardingKeys", "returning {0}", null, null, listSuperShardingKeys);
                    return listSuperShardingKeys;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache$1", "decodeSuperShardingKeys", "throwing", null, throwable, new Object[0]);
                    throw throwable;
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onHAEvent(FailoverDriver.Event event) {
        try {
            ServiceMember eventInst;
            void haEvent;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onHAEvent", "entering args ({0})", null, null, event);
            if ((haEvent.status() == FailoverDriver.Event.Status.DOWN || haEvent.status() == FailoverDriver.Event.Status.NODEDOWN) && (eventInst = this.service().getMember(haEvent.instance(), haEvent.database(), haEvent.host(), haEvent.serviceName())) != null) {
                this.remove(eventInst);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onHAEvent", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onHAEvent", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean selected(CoreConnection connection, Set<ServiceMember> instanceSet) {
        if (instanceSet == null || instanceSet.size() <= 0) {
            return false;
        }
        return instanceSet.contains(connection.serviceMember());
    }

    private List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return new ArrayList<Chunk>();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        if (Objects.isNull(key) || Objects.isNull(this.shardingMetadata())) {
            return null;
        }
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.DIRECTORY) {
            OracleShardingKey lookupKey = jdbcCri.getLookupShardingKey();
            if (lookupKey == null) {
                lookupKey = this.computeLookupKey(key);
            }
            return this.chunks(superKey, lookupKey);
        }
        return this.chunks(superKey, key);
    }

    @Override
    protected long getShardkeyOraHash(OracleShardingKey key) {
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            return ((OracleShardingKeyImpl)key).shardKeyOraHash(this.shardingMetadata());
        }
        return -1L;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey shardKey = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        if (shardKey == null) {
            return true;
        }
        ShardingMetadata metadata = this.shardingMetadata.get();
        if (metadata == null) {
            return false;
        }
        OracleShardingKey lookupShardingKey = this.computeLookupKey(shardKey);
        jdbcCri.getBorrowContextUpdater().lookupShardingKey(lookupShardingKey);
        if (!((OracleShardingKeyImpl)shardKey).isValid(metadata)) {
            throw new IllegalArgumentException("Sharding Keys provided do not match the sharded database metadata");
        }
        if (superKey != null && !((OracleShardingKeyImpl)superKey).isValid(metadata)) {
            throw new IllegalArgumentException("Super Sharding Keys provided do not match the sharded database metadata");
        }
        return this.hasKeyMapped(lookupShardingKey, superKey);
    }

    protected OracleShardingKey computeLookupKey(OracleShardingKey shardKey) {
        OracleShardingKey lookupKey;
        ShardingMetadata metadata = this.shardingMetadata.get();
        if (metadata.getShardingType() == ShardingMetadata.ShardingType.DIRECTORY) {
            byte[] sha256Hash = ((OracleShardingKeyImpl)shardKey).sha256Hash(metadata);
            lookupKey = new OracleShardingKeyBuilderImpl().subkey((Object)sha256Hash, (SQLType)OracleType.RAW).build();
        } else {
            lookupKey = shardKey;
        }
        return lookupKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "instancesToGrow", "entering args ({0})", null, null, connectionRetrievalInfo);
            Set<ServiceMember> instances = this.allPriorityInstances((ConnectionRetrievalInfo)cri);
            if (instances != null && instances.size() >= 0) {
                Set<ServiceMember> set = instances.stream().filter(e -> !this.isMaxPerShardReached((ServiceMember)e)).collect(Collectors.toSet());
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "instancesToGrow", "returning {0}", null, null, set);
                return set;
            }
            Set<ServiceMember> set = Collections.emptySet();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "instancesToGrow", "returning {0}", null, null, set);
            return set;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "instancesToGrow", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean hasInstanceToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "hasInstanceToGrow", "entering args ({0})", null, null, connectionRetrievalInfo);
            Set<ServiceMember> instances = this.allPriorityInstances((ConnectionRetrievalInfo)cri);
            if (instances != null && instances.size() == 0) {
                boolean bl = true;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "hasInstanceToGrow", "returning {0}", null, null, bl);
                return bl;
            }
            boolean bl = instances.stream().anyMatch(sm -> !this.isMaxPerShardReached((ServiceMember)sm));
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "hasInstanceToGrow", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "hasInstanceToGrow", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "allPriorityInstances", "entering args ({0})", null, null, connectionRetrievalInfo);
            List<Chunk> reqChunks = this.chunks((ConnectionRetrievalInfo)cri);
            HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
            if (reqChunks != null) {
                reqChunks.stream().forEach(c -> {
                    Set<ServiceMember> priorityInstances = c.priorityInstances();
                    if (priorityInstances != null && priorityInstances.size() > 0) {
                        allInstances.addAll(priorityInstances);
                    }
                });
            }
            HashSet<ServiceMember> hashSet = allInstances;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "allPriorityInstances", "returning {0}", null, null, hashSet);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "allPriorityInstances", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "allInstances", "entering args ({0})", null, null, connectionRetrievalInfo);
            List<Chunk> reqChunks = this.chunks((ConnectionRetrievalInfo)cri);
            HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
            if (reqChunks != null) {
                reqChunks.stream().forEach(c -> {
                    Set<ServiceMember> instanceSet = c.instances();
                    if (instanceSet != null && instanceSet.size() > 0) {
                        allInstances.addAll(instanceSet);
                    }
                });
            }
            HashSet<ServiceMember> hashSet = allInstances;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "allInstances", "returning {0}", null, null, hashSet);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "allInstances", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String cacheEntries() {
        return this.routingTableToHumanReadableString();
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public String metadataInfo() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "metadataInfo", "entering args ()", null, null, new Object[0]);
            ShardingMetadata sm = this.shardingMetadata();
            String string = null == sm ? "" : "[superType=" + sm.getSuperShardingType() + ", type=" + sm.getShardingType() + "]";
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "metadataInfo", "returning {0}", null, null, string);
            return string;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "metadataInfo", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void destroy() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "destroy", "entering args ()", null, null, new Object[0]);
            this.clear();
            this.chunkEventHandler.stop();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "destroy", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "destroy", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onError(int n, ConnectionRetrievalInfo connectionRetrievalInfo, ServiceMember serviceMember) {
        try {
            void instance;
            void cri;
            void oraErrorNumber;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onError", "entering args ({0}, {1}, {2})", null, null, n, connectionRetrievalInfo, serviceMember);
            if (!ERRORS_TO_HANDLE.contains((int)oraErrorNumber)) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onError", "returning void", null, null, new Object[0]);
                return;
            }
            String chunkName = this.getChunkNameForKey((ConnectionRetrievalInfo)cri);
            Chunk chunk = this.matchingChunk(chunkName, (ServiceMember)instance);
            switch (oraErrorNumber) {
                case 3974: 
                case 12516: 
                case 12523: 
                case 45582: {
                    if (chunk == null) break;
                    chunk.removeInstance((ServiceMember)instance);
                    this.removeFromInstanceRelatedCaches(chunk, (ServiceMember)instance);
                    break;
                }
                case 45583: {
                    if (chunk == null) break;
                    this.remove(chunk);
                    chunk.removeInstance((ServiceMember)instance);
                    break;
                }
                case 12521: {
                    this.remove((ServiceMember)instance);
                    break;
                }
            }
            if (cri instanceof JDBCConnectionRetrievalInfo) {
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
                this.trace(Level.FINEST, CLASS_NAME, "onError", String.format("Got ORA-%d error for OracleShardingKey = (%s,%s), chunk name = (%s), instance name = (%s)", (int)oraErrorNumber, jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey(), chunkName, instance != null ? instance.name() : ""), null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onError", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "onError", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private List<Chunk.Metadata> fetchInstanceChunksMetadata(Connection connection, String string) throws SQLException {
        try {
            void serviceName;
            void oConn;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchInstanceChunksMetadata", "entering args ({0}, {1})", null, null, connection, string);
            if (oConn == null) {
                List<Chunk.Metadata> list = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchInstanceChunksMetadata", "returning {0}", null, null, list);
                return list;
            }
            ArrayList<Chunk.Metadata> chunkInfoList = new ArrayList<Chunk.Metadata>();
            try (PreparedStatement stmt = this.prepareStatementForChunkMetaData((Connection)oConn, (String)serviceName);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Chunk.Metadata chunkInfo = new Chunk.Metadata();
                    chunkInfo.chunkName = rs.getString("CHUNK_NAME").toLowerCase();
                    Blob shardKeyLowBlob = rs.getBlob("SHARD_KEY_LOW");
                    chunkInfo.shardKeyLow = shardKeyLowBlob != null ? shardKeyLowBlob.getBinaryStream() : null;
                    Blob shardKeyHighBlob = rs.getBlob("SHARD_KEY_HIGH");
                    chunkInfo.shardKeyHigh = shardKeyHighBlob != null ? shardKeyHighBlob.getBinaryStream() : null;
                    Blob superKeyLow = rs.getBlob("GROUP_KEY_LOW");
                    chunkInfo.superKeyLow = superKeyLow != null ? superKeyLow.getBinaryStream() : null;
                    Blob superKeyHigh = rs.getBlob("GROUP_KEY_HIGH");
                    chunkInfo.superKeyHigh = superKeyHigh != null ? superKeyHigh.getBinaryStream() : null;
                    chunkInfo.priority = rs.getInt("PRIORITY");
                    chunkInfo.affinitizedInstId = rs.getInt("INST_ID");
                    chunkInfo.chunkId = rs.getInt("CHUNK_ID");
                    chunkInfo.shardName = rs.getString("SHARD_NAME");
                    chunkInfo.chunkUniqueId = rs.getInt("CHUNK_UNIQUE_ID");
                    chunkInfoList.add(chunkInfo);
                }
            }
            ArrayList<Chunk.Metadata> arrayList = chunkInfoList;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchInstanceChunksMetadata", "returning {0}", null, null, arrayList);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchInstanceChunksMetadata", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected PreparedStatement prepareStatementForChunkMetaData(Connection oConn, String serviceName) throws SQLException {
        boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported(oConn);
        String sql = isMultipleTableFamilySupported ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?) and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL";
        PreparedStatement ps = oConn.prepareStatement(sql);
        if (isMultipleTableFamilySupported) {
            ps.setString(1, serviceName);
        }
        return ps;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private Chunk.Metadata fetchChunkMetadata(Connection connection, String string, String string2) throws SQLException {
        try {
            Chunk.Metadata chunkInfo;
            void chunkName;
            void oConn;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchChunkMetadata", "entering args ({0}, {1}, {2})", null, null, connection, string, string2);
            if (oConn == null) {
                Chunk.Metadata metadata = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchChunkMetadata", "returning {0}", null, null, metadata);
                return metadata;
            }
            boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported((Connection)oConn);
            String sql = isMultipleTableFamilySupported ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + chunkName.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + chunkName.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL";
            try (PreparedStatement stmt = oConn.prepareStatement(sql);){
                if (isMultipleTableFamilySupported) {
                    void serviceName;
                    stmt.setString(1, (String)serviceName);
                }
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        chunkInfo = new Chunk.Metadata();
                        chunkInfo.chunkName = rs.getString("CHUNK_NAME").toLowerCase();
                        chunkInfo.shardKeyLow = rs.getBlob("SHARD_KEY_LOW") != null ? rs.getBlob(2).getBinaryStream() : null;
                        InputStream inputStream = chunkInfo.shardKeyHigh = rs.getBlob("SHARD_KEY_HIGH") != null ? rs.getBlob(3).getBinaryStream() : null;
                        if (rs.getBlob(4) != null) {
                            chunkInfo.superKeyLow = rs.getBlob("GROUP_KEY_LOW").getBinaryStream();
                        }
                        if (rs.getBlob(5) != null) {
                            chunkInfo.superKeyHigh = rs.getBlob("GROUP_KEY_HIGH").getBinaryStream();
                        }
                        chunkInfo.priority = rs.getInt("PRIORITY");
                        chunkInfo.affinitizedInstId = rs.getInt("INST_ID");
                        chunkInfo.chunkId = rs.getInt("CHUNK_ID");
                        chunkInfo.shardName = rs.getString("SHARD_NAME");
                        chunkInfo.chunkUniqueId = rs.getInt("CHUNK_UNIQUE_ID");
                    } else {
                        chunkInfo = null;
                    }
                }
            }
            Chunk.Metadata metadata = chunkInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchChunkMetadata", "returning {0}", null, null, metadata);
            return metadata;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchChunkMetadata", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected ShardingMetadata fetchShardingMetadata(Connection connection, String string) throws SQLException {
        try {
            ShardingMetadata shardingMetadata;
            block60: {
                String sqlColTypes;
                String sqlTypes;
                void oConn;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchShardingMetadata", "entering args ({0}, {1})", null, null, connection, string);
                if (oConn == null) {
                    ShardingMetadata shardingMetadata2 = null;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchShardingMetadata", "returning {0}", null, null, shardingMetadata2);
                    return shardingMetadata2;
                }
                boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported((Connection)oConn);
                if (isMultipleTableFamilySupported) {
                    sqlTypes = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
                    sqlColTypes = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
                } else {
                    sqlTypes = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES ";
                    sqlColTypes = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS ";
                }
                try (PreparedStatement stmt = oConn.prepareStatement(sqlTypes);){
                    void serviceName;
                    if (isMultipleTableFamilySupported) {
                        stmt.setString(1, (String)serviceName);
                    }
                    try (ResultSet rsTypes = stmt.executeQuery();){
                        if (rsTypes.next()) {
                            String superTypeStr = rsTypes.getString("GROUP_TYPE");
                            ShardingMetadata.ShardingType superType = ShardingMetadata.ShardingType.valueOf((String)superTypeStr);
                            String shardTypeStr = rsTypes.getString("SHARD_TYPE");
                            ShardingMetadata.ShardingType shardType = ShardingMetadata.ShardingType.valueOf((String)shardTypeStr);
                            int metaVersion = rsTypes.getInt("DEF_VERSION");
                            ArrayList<ShardingMetadata.SubKeyMetadata> colInfos = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                            ArrayList<ShardingMetadata.SubKeyMetadata> colGrpInfos = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                            try (PreparedStatement stmt1 = oConn.prepareStatement(sqlColTypes);){
                                if (isMultipleTableFamilySupported) {
                                    stmt1.setString(1, (String)serviceName);
                                }
                                try (ResultSet rsCols = stmt1.executeQuery();){
                                    while (rsCols.next()) {
                                        int shardLevel = rsCols.getInt("SHARD_LEVEL");
                                        ShardingMetadata.SubKeyMetadata subKeyMetadata = new ShardingMetadata.SubKeyMetadata(rsCols.getInt("COL_IDX_IN_KEY"), SQLUtil.getExternalType((int)rsCols.getInt("EFF_TYPE")), rsCols.getInt("CHARACTER_SET"));
                                        if (shardLevel == 0) {
                                            colGrpInfos.add(subKeyMetadata);
                                            continue;
                                        }
                                        if (shardLevel == 1) {
                                            colInfos.add(subKeyMetadata);
                                            continue;
                                        }
                                        throw new IllegalStateException("Invalid Shard Key Level in database");
                                    }
                                }
                            }
                            shardingMetadata = new ShardingMetadata(metaVersion, shardType, superType, colInfos, colGrpInfos);
                            break block60;
                        }
                        shardingMetadata = null;
                    }
                }
            }
            ShardingMetadata shardingMetadata3 = shardingMetadata;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchShardingMetadata", "returning {0}", null, null, shardingMetadata3);
            return shardingMetadata3;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ShardRoutingCache", "fetchShardingMetadata", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected boolean multipleTableFamilySupported(Connection conn) throws SQLException {
        short dbVersion = ((OracleConnection)conn).getVersionNumber();
        return dbVersion >= 19000;
    }

    public Map<String, ShardConnectionStatistics> getShardConnectionStats() {
        HashMap<String, ShardConnectionStatistics> connectionStatsMap = new HashMap<String, ShardConnectionStatistics>();
        Set<Map.Entry<String, String>> currentActiveShardsSet = this.currentActiveShards.entrySet();
        for (Map.Entry<String, String> shardEntry : currentActiveShardsSet) {
            String shardName = shardEntry.getValue();
            int activeCount = this.shardConnectionCounter.get(shardEntry.getKey()).intValue();
            int borrowedCount = this.shardBorrowedConnectionCounter.get(shardEntry.getKey()).intValue();
            connectionStatsMap.put(shardName, new ShardConnectionStatisticsImpl(shardName, activeCount, borrowedCount));
        }
        return connectionStatsMap;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    private /* synthetic */ ShardingMetadata lambda$onConnectionCreation$2(Connection connection, String serviceName, ShardingMetadata m) {
        if (null == m) {
            try {
                return this.fetchShardingMetadata(connection, serviceName);
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "onConnectionCreation", "", null, e, new Object[0]);
                return m;
            }
        }
        return m;
    }

    static {
        ERRORS_TO_HANDLE.add(45582);
        ERRORS_TO_HANDLE.add(45583);
        ERRORS_TO_HANDLE.add(12516);
        ERRORS_TO_HANDLE.add(12523);
        ERRORS_TO_HANDLE.add(12521);
        ERRORS_TO_HANDLE.add(3974);
    }
}

