/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import oracle.ons.BodyElement;
import oracle.ons.BodySegment;

public class BodyBlock {
    private static final byte Body_Begin = 0;
    private static final byte Body_Segment = 1;
    private static final byte Body_Element = 2;
    private static final byte Body_Unknown = 3;
    private static final int Length_Size = 2;
    private static final int Rec_Header_Size = 3;
    private static final int Dat_Header_Size = 2;
    private static final int Body_Sign_Size = 12;
    private static final byte[] Body_Sign = new byte[]{0, -93, 124, 8, -25, 120, -18, 36, 95, -45, -74, 78};
    private BodySegment rootSeg = new BodySegment("root", -1);
    private List<BodySegment> segList = this.rootSeg.getSegmentList();

    public byte[] generateBody() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterator<BodySegment> iterator = null;
        byteArrayOutputStream.write(Body_Sign, 0, Body_Sign.length);
        iterator = this.segList.iterator();
        while (iterator.hasNext()) {
            try {
                BodyBlock.encodeSegment(byteArrayOutputStream, iterator.next(), 0);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private static void encodeSegment(OutputStream outputStream, BodySegment bodySegment, int n) throws IOException {
        BodyElement bodyElement2 = null;
        outputStream.write(1);
        BodyBlock.writeLength(outputStream, bodySegment.getNameLength() + 1);
        outputStream.write(bodySegment.getName().getBytes(), 0, bodySegment.getNameLength());
        outputStream.write(0);
        outputStream.write(n);
        for (BodyElement bodyElement2 : bodySegment.getElementList()) {
            outputStream.write(2);
            BodyBlock.writeLength(outputStream, bodyElement2.getNameLength());
            outputStream.write(bodyElement2.getName().getBytes(), 0, bodyElement2.getNameLength());
            outputStream.write(0);
            BodyBlock.writeLength(outputStream, bodyElement2.getValueLength());
            outputStream.write(bodyElement2.getValue().getBytes(), 0, bodyElement2.getValueLength());
            outputStream.write(0);
        }
        Iterator<BodySegment> iterator = bodySegment.getSegmentList().iterator();
        while (iterator.hasNext()) {
            BodyBlock.encodeSegment(outputStream, iterator.next(), n + 1);
        }
    }

    public static BodyBlock generateBodyBlock(byte[] byArray) {
        BodyBlock bodyBlock = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 0;
        boolean bl = false;
        if (byArray == null || byArray.length < 12) {
            return null;
        }
        int n2 = byArray.length;
        --n;
        ++n2;
        while (true) {
            if (byArray[++n] != 0 && --n2 >= 12) {
                continue;
            }
            if (n2 < 12) {
                return null;
            }
            if (BodyBlock.bytesCmp(byArray, Body_Sign, n, 12)) break;
        }
        bodyBlock = new BodyBlock();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n += 12, n2 -= 12);
        try {
            int n3 = ((InputStream)byteArrayInputStream).read();
            if (n3 == -1) {
                throw new IllegalArgumentException("Notification missing data");
            }
            BodySegment bodySegment = BodyBlock.readSegment(byteArrayInputStream);
            BodyBlock.generateSegment(byteArrayInputStream, bodyBlock.rootSeg, bodySegment);
        }
        catch (IOException iOException) {
            return null;
        }
        return bodyBlock;
    }

    private static BodySegment generateSegment(InputStream inputStream, BodySegment bodySegment, BodySegment bodySegment2) throws IOException {
        BodySegment bodySegment3 = bodySegment2;
        while (bodySegment3.getLevel() == bodySegment.getLevel() + 1) {
            bodySegment.addSegment(bodySegment3);
            int n = inputStream.read();
            while (n == 2) {
                BodyElement bodyElement = BodyBlock.readElement(inputStream);
                bodySegment3.addElement(bodyElement);
                n = inputStream.read();
            }
            if (n == -1) break;
            BodySegment bodySegment4 = bodySegment3;
            bodySegment3 = BodyBlock.readSegment(inputStream);
            if (bodySegment3 == null) {
                return null;
            }
            if (bodySegment3.getLevel() <= bodySegment.getLevel() + 1) continue;
            bodySegment3 = BodyBlock.generateSegment(inputStream, bodySegment4, bodySegment3);
        }
        return bodySegment3;
    }

    private static BodySegment readSegment(InputStream inputStream) throws IOException {
        int n;
        int n2 = BodyBlock.getLength(inputStream);
        byte[] byArray = BodyBlock.getIdentifier(inputStream, n2);
        if (byArray[n2 - 1] == 0) {
            --n2;
        }
        if ((n = inputStream.read()) == -1) {
            throw new IllegalArgumentException("Notification missing data");
        }
        String string = new String(byArray, 0, n2);
        return new BodySegment(string, n);
    }

    private static BodyElement readElement(InputStream inputStream) throws IOException {
        int n = BodyBlock.getLength(inputStream);
        byte[] byArray = BodyBlock.getIdentifier(inputStream, n);
        String string = new String(byArray);
        BodyBlock.eatNullByte(inputStream);
        n = BodyBlock.getLength(inputStream);
        byArray = BodyBlock.getIdentifier(inputStream, n);
        String string2 = new String(byArray);
        BodyBlock.eatNullByte(inputStream);
        return new BodyElement(string, string2);
    }

    public void putBodyElement(String string, String string2, String string3) {
        BodySegment bodySegment2 = null;
        BodyElement bodyElement = null;
        Iterator<BodySegment> iterator = null;
        for (BodySegment bodySegment2 : this.segList) {
            if (bodySegment2.getNameLength() == string.length() && bodySegment2.getName().equals(string)) break;
            bodySegment2 = null;
        }
        if (bodySegment2 == null) {
            bodySegment2 = new BodySegment(string);
            if (bodySegment2 == null) {
                return;
            }
            this.segList.add(bodySegment2);
        }
        if ((bodyElement = new BodyElement(string2, string3)) == null) {
            return;
        }
        bodySegment2.addElement(bodyElement);
    }

    public String getBodyElementValue(String string, String string2) {
        BodySegment bodySegment2 = null;
        Iterator<BodySegment> iterator = null;
        for (BodySegment bodySegment2 : this.segList) {
            if (bodySegment2.getNameLength() == string.length() && bodySegment2.getName().equals(string)) break;
            bodySegment2 = null;
        }
        if (bodySegment2 == null) {
            return null;
        }
        return bodySegment2.getElementValue(string2);
    }

    public List<BodySegment> getSegmentList() {
        return this.segList;
    }

    public void addSegment(BodySegment bodySegment) {
        if (bodySegment == null) {
            return;
        }
        this.segList.add(bodySegment);
    }

    public List getElementList(String string) {
        BodySegment bodySegment2 = null;
        Iterator<BodySegment> iterator = null;
        for (BodySegment bodySegment2 : this.segList) {
            if (bodySegment2.getNameLength() == string.length() && bodySegment2.getName().equals(string)) break;
            bodySegment2 = null;
        }
        if (bodySegment2 == null) {
            return null;
        }
        return bodySegment2.getElementList();
    }

    public void putOldSegment(String string) {
    }

    public static void writeLength(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)(n >>> 8));
        outputStream.write((byte)n);
    }

    public static int getLength(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            throw new IllegalArgumentException("Notification missing data");
        }
        return (n << 8) + n2;
    }

    public static boolean bytesCmp(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n3] != byArray2[i]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static byte[] getIdentifier(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray, 0, n);
        if (n2 != n) {
            throw new IllegalArgumentException("Notification missing data");
        }
        return byArray;
    }

    private static void eatNullByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != 0) {
            throw new IllegalArgumentException("Notification bad data");
        }
    }
}

