/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.indices.stats.AllIndicesStats;
import org.opensearch.client.opensearch.indices.stats.IndicesStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndicesStatsResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndicesStatsResponse> {
    @Nonnull
    private final AllIndicesStats all;
    @Nonnull
    private final Map<String, IndicesStats> indices;
    @Nonnull
    private final ShardStatistics shards;
    public static final JsonpDeserializer<IndicesStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesStatsResponse::setupIndicesStatsResponseDeserializer);

    private IndicesStatsResponse(Builder builder) {
        this.all = ApiTypeHelper.requireNonNull(builder.all, this, "all");
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static IndicesStatsResponse of(Function<Builder, ObjectBuilder<IndicesStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final AllIndicesStats all() {
        return this.all;
    }

    @Nonnull
    public final Map<String, IndicesStats> indices() {
        return this.indices;
    }

    @Nonnull
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_all");
        this.all.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndicesStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndicesStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::all, AllIndicesStats._DESERIALIZER, "_all");
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndicesStats._DESERIALIZER), "indices");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.all.hashCode();
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesStatsResponse other = (IndicesStatsResponse)o;
        return this.all.equals(other.all) && Objects.equals(this.indices, other.indices) && this.shards.equals(other.shards);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndicesStatsResponse> {
        private AllIndicesStats all;
        @Nullable
        private Map<String, IndicesStats> indices;
        private ShardStatistics shards;

        public Builder() {
        }

        private Builder(IndicesStatsResponse o) {
            this.all = o.all;
            this.indices = Builder._mapCopy(o.indices);
            this.shards = o.shards;
        }

        private Builder(Builder o) {
            this.all = o.all;
            this.indices = Builder._mapCopy(o.indices);
            this.shards = o.shards;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder all(AllIndicesStats value) {
            this.all = value;
            return this;
        }

        @Nonnull
        public final Builder all(Function<AllIndicesStats.Builder, ObjectBuilder<AllIndicesStats>> fn) {
            return this.all(fn.apply(new AllIndicesStats.Builder()).build());
        }

        @Nonnull
        public final Builder indices(Map<String, IndicesStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, IndicesStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, Function<IndicesStats.Builder, ObjectBuilder<IndicesStats>> fn) {
            return this.indices(key, fn.apply(new IndicesStats.Builder()).build());
        }

        @Nonnull
        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        @Nonnull
        public IndicesStatsResponse build() {
            this._checkSingleUse();
            return new IndicesStatsResponse(this);
        }
    }
}

