/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.Option;
import com.azure.core.models.JsonPatchOperation;
import com.azure.core.models.JsonPatchOperationKind;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class JsonPatchDocument
implements JsonSerializable<JsonPatchDocument> {
    private static final Object SERIALIZER_INSTANTIATION_SYNCHRONIZER = new Object();
    private static volatile JsonSerializer defaultSerializer;
    @JsonIgnore
    private final JsonSerializer serializer;
    @JsonValue
    private final List<JsonPatchOperation> operations = new ArrayList<JsonPatchOperation>();

    public JsonPatchDocument() {
        this(null);
    }

    public JsonPatchDocument(JsonSerializer serializer) {
        this.serializer = serializer;
    }

    List<JsonPatchOperation> getOperations() {
        return new ArrayList<JsonPatchOperation>(this.operations);
    }

    public JsonPatchDocument appendAdd(String path, Object value) {
        return this.appendAddInternal(path, this.serializeValue(value));
    }

    public JsonPatchDocument appendAddRaw(String path, String rawJson) {
        return this.appendAddInternal(path, Option.of(rawJson));
    }

    private JsonPatchDocument appendAddInternal(String path, Option<String> rawJsonOption) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.ADD, null, path, rawJsonOption);
    }

    public JsonPatchDocument appendReplace(String path, Object value) {
        return this.appendReplaceInternal(path, this.serializeValue(value));
    }

    public JsonPatchDocument appendReplaceRaw(String path, String rawJson) {
        return this.appendReplaceInternal(path, Option.of(rawJson));
    }

    private JsonPatchDocument appendReplaceInternal(String path, Option<String> rawJsonOption) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REPLACE, null, path, rawJsonOption);
    }

    public JsonPatchDocument appendCopy(String from, String path) {
        Objects.requireNonNull(from, "'from' cannot be null.");
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.COPY, from, path, Option.uninitialized());
    }

    public JsonPatchDocument appendMove(String from, String path) {
        Objects.requireNonNull(from, "'from' cannot be null.");
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.MOVE, from, path, Option.uninitialized());
    }

    public JsonPatchDocument appendRemove(String path) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REMOVE, null, path, Option.uninitialized());
    }

    public JsonPatchDocument appendTest(String path, Object value) {
        return this.appendTestInternal(path, this.serializeValue(value));
    }

    public JsonPatchDocument appendTestRaw(String path, String rawJson) {
        return this.appendTestInternal(path, Option.of(rawJson));
    }

    private JsonPatchDocument appendTestInternal(String path, Option<String> rawJsonOption) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.TEST, null, path, rawJsonOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<String> serializeValue(Object value) {
        byte[] bytes;
        if (value == null) {
            return Option.empty();
        }
        if (this.serializer == null) {
            if (defaultSerializer == null) {
                Object object = SERIALIZER_INSTANTIATION_SYNCHRONIZER;
                synchronized (object) {
                    if (defaultSerializer == null) {
                        defaultSerializer = JsonSerializerProviders.createInstance();
                    }
                }
            }
            bytes = defaultSerializer.serializeToBytes(value);
        } else {
            bytes = this.serializer.serializeToBytes(value);
        }
        return Option.of(new String(bytes, StandardCharsets.UTF_8));
    }

    private JsonPatchDocument appendOperation(JsonPatchOperationKind operationKind, String from, String path, Option<String> optionalValue) {
        this.operations.add(new JsonPatchOperation(operationKind, from, path, optionalValue));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.operations.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            this.operations.get(i).buildString(builder);
        }
        return builder.append("]").toString();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return CoreUtils.isNullOrEmpty(this.operations) ? jsonWriter : jsonWriter.writeArray(this.operations, JsonWriter::writeJson);
    }

    public static JsonPatchDocument fromJson(JsonReader jsonReader) throws IOException {
        List operations = jsonReader.readArray(JsonPatchOperation::fromJson);
        JsonPatchDocument document = new JsonPatchDocument();
        if (operations != null) {
            document.operations.addAll(operations);
        }
        return document;
    }
}

