/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.text.StringMatcher;

public class TextMatcherExt {
    private final StringMatcher full;
    private final List<StringMatcher> parts;

    public TextMatcherExt(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        this.full = new StringMatcher(pattern.trim(), ignoreCase, ignoreWildCards);
        this.parts = this.splitPattern(pattern, ignoreCase, ignoreWildCards);
    }

    private List<StringMatcher> splitPattern(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        String pat = pattern.trim();
        if (pat.isEmpty()) {
            return Collections.emptyList();
        }
        String[] subPatterns = pat.split("\\s+");
        if (subPatterns.length <= 1) {
            if (pat.contains("|")) {
                subPatterns = pat.split("\\|");
            } else if (pat.contains(",")) {
                subPatterns = pat.split(",");
            }
        }
        if (subPatterns.length <= 1) {
            return Collections.emptyList();
        }
        ArrayList<StringMatcher> matchers = new ArrayList<StringMatcher>();
        for (String string : subPatterns) {
            if (string == null || string.isEmpty()) continue;
            String string2 = "*" + string;
            StringMatcher m = new StringMatcher(string2, ignoreCase, ignoreWildCards);
            m.usePrefixMatch();
            matchers.add(m);
        }
        return matchers;
    }

    public boolean match(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        return this.match(text, 0, text.length());
    }

    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        int tlen = text.length();
        if (this.full.match(text, start = Math.max(0, start), end = Math.min(end, tlen))) {
            return true;
        }
        if (this.parts.isEmpty()) {
            return false;
        }
        for (StringMatcher subMatcher : this.parts) {
            if (!subMatcher.match(text, start, end)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + this.full.toString() + "," + String.valueOf(this.parts) + "]";
    }
}

