/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.StringJoiner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.net.GlobalProxyAuthenticator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDrivers
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(PrefPageDrivers.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.drivers";
    private Button versionUpdateCheck;
    private List sourceList;
    private Text proxyHostText;
    private Spinner proxyPortSpinner;
    private Text proxyUserText;
    private Text proxyPasswordText;
    private Text customDriversHome;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Composite settings = UIUtils.createTitledComposite((Composite)composite, (String)UIConnectionMessages.pref_page_ui_general_group_settings, (int)2, (int)768, (int)300);
        this.versionUpdateCheck = UIUtils.createCheckbox((Composite)settings, (String)UIConnectionMessages.pref_page_ui_general_check_new_driver_versions, (String)UIConnectionMessages.pref_page_ui_general_check_new_driver_versions_tip, (boolean)store.getBoolean("ui.drivers.version.update"), (int)1);
        Composite proxyObjects = UIUtils.createTitledComposite((Composite)composite, (String)UIConnectionMessages.pref_page_ui_general_group_http_proxy, (int)4, (int)770, (int)300);
        this.proxyHostText = UIUtils.createLabelText((Composite)proxyObjects, (String)UIConnectionMessages.pref_page_ui_general_label_proxy_host, (String)store.getString("ui.proxy.host"));
        this.proxyPortSpinner = UIUtils.createLabelSpinner((Composite)proxyObjects, (String)UIConnectionMessages.pref_page_ui_general_spinner_proxy_port, (int)store.getInt("ui.proxy.port"), (int)0, (int)65535);
        this.proxyUserText = UIUtils.createLabelText((Composite)proxyObjects, (String)UIConnectionMessages.pref_page_ui_general_label_proxy_user, null);
        this.proxyPasswordText = UIUtils.createLabelText((Composite)proxyObjects, (String)UIConnectionMessages.pref_page_ui_general_label_proxy_password, null, (int)0x400800);
        Composite drivers = UIUtils.createTitledComposite((Composite)composite, (String)UIConnectionMessages.pref_page_drivers_group_location, (int)2, (int)768, (int)300);
        this.customDriversHome = DialogUtils.createOutputFolderChooser((Composite)drivers, (String)UIConnectionMessages.pref_page_drivers_local_folder, null, null, null, (boolean)false, null);
        this.customDriversHome.setText(store.getString("ui.drivers.home"));
        Composite repoGroup = UIUtils.createTitledComposite((Composite)composite, (String)UIConnectionMessages.pref_page_drivers_group_file_repositories, (int)2, (int)768, (int)300);
        this.sourceList = new List(repoGroup, 2820);
        this.sourceList.setLayoutData((Object)new GridData(1808));
        ToolBar toolbar = new ToolBar(repoGroup, 512);
        toolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_drivers_button_add, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = EnterNameDialog.chooseName((Shell)PrefPageDrivers.this.getShell(), (String)UIConnectionMessages.pref_page_drivers_label_enter_drivers_location_url, (String)"http://");
                if (url != null) {
                    PrefPageDrivers.this.sourceList.add(url);
                }
            }
        });
        final ToolItem removeButton = UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_drivers_button_remove, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PrefPageDrivers.this.sourceList.getSelectionIndex();
                PrefPageDrivers.this.sourceList.remove(index);
                PrefPageDrivers.this.sourceList.select(CommonUtils.clamp((int)index, (int)0, (int)(PrefPageDrivers.this.sourceList.getItemCount() - 1)));
                PrefPageDrivers.this.sourceList.notifyListeners(13, new Event());
            }
        });
        removeButton.setEnabled(false);
        this.sourceList.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ PrefPageDrivers this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.this$0.sourceList.getSelectionIndex() >= 0) {
                    removeButton.setEnabled(this.this$0.sourceList.getItemCount() > 1);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
        Control tip = UIUtils.createInfoLabel((Composite)repoGroup, (String)UIConnectionMessages.pref_page_drivers_repo_info);
        tip.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        DBPAuthInfo credentials = null;
        try {
            credentials = GlobalProxyAuthenticator.readCredentials();
        }
        catch (DBException e) {
            log.error((Object)"Error reading proxy credentials", (Throwable)e);
        }
        if (credentials != null) {
            this.proxyUserText.setText(CommonUtils.notEmpty((String)credentials.getUserName()));
            this.proxyPasswordText.setText(CommonUtils.notEmpty((String)credentials.getUserPassword()));
        }
        this.sourceList.removeAll();
        for (String source : DriverDescriptor.getDriversSources()) {
            this.sourceList.add(source);
        }
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.versionUpdateCheck.setSelection(store.getDefaultBoolean("ui.drivers.version.update"));
        this.proxyHostText.setText(store.getDefaultString("ui.proxy.host"));
        this.proxyPortSpinner.setSelection(store.getDefaultInt("ui.proxy.port"));
        this.proxyUserText.setText(store.getDefaultString("ui.proxy.user"));
        this.proxyPasswordText.setText("");
        this.customDriversHome.setText(store.getDefaultString("ui.drivers.home"));
        this.sourceList.removeAll();
        for (String source : DriverDescriptor.getDriversSources()) {
            this.sourceList.add(source);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            GlobalProxyAuthenticator.saveCredentials((String)this.proxyUserText.getText(), (String)this.proxyPasswordText.getText());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Unable to save proxy credentials", e.getMessage(), (Throwable)e);
            return false;
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ui.drivers.version.update", this.versionUpdateCheck.getSelection());
        store.setValue("ui.proxy.host", this.proxyHostText.getText());
        store.setValue("ui.proxy.port", this.proxyPortSpinner.getSelection());
        store.setValue("ui.drivers.home", this.customDriversHome.getText());
        StringJoiner sources = new StringJoiner("|");
        for (String item : this.sourceList.getItems()) {
            sources.add(item);
        }
        store.setValue("ui.drivers.sources", sources.toString());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

