/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.AbstractHttpAIClient;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIRequestFilter;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIMessage;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIMessageContent;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIModel;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIModelList;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesChunk;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesResponse;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class OpenAIClient
extends AbstractHttpAIClient {
    private static final Log log = Log.getLog(OpenAIClient.class);
    public static final String OPENAI_ENDPOINT = "https://api.openai.com/v1/";
    private static final String DATA_EVENT = "data: ";
    private static final String EVENT_EVENT = "event: ";
    protected static final Duration TIMEOUT = Duration.ofSeconds(30L);
    protected static final Gson GSON = JSONUtils.GSON;
    public static final String EVENT_TYPE_RESPONSE_COMPLETED = "response.completed";
    public static final String EVENT_TYPE_ITEM_DONE = "response.output_item.done";
    public static final String EVENT_TYPE_ARGUMENTS_DELTA = "response.function_call_arguments.delta";
    public static final String EVENT_TYPE_TEXT_DELTA = "response.output_text.delta";
    protected final String baseUrl;
    protected final List<HttpRequestFilter> requestFilters;

    public OpenAIClient(@NotNull String baseUrl, @NotNull List<HttpRequestFilter> requestFilters) {
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        this.baseUrl = baseUrl;
        this.requestFilters = requestFilters;
    }

    @NotNull
    static AIFunctionCall createFunctionCall(OAIMessage message) throws DBException {
        Map arguments;
        String argumentsStr = message.arguments;
        try {
            arguments = (Map)JSONUtils.GSON.fromJson(argumentsStr, JSONUtils.MAP_TYPE_TOKEN);
        }
        catch (JsonSyntaxException e) {
            throw new DBException("Error parsing function call arguments", (Throwable)e);
        }
        return new AIFunctionCall(message.name, arguments);
    }

    @NotNull
    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    @Override
    @NotNull
    protected DBException mapHttpError(int statusCode, @NotNull String body) {
        log.debug((Object)("OpenAI request failed: " + statusCode + ", " + body));
        return new DBException("OpenAI request failed: " + AIHttpUtils.parseOpenAIStyleErrorMessage(body));
    }

    public static OpenAIClient createClient(@NotNull String baseUrl, @NotNull String token) {
        return new OpenAIClient(baseUrl, List.of(new OpenAIRequestFilter(token)));
    }

    @NotNull
    public List<OAIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "models")).GET().timeout(TIMEOUT).build();
        HttpRequest modifiedRequest = this.applyFilters(request);
        return ((OAIModelList)GSON.fromJson(this.client.send(monitor, modifiedRequest), OAIModelList.class)).data();
    }

    private HttpRequest createCompletionRequest(@NotNull OAIResponsesRequest completionRequest) throws DBException {
        return HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "responses")).header("User-Agent", GeneralUtils.getProductTitle()).POST(HttpRequest.BodyPublishers.ofString(OpenAIClient.serializeValue(completionRequest))).timeout(TIMEOUT).build();
    }

    @NotNull
    public OAIResponsesResponse createChatCompletion(@NotNull DBRProgressMonitor monitor, @NotNull OAIResponsesRequest completionRequest) throws DBException {
        HttpRequest request = this.createCompletionRequest(completionRequest);
        HttpRequest modifiedRequest = this.applyFilters(request);
        String responseJson = this.client.send(monitor, modifiedRequest);
        return (OAIResponsesResponse)GSON.fromJson(responseJson, OAIResponsesResponse.class);
    }

    public void createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull OAIResponsesRequest completionRequest, @NotNull AIEngineResponseConsumer listener) throws DBException {
        HttpRequest request = this.createCompletionRequest(completionRequest);
        HttpRequest modifiedRequest = this.applyFilters(request);
        StreamConsumer stringConsumer = new StreamConsumer(listener);
        this.client.sendAsync(modifiedRequest, stringConsumer, listener::error, listener::completeBlock);
    }

    public HttpRequest applyFilters(@NotNull HttpRequest request) throws DBException {
        return this.applyFilters(request, true);
    }

    public HttpRequest applyFilters(@NotNull HttpRequest request, boolean setContentType) throws DBException {
        for (HttpRequestFilter filter : this.requestFilters) {
            request = filter.filter(request, setContentType);
        }
        return request;
    }

    @NotNull
    protected static String serializeValue(@Nullable Object value) throws DBException {
        try {
            return GSON.toJson(value);
        }
        catch (Exception e) {
            throw new DBException("Error serializing value", (Throwable)e);
        }
    }

    private static class StreamConsumer
    implements Consumer<String> {
        private final AIEngineResponseConsumer listener;
        private boolean functionCall;

        public StreamConsumer(AIEngineResponseConsumer listener) {
            this.listener = listener;
        }

        @Override
        public void accept(String event) {
            if (CommonUtils.isEmpty((String)event)) {
                return;
            }
            if (event.startsWith(OpenAIClient.DATA_EVENT)) {
                String data = event.substring(OpenAIClient.DATA_EVENT.length()).trim();
                try {
                    OAIResponsesChunk chunk = (OAIResponsesChunk)GSON.fromJson(data, OAIResponsesChunk.class);
                    if (OpenAIClient.EVENT_TYPE_RESPONSE_COMPLETED.equals(chunk.type)) {
                        this.listener.usage(chunk.response.getAIUsage());
                    } else {
                        if (chunk.item != null && "function_call".equals(chunk.item.type)) {
                            if (OpenAIClient.EVENT_TYPE_ITEM_DONE.equals(chunk.type)) {
                                this.listener.nextChunk(new AIEngineResponseChunk(OpenAIClient.createFunctionCall(chunk.item)));
                                this.functionCall = false;
                            } else {
                                this.functionCall = true;
                            }
                            return;
                        }
                        if (!this.functionCall) {
                            ArrayList<String> choices = new ArrayList<String>();
                            if (OpenAIClient.EVENT_TYPE_TEXT_DELTA.equals(chunk.type)) {
                                choices.add(chunk.delta);
                            } else if (chunk.response != null) {
                                for (OAIMessage msg : chunk.response.output) {
                                    for (OAIMessageContent content : msg.content) {
                                        if (CommonUtils.isEmpty((String)content.text)) continue;
                                        choices.add(content.text);
                                    }
                                }
                            }
                            if (!choices.isEmpty()) {
                                this.listener.nextChunk(new AIEngineResponseChunk(choices));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.listener.error(e);
                }
            } else if (event.startsWith(OpenAIClient.EVENT_EVENT)) {
                String eventType = event.substring(OpenAIClient.EVENT_EVENT.length()).trim();
                if (!CommonUtils.isEmpty((String)eventType)) {
                    switch (eventType) {
                        default: 
                    }
                }
            } else {
                log.debug((Object)("Unknown OpenAI event: " + event));
            }
        }
    }

    public static interface HttpRequestFilter {
        @NotNull
        public HttpRequest filter(@NotNull HttpRequest var1, boolean var2) throws DBException;
    }
}

