/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;

public class OtpMsg {
    public static final int linkTag = 1;
    public static final int sendTag = 2;
    public static final int exitTag = 3;
    public static final int unlinkTag = 4;
    public static final int regSendTag = 6;
    public static final int exit2Tag = 8;
    protected int tag;
    protected OtpInputStream paybuf;
    protected OtpErlangObject payload;
    protected OtpErlangPid from;
    protected OtpErlangPid to;
    protected String toName;
    protected long unlink_id;

    OtpMsg(OtpErlangPid otpErlangPid, OtpInputStream otpInputStream) {
        this.tag = 2;
        this.from = null;
        this.to = otpErlangPid;
        this.toName = null;
        this.paybuf = otpInputStream;
        this.payload = null;
        this.unlink_id = 0L;
    }

    OtpMsg(OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) {
        this.tag = 2;
        this.from = null;
        this.to = otpErlangPid;
        this.toName = null;
        this.paybuf = null;
        this.payload = otpErlangObject;
        this.unlink_id = 0L;
    }

    OtpMsg(OtpErlangPid otpErlangPid, String string, OtpInputStream otpInputStream) {
        this.tag = 6;
        this.from = otpErlangPid;
        this.toName = string;
        this.to = null;
        this.paybuf = otpInputStream;
        this.payload = null;
        this.unlink_id = 0L;
    }

    OtpMsg(OtpErlangPid otpErlangPid, String string, OtpErlangObject otpErlangObject) {
        this.tag = 6;
        this.from = otpErlangPid;
        this.toName = string;
        this.to = null;
        this.paybuf = null;
        this.payload = otpErlangObject;
        this.unlink_id = 0L;
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) {
        this.tag = n;
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
        this.unlink_id = 0L;
        this.paybuf = null;
        this.payload = otpErlangObject;
        this.unlink_id = 0L;
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, String string) {
        this.tag = n;
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
        this.paybuf = null;
        this.payload = new OtpErlangAtom(string);
        this.unlink_id = 0L;
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        this.tag = this.drop_tt_tag(n);
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
        this.unlink_id = 0L;
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) {
        this.tag = this.drop_tt_tag(n);
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
        this.unlink_id = l;
    }

    private int drop_tt_tag(int n) {
        switch (n) {
            case 12: {
                return 2;
            }
            case 13: {
                return 3;
            }
            case 16: {
                return 6;
            }
            case 18: {
                return 8;
            }
        }
        return n;
    }

    long getUnlinkId() {
        return this.unlink_id;
    }

    OtpInputStream getMsgBuf() {
        return this.paybuf;
    }

    public int type() {
        return this.tag;
    }

    public OtpErlangObject getMsg() throws OtpErlangDecodeException {
        if (this.payload == null) {
            this.payload = this.paybuf.read_any();
        }
        return this.payload;
    }

    public String getRecipientName() {
        return this.toName;
    }

    public OtpErlangPid getRecipientPid() {
        return this.to;
    }

    public Object getRecipient() {
        if (this.toName != null) {
            return this.toName;
        }
        return this.to;
    }

    public OtpErlangPid getSenderPid() {
        return this.from;
    }
}

