/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Morphological closing by attributes.


An attribute closing removes blobs according to criteria such as area.
When applied to grayscale images they have the effect of filling
valleys (regions darker than their surroundings) based on area while
leaving the rest of the image unchanged.

This code was contributed in the Insight Journal paper

"Grayscale morphological attribute operations" by Beare R. https://doi.org/10.54294/ifvjls


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 itk::simple::AreaClosing for the procedural interface

 itk::AreaClosingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAreaClosingImageFilter.h
*/
public class AreaClosingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AreaClosingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AreaClosingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AreaClosingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AreaClosingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AreaClosingImageFilter::~AreaClosingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AreaClosingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AreaClosingImageFilter::AreaClosingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AreaClosingImageFilter() {
    this(SimpleITKJNI.new_AreaClosingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::SetLambda(double Lambda)

The size of the area opening.

*/
public  void setLambda(double Lambda) {
    SimpleITKJNI.AreaClosingImageFilter_setLambda(swigCPtr, this, Lambda);
  }

  /**
double itk::simple::AreaClosingImageFilter::GetLambda() const
*/
public  double getLambda() {
    return SimpleITKJNI.AreaClosingImageFilter_getLambda(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether the image spacing is used or not - defaults to true.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.AreaClosingImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.AreaClosingImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.AreaClosingImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::AreaClosingImageFilter::GetUseImageSpacing() const

Set/Get whether the image spacing is used or not - defaults to true.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.AreaClosingImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::SetFullyConnected(bool FullyConnected)
*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.AreaClosingImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.AreaClosingImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaClosingImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.AreaClosingImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::AreaClosingImageFilter::GetFullyConnected() const
*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.AreaClosingImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::AreaClosingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AreaClosingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AreaClosingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AreaClosingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AreaClosingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AreaClosingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
