/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.NikonPictureControl1Directory;

public final class NikonPictureControl1Descriptor
extends TagDescriptor<NikonPictureControl1Directory> {
    public NikonPictureControl1Descriptor(NikonPictureControl1Directory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 48: {
                return this.getPictureControlAdjustDescription();
            }
            case 55: {
                return this.getFilterEffectDescription();
            }
            case 56: {
                return this.getToningEffectDescription();
            }
        }
        return super.getDescription(tagType);
    }

    public String getPictureControlAdjustDescription() {
        return this.getIndexedDescription(48, "Default Settings", "Quick Adjust", "Full Control");
    }

    public String getFilterEffectDescription() {
        Integer value = ((NikonPictureControl1Directory)this._directory).getInteger(55);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 128: {
                return "Off";
            }
            case 129: {
                return "Yellow";
            }
            case 130: {
                return "Orange";
            }
            case 131: {
                return "Red";
            }
            case 132: {
                return "Green";
            }
            case 255: {
                return "N/A";
            }
        }
        return super.getDescription(55);
    }

    public String getToningEffectDescription() {
        Integer value = ((NikonPictureControl1Directory)this._directory).getInteger(56);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 128: {
                return "B&W";
            }
            case 129: {
                return "Sepia";
            }
            case 130: {
                return "Cyanotype";
            }
            case 131: {
                return "Red";
            }
            case 132: {
                return "Yellow";
            }
            case 133: {
                return "Green";
            }
            case 134: {
                return "Blue-green";
            }
            case 135: {
                return "Blue";
            }
            case 136: {
                return "Purple-blue";
            }
            case 137: {
                return "Red-purple";
            }
            case 255: {
                return "N/A";
            }
        }
        return super.getDescription(56);
    }
}

