/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.linux.LinuxLookAndFeelAddons;
import org.jdesktop.swingx.plaf.macosx.MacOSXLookAndFeelAddons;
import org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons;
import org.jdesktop.swingx.plaf.motif.MotifLookAndFeelAddons;
import org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

public abstract class LookAndFeelAddons {
    private static List<ComponentAddon> contributedComponents = new ArrayList<ComponentAddon>();
    private static final Object APPCONTEXT_INITIALIZED = new Object();
    private static boolean trackingChanges = false;
    private static PropertyChangeListener changeListener;
    private static LookAndFeelAddons currentAddon;

    public void initialize() {
        for (ComponentAddon componentAddon : contributedComponents) {
            componentAddon.initialize(this);
        }
    }

    public void uninitialize() {
        for (ComponentAddon componentAddon : contributedComponents) {
            componentAddon.uninitialize(this);
        }
    }

    public void loadDefaults(Object[] objectArray) {
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (UIManager.getLookAndFeelDefaults().get(objectArray[i]) != null) continue;
            UIManager.getLookAndFeelDefaults().put(objectArray[i], objectArray[i + 1]);
        }
    }

    public void unloadDefaults(Object[] objectArray) {
    }

    public static void setAddon(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LookAndFeelAddons.setAddon(Class.forName(string));
    }

    public static void setAddon(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        LookAndFeelAddons lookAndFeelAddons = (LookAndFeelAddons)clazz.newInstance();
        LookAndFeelAddons.setAddon(lookAndFeelAddons);
    }

    public static void setAddon(LookAndFeelAddons lookAndFeelAddons) {
        if (currentAddon != null) {
            currentAddon.uninitialize();
        }
        lookAndFeelAddons.initialize();
        currentAddon = lookAndFeelAddons;
        UIManager.put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
        UIManager.getLookAndFeelDefaults().put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
    }

    public static LookAndFeelAddons getAddon() {
        return currentAddon;
    }

    public static String getBestMatchAddonClassName() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        String string2 = UIManager.getCrossPlatformLookAndFeelClassName().equals(string) ? MetalLookAndFeelAddons.class.getName() : (UIManager.getSystemLookAndFeelClassName().equals(string) ? LookAndFeelAddons.getSystemAddonClassName() : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(string) || "com.jgoodies.looks.windows.WindowsLookAndFeel".equals(string) ? (OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName()) : ("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(string) ? WindowsClassicLookAndFeelAddons.class.getName() : (UIManager.getLookAndFeel().getID().equals("Motif") ? MotifLookAndFeelAddons.class.getName() : (UIManager.getLookAndFeel().getID().equals("Nimbus") ? NimbusLookAndFeelAddons.class.getName() : LookAndFeelAddons.getSystemAddonClassName())))));
        return string2;
    }

    public static String getSystemAddonClassName() {
        String string = WindowsClassicLookAndFeelAddons.class.getName();
        if (OS.isMacOSX()) {
            string = MacOSXLookAndFeelAddons.class.getName();
        } else if (OS.isWindows()) {
            string = OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName();
        } else if (OS.isLinux()) {
            string = LinuxLookAndFeelAddons.class.getName();
        }
        return string;
    }

    public static void contribute(ComponentAddon componentAddon) {
        contributedComponents.add(componentAddon);
        if (currentAddon != null) {
            componentAddon.initialize(currentAddon);
        }
    }

    public static void uncontribute(ComponentAddon componentAddon) {
        contributedComponents.remove(componentAddon);
        if (currentAddon != null) {
            componentAddon.uninitialize(currentAddon);
        }
    }

    public static ComponentUI getUI(JComponent jComponent, Class<?> clazz) {
        Class<?> clazz2;
        Object object;
        LookAndFeelAddons.maybeInitialize();
        String string = (String)UIManager.get(jComponent.getUIClassID());
        if (string == null) {
            object = Logger.getLogger("LookAndFeelAddons");
            ((Logger)object).warning("Failed to retrieve UI for " + jComponent.getClass().getName() + " with UIClassID " + jComponent.getUIClassID());
            if (((Logger)object).isLoggable(Level.FINE)) {
                ((Logger)object).fine("Existing UI defaults keys: " + new ArrayList(UIManager.getDefaults().keySet()));
            }
            string = "org.jdesktop.swingx.plaf.basic.Basic" + clazz.getSimpleName();
        }
        try {
            object = Class.forName(string);
            UIManager.put(string, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        object = UIManager.getUI(jComponent);
        if (clazz.isInstance(object)) {
            return object;
        }
        String string2 = object.getClass().getName();
        try {
            clazz2 = clazz.getClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Failed to load class " + string2, classNotFoundException);
        }
        Method method = null;
        try {
            method = clazz2.getMethod("createUI", JComponent.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Class " + string2 + " has no method createUI(JComponent)");
        }
        try {
            return (ComponentUI)method.invoke(null, jComponent);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to invoke " + string2 + "#createUI(JComponent)");
        }
    }

    private static synchronized void maybeInitialize() {
        UIDefaults uIDefaults;
        if (currentAddon != null && !(uIDefaults = UIManager.getLookAndFeelDefaults()).getBoolean(APPCONTEXT_INITIALIZED)) {
            LookAndFeelAddons.setAddon(currentAddon);
        }
    }

    public static synchronized void setTrackingLookAndFeelChanges(boolean bl) {
        if (trackingChanges != bl) {
            if (bl) {
                if (changeListener == null) {
                    changeListener = new UpdateAddon();
                }
                UIManager.addPropertyChangeListener(changeListener);
            } else {
                if (changeListener != null) {
                    UIManager.removePropertyChangeListener(changeListener);
                }
                changeListener = null;
            }
            trackingChanges = bl;
        }
    }

    public static synchronized boolean isTrackingLookAndFeelChanges() {
        return trackingChanges;
    }

    public static void installBackgroundPainter(JComponent jComponent, String string) {
        Class<?> clazz = jComponent.getClass();
        try {
            Method method = clazz.getMethod("getBackgroundPainter", new Class[0]);
            Method method2 = clazz.getMethod("setBackgroundPainter", Painter.class);
            Painter painter = (Painter)method.invoke((Object)jComponent, new Object[0]);
            if (painter == null || painter instanceof UIResource) {
                method2.invoke((Object)jComponent, UIManagerExt.getPainter(string));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot set painter on " + jComponent.getClass());
        }
    }

    public static void uninstallBackgroundPainter(JComponent jComponent) {
        Class<?> clazz = jComponent.getClass();
        try {
            Method method = clazz.getMethod("getBackgroundPainter", new Class[0]);
            Method method2 = clazz.getMethod("setBackgroundPainter", Painter.class);
            Painter painter = (Painter)method.invoke((Object)jComponent, new Object[0]);
            if (painter == null || painter instanceof UIResource) {
                method2.invoke((Object)jComponent, new Object[]{null});
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot set painter on " + jComponent.getClass());
        }
    }

    static {
        String string = LookAndFeelAddons.getBestMatchAddonClassName();
        try {
            string = System.getProperty("swing.addon", string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            LookAndFeelAddons.setAddon(string);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        LookAndFeelAddons.setTrackingLookAndFeelChanges(true);
    }

    private static class UpdateAddon
    implements PropertyChangeListener {
        private UpdateAddon() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

