/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.raft.ReplicaKey;

public class EpochElection {
    private Map<Integer, VoterState> voterStates;

    public EpochElection(Set<ReplicaKey> voters) {
        this.voterStates = voters.stream().collect(Collectors.toMap(ReplicaKey::id, VoterState::new));
    }

    public boolean recordVote(int voterId, boolean isGranted) {
        VoterState voterState = this.getVoterStateOrThrow(voterId);
        boolean wasUnrecorded = voterState.state == VoterState.State.UNRECORDED;
        voterState.setState(isGranted ? VoterState.State.GRANTED : VoterState.State.REJECTED);
        return wasUnrecorded;
    }

    public boolean isGrantedVoter(int voterId) {
        return this.getVoterStateOrThrow((int)voterId).state == VoterState.State.GRANTED;
    }

    public boolean isRejectedVoter(int voterId) {
        return this.getVoterStateOrThrow((int)voterId).state == VoterState.State.REJECTED;
    }

    public Set<Integer> voterIds() {
        return Collections.unmodifiableSet(this.voterStates.keySet());
    }

    public boolean isVoteGranted() {
        return this.numGranted() >= (long)this.majoritySize();
    }

    public boolean isVoteRejected() {
        return this.numGranted() + this.numUnrecorded() < (long)this.majoritySize();
    }

    public Set<ReplicaKey> unrecordedVoters() {
        return this.votersOfState(VoterState.State.UNRECORDED).collect(Collectors.toSet());
    }

    public Set<Integer> grantingVoters() {
        return this.votersOfState(VoterState.State.GRANTED).map(ReplicaKey::id).collect(Collectors.toSet());
    }

    public Set<Integer> rejectingVoters() {
        return this.votersOfState(VoterState.State.REJECTED).map(ReplicaKey::id).collect(Collectors.toSet());
    }

    private VoterState getVoterStateOrThrow(int voterId) {
        VoterState voterState = this.voterStates.get(voterId);
        if (voterState == null) {
            throw new IllegalArgumentException("Attempt to access voter state of non-voter " + voterId);
        }
        return voterState;
    }

    private Stream<ReplicaKey> votersOfState(VoterState.State state) {
        return this.voterStates.values().stream().filter(voterState -> voterState.state().equals((Object)state)).map(VoterState::replicaKey);
    }

    private long numGranted() {
        return this.votersOfState(VoterState.State.GRANTED).count();
    }

    private long numUnrecorded() {
        return this.votersOfState(VoterState.State.UNRECORDED).count();
    }

    private int majoritySize() {
        return this.voterStates.size() / 2 + 1;
    }

    public String toString() {
        return String.format("EpochElection(voterStates=%s)", this.voterStates);
    }

    private static final class VoterState {
        private final ReplicaKey replicaKey;
        private State state = State.UNRECORDED;

        VoterState(ReplicaKey replicaKey) {
            this.replicaKey = replicaKey;
        }

        public State state() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public ReplicaKey replicaKey() {
            return this.replicaKey;
        }

        public String toString() {
            return String.format("VoterState(replicaKey=%s, state=%s)", new Object[]{this.replicaKey, this.state});
        }

        static enum State {
            UNRECORDED,
            GRANTED,
            REJECTED;

        }
    }
}

