/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.utils.Time;

public class CleanerStats {
    long bytesRead = 0L;
    long bytesWritten = 0L;
    long mapBytesRead = 0L;
    long messagesRead = 0L;
    long invalidMessagesRead = 0L;
    long messagesWritten = 0L;
    double bufferUtilization = 0.0;
    private long mapCompleteTime = -1L;
    private long endTime = -1L;
    private long mapMessagesRead = 0L;
    private final Time time;
    private final long startTime;

    public CleanerStats(Time time) {
        this.time = time;
        this.startTime = time.milliseconds();
    }

    public void readMessages(int messagesRead, int bytesRead) {
        this.messagesRead += (long)messagesRead;
        this.bytesRead += (long)bytesRead;
    }

    public void invalidMessage() {
        ++this.invalidMessagesRead;
    }

    public void recopyMessages(int messagesWritten, int bytesWritten) {
        this.messagesWritten += (long)messagesWritten;
        this.bytesWritten += (long)bytesWritten;
    }

    public void indexMessagesRead(int size) {
        this.mapMessagesRead += (long)size;
    }

    public void indexBytesRead(int size) {
        this.mapBytesRead += (long)size;
    }

    public void indexDone() {
        this.mapCompleteTime = this.time.milliseconds();
    }

    public void allDone() {
        this.endTime = this.time.milliseconds();
    }

    public double elapsedSecs() {
        return (double)(this.endTime - this.startTime) / 1000.0;
    }

    public double elapsedIndexSecs() {
        return (double)(this.mapCompleteTime - this.startTime) / 1000.0;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public long mapMessagesRead() {
        return this.mapMessagesRead;
    }

    public long messagesRead() {
        return this.messagesRead;
    }

    public long invalidMessagesRead() {
        return this.invalidMessagesRead;
    }

    public long messagesWritten() {
        return this.messagesWritten;
    }

    public double bufferUtilization() {
        return this.bufferUtilization;
    }

    public void setBufferUtilization(double bufferUtilization) {
        this.bufferUtilization = bufferUtilization;
    }
}

