/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.parser;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.ValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.index.util.IndexUtil;

public final class RescoreParser {
    @Generated
    private static final Logger log = LogManager.getLogger(RescoreParser.class);
    public static final String RESCORE_PARAMETER = "rescore";
    public static final String RESCORE_OVERSAMPLE_PARAMETER = "oversample_factor";
    private static final ObjectParser<RescoreContext.RescoreContextBuilder, Void> INTERNAL_PARSER = RescoreParser.createInternalObjectParser();

    private static ObjectParser<RescoreContext.RescoreContextBuilder, Void> createInternalObjectParser() {
        ObjectParser internalParser = new ObjectParser(RESCORE_PARAMETER, RescoreContext::builder);
        internalParser.declareFloat(RescoreContext.RescoreContextBuilder::oversampleFactor, KNNQueryBuilder.RESCORE_OVERSAMPLE_FIELD);
        return internalParser;
    }

    public static ValidationException validate(RescoreContext rescoreContext) {
        if (rescoreContext.getOversampleFactor() < 1.0f) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(String.format(Locale.ROOT, "Oversample factor [%f] cannot be less than [%f]", Float.valueOf(rescoreContext.getOversampleFactor()), Float.valueOf(1.0f)));
            return validationException;
        }
        if (rescoreContext.getOversampleFactor() > 100.0f) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(String.format(Locale.ROOT, "Oversample factor [%f] cannot be more than [%f]", Float.valueOf(rescoreContext.getOversampleFactor()), Float.valueOf(100.0f)));
            return validationException;
        }
        return null;
    }

    public static RescoreContext streamInput(StreamInput in) throws IOException {
        if (!IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), RESCORE_PARAMETER)) {
            return null;
        }
        Float oversample = in.readOptionalFloat();
        if (oversample == null) {
            return null;
        }
        return RescoreContext.builder().oversampleFactor(oversample.floatValue()).build();
    }

    public static void streamOutput(StreamOutput out, RescoreContext rescoreContext) throws IOException {
        if (!IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), RESCORE_PARAMETER)) {
            return;
        }
        out.writeOptionalFloat(rescoreContext == null ? null : Float.valueOf(rescoreContext.getOversampleFactor()));
    }

    public static void doXContent(XContentBuilder builder, RescoreContext rescoreContext) throws IOException {
        builder.startObject(RESCORE_PARAMETER);
        builder.field(RESCORE_OVERSAMPLE_PARAMETER, rescoreContext.getOversampleFactor());
        builder.endObject();
    }

    public static RescoreContext fromXContent(XContentParser parser) {
        return ((RescoreContext.RescoreContextBuilder)INTERNAL_PARSER.apply(parser, null)).build();
    }

    @Generated
    public RescoreParser() {
    }
}

