/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding;

import com.google.common.base.MoreObjects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BindingDescriptor
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();
    private boolean synchronous = false;
    private boolean artifact = false;
    private boolean signatureCapable = false;
    @Nullable
    @NotEmpty
    private String shortName;

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.activationCondition = Constraint.isNotNull(condition, "Activation condition predicate cannot be null");
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean flag) {
        this.synchronous = flag;
    }

    public boolean isArtifact() {
        return this.artifact;
    }

    public void setArtifact(boolean flag) {
        this.artifact = flag;
    }

    public boolean isSignatureCapable() {
        return this.signatureCapable;
    }

    public void setSignatureCapable(boolean flag) {
        this.signatureCapable = flag;
    }

    @Nullable
    @NotEmpty
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(@Nullable @NotEmpty String name) {
        this.shortName = StringSupport.trimOrNull(name);
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    public int hashCode() {
        return this.ensureId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BindingDescriptor) {
            return this.ensureId().equals(((BindingDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bindingId", (Object)this.ensureId()).add("shortName", (Object)this.shortName).add("synchronous", this.synchronous).add("artifact", this.artifact).add("signatureCapable", this.signatureCapable).toString();
    }
}

