/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.setting;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;

public abstract class OpensearchDynamicSetting<T> {
    private final Setting<T> dynamicSetting;
    private volatile T dynamicSettingValue;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public OpensearchDynamicSetting(Setting<T> dynamicSetting, T dynamicSettingValue) {
        this.dynamicSetting = dynamicSetting;
        this.dynamicSettingValue = dynamicSettingValue;
    }

    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(this.dynamicSetting, dynamicSettingNewValue -> {
            this.logger.info(this.getClusterChangeMessage(dynamicSettingNewValue));
            this.setDynamicSettingValue(dynamicSettingNewValue);
        });
    }

    protected String getClusterChangeMessage(T dynamicSettingNewValue) {
        return String.format("Detected change in settings, updated cluster setting value is %s", dynamicSettingNewValue);
    }

    protected void setDynamicSettingValue(T dynamicSettingValue) {
        this.dynamicSettingValue = dynamicSettingValue;
    }

    public T getDynamicSettingValue() {
        return this.dynamicSettingValue;
    }

    public Setting<T> getDynamicSetting() {
        return this.dynamicSetting;
    }
}

