/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.activitydiagram.ConditionalContext;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public class ActivityDiagram
extends CucaDiagram {
    private Entity lastEntityConsulted;
    private Entity lastEntityBrancheConsulted;
    private ConditionalContext currentContext;

    public ActivityDiagram(UmlSource source, Previous previous, PreprocessingArtifact preprocessing) {
        super(source, UmlDiagramType.ACTIVITY, previous, preprocessing);
        this.setNamespaceSeparator(null);
    }

    private String getAutoBranch() {
        return this.getUniqueSequence("#");
    }

    public void startIf(LineLocation location, String optionalCodeString) {
        String idShort = optionalCodeString == null ? this.getAutoBranch() : optionalCodeString;
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        Entity br = this.reallyCreateLeaf(location, quark, Display.create(""), LeafType.BRANCH, null);
        this.currentContext = new ConditionalContext(this.currentContext, br, Direction.DOWN);
    }

    public void endif() {
        this.currentContext = this.currentContext.getParent();
    }

    public Entity getStart(LineLocation location) {
        Quark<Entity> quark = this.quarkInContext(true, "start");
        if (quark.getData() == null) {
            this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), "start"), LeafType.CIRCLE_START, null);
        }
        return quark.getData();
    }

    public Entity getEnd(LineLocation location, String suppId) {
        String tmp = suppId == null ? "end" : "end$" + suppId;
        Quark<Entity> quark = this.quarkInContext(true, tmp);
        if (quark.getData() == null) {
            this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), "end"), LeafType.CIRCLE_END, null);
        }
        return quark.getData();
    }

    @Override
    protected void updateLasts(Entity result) {
        if (result == null || result.getLeafType() == LeafType.NOTE) {
            return;
        }
        this.lastEntityConsulted = result;
        if (result.getLeafType() == LeafType.BRANCH) {
            this.lastEntityBrancheConsulted = result;
        }
    }

    public Entity createNote(LineLocation location, Quark<Entity> idNewLong, String code__, Display display) {
        return this.reallyCreateLeaf(location, Objects.requireNonNull(idNewLong), display, LeafType.NOTE, null);
    }

    @Override
    protected final List<String> getDotStrings() {
        return Arrays.asList("nodesep=.20;", "ranksep=0.4;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11];");
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(" + this.leafs().size() + " activities)");
    }

    public Entity getLastEntityConsulted() {
        return this.lastEntityConsulted;
    }

    @Deprecated
    public Entity getLastEntityBrancheConsulted() {
        return this.lastEntityBrancheConsulted;
    }

    public final ConditionalContext getCurrentContext() {
        return this.currentContext;
    }

    public final void setLastEntityConsulted(Entity lastEntityConsulted) {
        this.lastEntityConsulted = lastEntityConsulted;
    }

    public Entity createInnerActivity(LineLocation location) {
        String idShort = this.getUniqueSequence("##");
        Quark<Entity> quark = this.quarkInContext(true, idShort);
        this.gotoGroup(location, quark, Display.getWithNewlines(this.getPragma(), quark.getName()), GroupType.INNER_ACTIVITY);
        Entity g = this.getCurrentGroup();
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
        return g;
    }

    public void concurrentActivity(LineLocation location, String name) {
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            this.endGroup();
        }
        String idShort = this.getUniqueSequence("##");
        if (this.getCurrentGroup().getGroupType() != GroupType.INNER_ACTIVITY) {
            throw new IllegalStateException("type=" + (Object)((Object)this.getCurrentGroup().getGroupType()));
        }
        Quark<Entity> idNewLong = this.quarkInContext(true, idShort);
        this.gotoGroup(location, idNewLong, Display.getWithNewlines(this.getPragma(), "code"), GroupType.CONCURRENT_ACTIVITY);
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
    }
}

