/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.IOException;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.theme.Theme;
import net.sourceforge.plantuml.theme.ThemeUtils;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;

public class EaterTheme
extends Eater {
    private String realName;
    private String name;
    private String from;
    private TContext context;
    private final PathSystem pathSystem;

    public EaterTheme(StringLocated s, PathSystem pathSystem) {
        super(s);
        this.pathSystem = pathSystem;
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException {
        this.skipSpaces();
        this.checkAndEatChar("!theme");
        this.skipSpaces();
        this.name = this.eatAllToEnd();
        int x = this.name.toLowerCase().indexOf(" from ");
        if (x != -1) {
            String fromTmp = this.name.substring(x + " from ".length()).trim();
            this.from = context.applyFunctionsAndVariables(memory, new StringLocated(fromTmp, this.getLineLocation()));
            this.name = this.name.substring(0, x).trim();
            this.context = context;
        }
        this.realName = context.applyFunctionsAndVariables(memory, new StringLocated(this.name, this.getLineLocation()));
    }

    public final Theme getTheme() throws EaterException {
        try {
            Theme theme = ThemeUtils.loadTheme(this.pathSystem, this.realName, this.from, this.getStringLocated());
            if (theme == null) {
                String location = this.from == null ? "" : " in " + this.from;
                throw new EaterException("Cannot load theme " + this.realName + location, this.getStringLocated());
            }
            return theme;
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("Cannot load theme " + this.realName, this.getStringLocated());
        }
    }

    public String getName() {
        return this.name;
    }

    public PathSystem getNewImportedFiles() {
        return this.pathSystem;
    }
}

