\name{NormalizeImageFilter}
\alias{NormalizeImageFilter}
\title{NormalizeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Normalize an image by setting its mean to zero and variance to one.
NormalizeImageFilter}
\details{
NormalizeImageFilter shifts and scales an image so that the pixels in the image have a
zero mean and unit variance. This filter uses StatisticsImageFilter to compute the mean and variance of the input and then applies ShiftScaleImageFilter to shift and scale the pixels.
NB: since this filter normalizes the data such that the mean is at 0,
and \eqn{-\sigma} to \eqn{+\sigma} is mapped to -1.0 to 1.0, output image integral types will produce an
image that DOES NOT HAVE a unit variance due to 68\% of the intensity
values being mapped to the real number range of -1.0 to 1.0 and then
cast to the output integral value.
See:
NormalizeToConstantImageFilter
Normalize for the procedural interface
itk::NormalizeImageFilter for the Doxygen on the original ITK class.
NormalizeImageFilter}
%C++ includes: sitkNormalizeImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ NormalizeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NormalizeImageFilter():}{
Destructor
}
}
}
