/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.jdt;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.generator.jdt.ASTProcessor;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.Map;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class TypeHelper {
    public static final int ORA_REF_CURSOR = 3874837;
    public static final int ORA_BINARY_DOUBLE = 3874838;
    public static final int ORA_BFILE = 3874839;

    public static String getTypeNameForGenerics(TypeInfo typeInfo) {
        if (typeInfo.isPrimitiveOrWrapper()) {
            String string = typeInfo.getTypeName();
            if ("int".equals(string)) {
                return "Integer";
            }
            if ("short".equals(string)) {
                return "Short";
            }
            if ("float".equals(string)) {
                return "Float";
            }
            if ("double".equals(string)) {
                return "Double";
            }
            if ("char".equals(string)) {
                return "Character";
            }
            if ("boolean".equals(string)) {
                return "Boolean";
            }
            if ("long".equals(string)) {
                return "Long";
            }
            if ("byte".equals(string)) {
                return "Byte";
            }
        }
        return typeInfo.getTypeName();
    }

    public static boolean isPrimitive(TypeInfo typeInfo) {
        if (typeInfo.isPrimitiveOrWrapper()) {
            String string = typeInfo.getTypeName();
            return "int".equals(string) || "short".equals(string) || "float".equals(string) || "double".equals(string) || "char".equals(string) || "boolean".equals(string) || "long".equals(string) || "byte".equals(string);
        }
        return false;
    }

    public static JavaType getJavaType(String string, AST aST, ITypeBinding iTypeBinding, Map<String, IBinding> map) {
        if ("java.lang.String".equals(string)) {
            return JavaType.STRING;
        }
        if ("java.lang.Integer".equals(string)) {
            return JavaType.INTEGER;
        }
        if ("int".equals(string)) {
            return JavaType.SIMPLE_INTEGER;
        }
        if ("java.lang.Boolean".equals(string)) {
            return JavaType.BOOLEAN;
        }
        if ("java.lang.Byte".equals(string)) {
            return JavaType.BYTE;
        }
        if ("java.lang.Byte[]".equals(string)) {
            return JavaType.BYTE_ARRAY;
        }
        if ("java.lang.Short".equals(string)) {
            return JavaType.SHORT;
        }
        if ("java.lang.Long".equals(string)) {
            return JavaType.LONG;
        }
        if ("java.lang.Float".equals(string)) {
            return JavaType.FLOAT;
        }
        if ("java.lang.Double".equals(string)) {
            return JavaType.DOUBLE;
        }
        if ("java.sql.Date".equals(string)) {
            return JavaType.DATE;
        }
        if ("java.lang.Character".equals(string)) {
            return JavaType.CHARACTER;
        }
        if ("java.sql.Time".equals(string)) {
            return JavaType.TIME;
        }
        if ("com.ibm.db2.jcc.DBTimestamp".equals(string)) {
            return JavaType.TIMESTAMPTZ;
        }
        if ("java.sql.Timestamp".equals(string)) {
            return JavaType.TIMESTAMP;
        }
        if ("java.math.BigDecimal".equals(string)) {
            return JavaType.BIGDECIMAL;
        }
        if ("java.sql.Blob".equals(string)) {
            return JavaType.BLOB;
        }
        if ("java.sql.Clob".equals(string)) {
            return JavaType.CLOB;
        }
        if ("java.io.InputStream".equals(string)) {
            return JavaType.INPUTSTREAM;
        }
        if ("java.io.Reader".equals(string)) {
            return JavaType.READER;
        }
        if ("boolean".equals(string)) {
            return JavaType.SIMPLE_BOOLEAN;
        }
        if ("byte".equals(string)) {
            return JavaType.SIMPLE_BYTE;
        }
        if ("byte[]".equals(string)) {
            return JavaType.SIMPLE_BYTE_ARRAY;
        }
        if ("short".equals(string)) {
            return JavaType.SIMPLE_SHORT;
        }
        if ("long".equals(string)) {
            return JavaType.SIMPLE_LONG;
        }
        if ("float".equals(string)) {
            return JavaType.SIMPLE_FLOAT;
        }
        if ("double".equals(string)) {
            return JavaType.SIMPLE_DOUBLE;
        }
        if ("char".equals(string)) {
            return JavaType.SIMPLE_CHAR;
        }
        if ("void".equals(string)) {
            return JavaType.VOID;
        }
        if ("java.util.List".equals(string)) {
            return JavaType.LIST;
        }
        if ("java.sql.ResultSet".equals(string)) {
            return JavaType.JDBCRESULTSET;
        }
        if ("java.util.Set".equals(string)) {
            return JavaType.SET;
        }
        if ("java.sql.SQLXML".equals(string)) {
            return JavaType.SQLXML;
        }
        if ("java.sql.RowId".equals(string)) {
            return JavaType.ROWID;
        }
        if (null != iTypeBinding) {
            if (iTypeBinding.isTypeVariable()) {
                return JavaType.TYPEVARIABLE;
            }
            if (iTypeBinding.isWildcardType()) {
                return JavaType.WILDCARD;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_HANDLERS_RESULTHANDLER_KEY))) {
                return JavaType.RESULTHANDLER;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_HANDLERS_ROWHANDLER_KEY))) {
                return JavaType.ROWHANDLER;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_HANDLERS_ROWHANDLERWITHPARAMETERS_KEY))) {
                return JavaType.ROWHANDLERWITHPARAMETERS;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_HANDLERS_CALLHANDLERWITHPARAMETERS_KEY))) {
                return JavaType.CALLHANDLERWITHPARAMETERS;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_HANDLERS_CALLHANDLER_KEY))) {
                return JavaType.CALLHANDLER;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_HANDLERS_PARAMETERHANDLER_KEY))) {
                return JavaType.PARAMETERHANDLER;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.JAVA_UTIL_COLLECTION_KEY))) {
                return JavaType.COLLECTION;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.JAVA_UTIL_LIST_KEY))) {
                return JavaType.DERIVEDLIST;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.JAVA_UTIL_ITERATOR_KEY))) {
                return JavaType.ITERATOR;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.JAVA_LANG_ITERABLE_KEY))) {
                return JavaType.ITERABLE;
            }
            if (iTypeBinding.isEqualTo(map.get(ASTProcessor.COM_IBM_PDQ_RUNTIME_STOREDPROCEDURERESULT_KEY))) {
                return JavaType.STOREDPROCEDURERESULT;
            }
            if (iTypeBinding.isSubTypeCompatible((ITypeBinding)map.get(ASTProcessor.JAVA_UTIL_MAP_KEY))) {
                return JavaType.MAP;
            }
        }
        if (null != aST && aST.resolveWellKnownType("java.lang.Object").equals(iTypeBinding)) {
            return JavaType.OBJECT;
        }
        return JavaType.BEAN;
    }

    public static String getJdbcSQLTypeString(int n2) {
        String string = "Types.";
        switch (n2) {
            case 2003: {
                return string + "ARRAY";
            }
            case -5: {
                return string + "BIGINT";
            }
            case -2: {
                return string + "BINARY";
            }
            case -7: {
                return string + "BIT";
            }
            case 2004: {
                return string + "BLOB";
            }
            case 16: {
                return string + "BOOLEAN";
            }
            case 1: {
                return string + "CHAR";
            }
            case 2005: {
                return string + "CLOB";
            }
            case 70: {
                return string + "DATALINK";
            }
            case 91: {
                return string + "DATE";
            }
            case 3: {
                return string + "DECIMAL";
            }
            case 2001: {
                return string + "DISTINCT";
            }
            case 8: {
                return string + "DOUBLE";
            }
            case 6: {
                return string + "FLOAT";
            }
            case 4: {
                return string + "INTEGER";
            }
            case 2000: {
                return string + "JAVA_OBJECT";
            }
            case -4: {
                return string + "LONGVARBINARY";
            }
            case -1: {
                return string + "LONGVARCHAR";
            }
            case 0: {
                return string + "NULL";
            }
            case 2: {
                return string + "NUMERIC";
            }
            case 7: {
                return string + "REAL";
            }
            case 2006: {
                return string + "REF";
            }
            case 5: {
                return string + "SMALLINT";
            }
            case 2002: {
                return string + "STRUCT";
            }
            case 92: {
                return string + "TIME";
            }
            case 93: {
                return string + "TIMESTAMP";
            }
            case -6: {
                return string + "TINYINT";
            }
            case -3: {
                return string + "VARBINARY";
            }
            case 12: {
                return string + "VARCHAR";
            }
            case 1111: {
                return string + "OTHER";
            }
            case 2009: {
                return "PDQTypes.XML";
            }
            case -8: {
                return "PDQTypes.ROWID";
            }
            case 505: {
                return "PDQTypes.LONGVARGRAPHIC";
            }
            case 504: {
                return "PDQTypes.VARGRAPHIC";
            }
            case 503: {
                return "PDQTypes.GRAPHIC";
            }
            case 502: {
                return "PDQTypes.DBCLOB";
            }
            case -100001: {
                return "PDQTypes.DECFLOAT";
            }
            case -4524532: {
                return "PDQTypes.CHAR_FOR_BIT_DATA";
            }
            case -4484493: {
                return "PDQTypes.VARCHAR_FOR_BIT_DATA";
            }
            case -4564574: {
                return "PDQTypes.LONG_VARCHAR_FOR_BIT_DATA";
            }
            case -100010: {
                if (!Configuration.doesJccVersionSupportFeature(2)) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_JCC_PREREQUISITE_DAO_GETOBJECT", "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__, "4.18"), null, 11791, null, null);
                }
                return "PDQTypes.TIMESTAMPTZ";
            }
            case 3874837: {
                return "oracle.jdbc.OracleTypes.CURSOR";
            }
            case 3874838: {
                return "oracle.jdbc.OracleTypes.BINARY_DOUBLE";
            }
            case 3874839: {
                return "oracle.jdbc.OracleTypes.BFILE";
            }
        }
        return String.valueOf(n2);
    }

    public static String getGroupAnnotationFromInterfaceSource(String string, Object object) {
        String string2 = null;
        IAnnotation[] iAnnotationArray = null;
        IType iType = null;
        try {
            iType = ((IJavaProject)object).findType(string);
            if (iType == null) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LD_INTERFACE", string), null, 11248, null, null);
            }
            iAnnotationArray = iType.getAnnotations();
            if (iAnnotationArray != null && iAnnotationArray.length > 0) {
                for (IAnnotation iAnnotation : iAnnotationArray) {
                    IMemberValuePair[] iMemberValuePairArray;
                    ISourceRange iSourceRange = iAnnotation.getNameRange();
                    String string3 = iAnnotation.getOpenable().getBuffer().getText(iSourceRange.getOffset(), iSourceRange.getLength());
                    if (string3 == null || !string3.trim().equalsIgnoreCase("Group")) continue;
                    for (IMemberValuePair iMemberValuePair : iMemberValuePairArray = iAnnotation.getMemberValuePairs()) {
                        if (!iMemberValuePair.getMemberName().equalsIgnoreCase("value")) continue;
                        string2 = (String)iMemberValuePair.getValue();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PROCESS_CL", string), exception, 11203, null, null);
        }
        return string2;
    }
}

