/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.ctypes.CThunkObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;

public final class FFIType {
    private static final TruffleString T_LEFT_PAREN_COLON = PythonUtils.tsLiteral("):");
    public static final FFIType ffi_type_pointer = new FFIType(8, 8, FFI_TYPES.FFI_TYPE_POINTER);
    public static final FFIType ffi_type_uint8 = new FFIType(1, 1, FFI_TYPES.FFI_TYPE_UINT8);
    public static final FFIType ffi_type_sint8 = new FFIType(1, 1, FFI_TYPES.FFI_TYPE_SINT8);
    public static final FFIType ffi_type_uint16 = new FFIType(2, 2, FFI_TYPES.FFI_TYPE_UINT16);
    public static final FFIType ffi_type_sint16 = new FFIType(2, 2, FFI_TYPES.FFI_TYPE_SINT16);
    public static final FFIType ffi_type_uint32 = new FFIType(4, 4, FFI_TYPES.FFI_TYPE_UINT32);
    public static final FFIType ffi_type_sint32 = new FFIType(4, 4, FFI_TYPES.FFI_TYPE_SINT32);
    public static final FFIType ffi_type_uint64 = new FFIType(8, 8, FFI_TYPES.FFI_TYPE_UINT64);
    public static final FFIType ffi_type_sint64 = new FFIType(8, 8, FFI_TYPES.FFI_TYPE_SINT64);
    public static final FFIType ffi_type_float = new FFIType(4, 4, FFI_TYPES.FFI_TYPE_FLOAT);
    public static final FFIType ffi_type_double = new FFIType(8, 4, FFI_TYPES.FFI_TYPE_DOUBLE);
    public static final FFIType ffi_type_uchar = ffi_type_uint8;
    public static final FFIType ffi_type_schar = ffi_type_sint8;
    public static final FFIType ffi_type_ushort = ffi_type_uint16;
    public static final FFIType ffi_type_sshort = ffi_type_sint16;
    public static final FFIType ffi_type_uint = ffi_type_uint32;
    public static final FFIType ffi_type_sint = ffi_type_sint32;
    public static final FFIType ffi_type_longdouble = ffi_type_double;
    public int size;
    public int alignment;
    public FFI_TYPES type;
    FFIType[] elements;
    final CThunkObject callback;
    private static final TruffleString UINT8_ARRAY = PythonUtils.tsLiteral("[UINT8]");

    private FFIType(int size, int alignment, FFI_TYPES type, FFIType[] elements, CThunkObject callback) {
        this.size = size;
        this.alignment = alignment;
        this.type = type;
        this.elements = elements;
        this.callback = callback;
    }

    protected FFIType(int size, int alignment, FFI_TYPES type, FFIType[] elements) {
        this(size, alignment, type, elements, null);
    }

    protected FFIType(int size, int alignment, FFI_TYPES type) {
        this(size, alignment, type, null, null);
    }

    protected FFIType(FFIType copyFrom, CThunkObject callback) {
        this(copyFrom.size, copyFrom.alignment, copyFrom.type, copyFrom.elements, callback);
    }

    protected FFIType() {
        this(0, 0, FFI_TYPES.FFI_TYPE_VOID, null, null);
    }

    protected static int typeSize() {
        return 1;
    }

    protected boolean isCallback() {
        return this.callback != null;
    }

    private static TruffleString getNFIType(FFIType type) {
        return type == ffi_type_pointer ? UINT8_ARRAY : type.type.getNFIType();
    }

    private static TruffleString getNFICallback(FFIType type) {
        return FFIType.getNFIReturnType(type);
    }

    private static TruffleString getNFIReturnType(FFIType type) {
        return type.type.getNFIType();
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString buildNFISignature(FFIType[] atypes, FFIType restype, boolean isCallback) {
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        boolean first = true;
        TruffleStringBuilder.AppendStringNode appendStringNode = TruffleStringBuilder.AppendStringNode.getUncached();
        appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
        for (FFIType type : atypes) {
            if (first) {
                first = false;
            } else {
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
            }
            if (type.isCallback()) {
                TruffleString subSignature = FFIType.buildNFISignature(type.callback.atypes, type.callback.ffi_restype, true);
                appendStringNode.execute(sb, (AbstractTruffleString)subSignature);
                continue;
            }
            appendStringNode.execute(sb, (AbstractTruffleString)(isCallback ? FFIType.getNFICallback(type) : FFIType.getNFIType(type)));
        }
        appendStringNode.execute(sb, (AbstractTruffleString)T_LEFT_PAREN_COLON);
        appendStringNode.execute(sb, (AbstractTruffleString)FFIType.getNFIReturnType(restype));
        return TruffleStringBuilder.ToStringNode.getUncached().execute(sb);
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString buildNFISignature(FFIType[] atypes, FFIType restype) {
        return FFIType.buildNFISignature(atypes, restype, false);
    }

    protected static FieldDesc _ctypes_get_fielddesc(char fmt) {
        if (fmt == '?') {
            return FieldDesc.QM;
        }
        for (FieldDesc t : FieldDesc.values()) {
            if (t.code != fmt) continue;
            return t;
        }
        return null;
    }

    public static enum FFI_TYPES {
        FFI_TYPE_VOID(PythonUtils.tsLiteral("VOID"), 0),
        FFI_TYPE_UINT8(PythonUtils.tsLiteral("UINT8"), 1),
        FFI_TYPE_SINT8(PythonUtils.tsLiteral("SINT8"), 1),
        FFI_TYPE_UINT16(PythonUtils.tsLiteral("UINT16"), 2),
        FFI_TYPE_SINT16(PythonUtils.tsLiteral("SINT16"), 2),
        FFI_TYPE_UINT32(PythonUtils.tsLiteral("UINT32"), 4),
        FFI_TYPE_SINT32(PythonUtils.tsLiteral("SINT32"), 4),
        FFI_TYPE_UINT64(PythonUtils.tsLiteral("UINT64"), 8),
        FFI_TYPE_SINT64(PythonUtils.tsLiteral("SINT64"), 8),
        FFI_TYPE_FLOAT(PythonUtils.tsLiteral("FLOAT"), 4),
        FFI_TYPE_DOUBLE(PythonUtils.tsLiteral("DOUBLE"), 8),
        FFI_TYPE_POINTER(PythonUtils.tsLiteral("POINTER"), 8),
        FFI_TYPE_STRUCT(PythonUtils.tsLiteral("POINTER"), 8);

        private final TruffleString nfiType;
        private final int size;

        private FFI_TYPES(TruffleString str, int size) {
            this.nfiType = str;
            this.size = size;
        }

        protected int getSize() {
            return this.size;
        }

        protected TruffleString getNFIType() {
            return this.nfiType;
        }
    }

    static enum FieldDesc {
        s('s', FieldSet.s_set, FieldGet.s_get, ffi_type_schar),
        b('b', FieldSet.b_set, FieldGet.b_get, ffi_type_schar),
        B('B', FieldSet.B_set, FieldGet.B_get, ffi_type_uchar),
        c('c', FieldSet.c_set, FieldGet.c_get, ffi_type_schar),
        d('d', FieldSet.d_set, FieldGet.d_get, ffi_type_double, FieldSet.d_set_sw, FieldGet.d_get_sw),
        g('g', FieldSet.g_set, FieldGet.g_get, ffi_type_longdouble),
        f('f', FieldSet.f_set, FieldGet.f_get, ffi_type_float, FieldSet.f_set_sw, FieldGet.f_get_sw),
        h('h', FieldSet.h_set, FieldGet.h_get, ffi_type_sshort, FieldSet.h_set_sw, FieldGet.h_get_sw),
        H('H', FieldSet.H_set, FieldGet.H_get, ffi_type_ushort, FieldSet.H_set_sw, FieldGet.H_get_sw),
        i('i', FieldSet.i_set, FieldGet.i_get, ffi_type_sint, FieldSet.i_set_sw, FieldGet.i_get_sw),
        I('I', FieldSet.I_set, FieldGet.I_get, ffi_type_uint, FieldSet.I_set_sw, FieldGet.I_get_sw),
        l('l', PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldSet.i_set : FieldSet.l_set, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldGet.i_get : FieldGet.l_get, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? ffi_type_sint32 : ffi_type_sint64, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldSet.i_set_sw : FieldSet.l_set_sw, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldGet.i_get_sw : FieldGet.l_get_sw),
        L('L', PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldSet.I_set : FieldSet.L_set, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldGet.I_get : FieldGet.L_get, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? ffi_type_uint32 : ffi_type_uint64, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldSet.I_set_sw : FieldSet.L_set_sw, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? FieldGet.I_get_sw : FieldGet.L_get_sw),
        q('q', FieldSet.q_set, FieldGet.q_get, ffi_type_sint64, FieldSet.q_set_sw, FieldGet.q_get_sw),
        Q('Q', FieldSet.Q_set, FieldGet.Q_get, ffi_type_uint64, FieldSet.Q_set_sw, FieldGet.Q_get_sw),
        P('P', FieldSet.P_set, FieldGet.P_get, ffi_type_pointer),
        z('z', FieldSet.z_set, FieldGet.z_get, ffi_type_pointer),
        u('u', FieldSet.u_set, FieldGet.u_get, CtypesNodes.WCHAR_T_SIZE == 2 ? ffi_type_sint16 : ffi_type_sint32),
        U('U', FieldSet.U_set, FieldGet.U_get, ffi_type_pointer),
        Z('Z', FieldSet.Z_set, FieldGet.Z_get, ffi_type_pointer),
        v('v', FieldSet.vBOOL_set, FieldGet.vBOOL_get, ffi_type_sshort),
        QM('?', FieldSet.bool_set, FieldGet.bool_get, ffi_type_uchar),
        O('O', FieldSet.O_set, FieldGet.O_get, ffi_type_pointer);

        final FieldSet setfunc;
        final FieldGet getfunc;
        final FFIType pffi_type;
        final char code;
        final FieldSet setfunc_swapped;
        final FieldGet getfunc_swapped;

        private FieldDesc(char code, FieldSet setfunc, FieldGet getfunc, FFIType type, FieldSet setfuncSwap, FieldGet getfuncSwap) {
            this.code = code;
            this.pffi_type = type;
            this.setfunc = setfunc;
            this.getfunc = getfunc;
            this.setfunc_swapped = setfuncSwap;
            this.getfunc_swapped = getfuncSwap;
        }

        private FieldDesc(char code, FieldSet setfunc, FieldGet getfunc, FFIType type) {
            this(code, setfunc, getfunc, type, FieldSet.nil, FieldGet.nil);
        }
    }

    static enum FieldGet {
        nil,
        s_get,
        b_get,
        B_get,
        c_get,
        d_get,
        d_get_sw,
        g_get,
        f_get,
        f_get_sw,
        h_get,
        h_get_sw,
        H_get,
        H_get_sw,
        i_get,
        i_get_sw,
        I_get,
        I_get_sw,
        l_get,
        l_get_sw,
        L_get,
        L_get_sw,
        q_get,
        q_get_sw,
        Q_get,
        Q_get_sw,
        P_get,
        z_get,
        u_get,
        U_get,
        Z_get,
        vBOOL_get,
        bool_get,
        O_get;

    }

    static enum FieldSet {
        nil,
        s_set,
        b_set,
        B_set,
        c_set,
        d_set,
        d_set_sw,
        g_set,
        f_set,
        f_set_sw,
        h_set,
        h_set_sw,
        H_set,
        H_set_sw,
        i_set,
        i_set_sw,
        I_set,
        I_set_sw,
        l_set,
        l_set_sw,
        L_set,
        L_set_sw,
        q_set,
        q_set_sw,
        Q_set,
        Q_set_sw,
        P_set,
        z_set,
        u_set,
        U_set,
        Z_set,
        vBOOL_set,
        bool_set,
        O_set;

    }
}

