/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cell;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCell})
public final class CellBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CellBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CellBuiltinsFactory.getFactories();
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetRefNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PCell var2);

        @Specialization(guards={"isSingleContext()", "self == cachedSelf"}, assumptions={"cachedSelf.isEffectivelyFinalAssumption()"}, limit="1")
        Object cached(@NeverDefault PCell self, @Cached(value="self") PCell cachedSelf, @Cached(value="self.getRef()") Object ref) {
            return ref;
        }

        @Specialization(replaces={"cached"})
        Object uncached(PCell self) {
            return self.getRef();
        }
    }

    @Builtin(name="cell_contents", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    public static abstract class CellContentsNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object get(PCell self, PNone none, @Bind Node inliningTarget, @Cached GetRefNode getRef, @Cached PRaiseNode raiseNode) {
            Object ref = getRef.execute(inliningTarget, self);
            if (ref == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IS_EMPTY, "Cell");
            }
            return ref;
        }

        @Specialization(guards={"isDeleteMarker(marker)"})
        static Object delete(PCell self, Object marker) {
            self.clearRef();
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(ref)", "!isDeleteMarker(ref)"})
        static Object set(PCell self, Object ref) {
            self.setRef(ref);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PCell self, @Bind Node inliningTarget, @Cached GetRefNode getRef, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object ref = getRef.execute(inliningTarget, self);
            if (ref == null) {
                return simpleTruffleStringFormatNode.format("<cell at 0x%s: empty>", PythonAbstractObject.systemHashCodeAsHexString(self));
            }
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, ref));
            return simpleTruffleStringFormatNode.format("<cell at 0x%s: %s object at 0x%s>", PythonAbstractObject.systemHashCodeAsHexString(self), typeName, PythonAbstractObject.systemHashCodeAsHexString(ref));
        }

        @Fallback
        static Object eq(Object self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__repr__", "cell", self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization
        static boolean eq(VirtualFrame frame, PCell self, PCell other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompareBool richCmpNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return richCmpNode.execute((Frame)frame, inliningTarget, left, right, op);
            }
            return op.compare(right == null, left == null);
        }

        @Fallback
        static Object eq(Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___EQ__, "cell", self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="cell", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class CellTypeNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.CompilationFinal
        private Assumption sharedAssumption;

        private Assumption getAssumption() {
            if (this.sharedAssumption == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.sharedAssumption = Truffle.getRuntime().createAssumption("cell is effectively final");
            }
            if (CompilerDirectives.inCompiledCode()) {
                return this.sharedAssumption;
            }
            return Truffle.getRuntime().createAssumption("cell is effectively final");
        }

        @Specialization
        Object newCell(Object cls, Object contents, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile nonEmptyProfile) {
            Assumption assumption = this.getAssumption();
            PCell cell = PFactory.createCell(language, assumption);
            if (nonEmptyProfile.profile(inliningTarget, !PGuards.isNoValue(contents))) {
                cell.setRef(contents, assumption);
            }
            return cell;
        }
    }
}

