/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.call.CallDispatchersFactory;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public class CallDispatchers {
    private static boolean isGeneratorFunction(RootCallTarget callTarget) {
        return callTarget.getRootNode() instanceof PBytecodeGeneratorFunctionRootNode || callTarget.getRootNode() instanceof PBytecodeDSLGeneratorFunctionRootNode;
    }

    @NeverDefault
    public static DirectCallNode createDirectCallNodeFor(PBuiltinFunction callee) {
        BuiltinFunctionRootNode root;
        RootNode rootNode;
        DirectCallNode callNode = Truffle.getRuntime().createDirectCallNode((CallTarget)callee.getCallTarget());
        if (PythonLanguage.get(null).getEngineOption(PythonOptions.EnableForcedSplits).booleanValue() || (rootNode = callee.getFunctionRootNode()) instanceof BuiltinFunctionRootNode && (root = (BuiltinFunctionRootNode)rootNode).getBuiltin().forceSplitDirectCalls()) {
            callNode.cloneCallTarget();
        }
        return callNode;
    }

    @NeverDefault
    public static DirectCallNode createDirectCallNodeFor(PFunction callee) {
        boolean isGenerator = CallDispatchers.isGeneratorFunction(callee.getCallTarget());
        DirectCallNode callNode = Truffle.getRuntime().createDirectCallNode((CallTarget)callee.getCallTarget());
        if (callee.forceSplitDirectCalls()) {
            callNode.cloneCallTarget();
        }
        if (isGenerator && PythonLanguage.get(null).getEngineOption(PythonOptions.ForceInlineGeneratorCalls).booleanValue()) {
            callNode.forceInlining();
        }
        return callNode;
    }

    public static boolean sameCallTarget(RootCallTarget callTarget, DirectCallNode callNode) {
        return callTarget == callNode.getCallTarget();
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CallDispatchers.class, PythonOptions.class})
    public static abstract class CallTargetCachedInvokeNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, RootCallTarget var3, Object[] var4);

        @Specialization(guards={"sameCallTarget(callTarget, callNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object doCallTargetDirect(VirtualFrame frame, Node inliningTarget, RootCallTarget callTarget, Object[] args, @Cached(parameters={"callTarget"}) DirectCallNode callNode, @Cached SimpleDirectInvokeNode invoke) {
            return invoke.execute(frame, inliningTarget, callNode, args);
        }

        @Specialization(replaces={"doCallTargetDirect"})
        static Object doCallTargetIndirect(VirtualFrame frame, Node inliningTarget, RootCallTarget callTarget, Object[] args, @Cached SimpleIndirectInvokeNode invoke) {
            return invoke.execute((Frame)frame, inliningTarget, callTarget, args);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CallDispatchers.class, PythonOptions.class})
    public static abstract class FunctionCachedCallNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, PFunction var3, Object[] var4, PKeyword[] var5);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        static Object callFunctionCached(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, PKeyword[] keywords, @Cached(value="callee", weak=true) PFunction cachedCallee, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached.Shared @Cached FunctionDirectInvokeNode invoke) {
            Object[] pArguments = createArgs.execute(inliningTarget, cachedCallee, arguments, keywords, cachedCallee.getCode().getSignature(), null, null, cachedCallee.getDefaults(), cachedCallee.getKwDefaults(), false);
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, pArguments);
        }

        @Specialization(guards={"sameCallTarget(callee.getCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()", replaces={"callFunctionCached"})
        static Object callFunctionCachedCt(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached.Shared @Cached FunctionDirectInvokeNode invoke) {
            Signature signature = CompilerDirectives.inCompiledCode() ? Signature.fromCallTarget((RootCallTarget)callNode.getCallTarget()) : callee.getCode().getSignature();
            Object[] pArguments = createArgs.execute(inliningTarget, callee, arguments, keywords, signature, null, null, callee.getDefaults(), callee.getKwDefaults(), false);
            return invoke.execute(frame, inliningTarget, callNode, callee, pArguments);
        }

        @Specialization(replaces={"callFunctionCached", "callFunctionCachedCt"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        static Object callFunctionMegamorphic(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached FunctionIndirectInvokeNode invoke) {
            Object[] pArguments = createArgs.execute(inliningTarget, callee, arguments, keywords, callee.getCode().getSignature(), null, null, callee.getDefaults(), callee.getKwDefaults(), false);
            return invoke.execute((Frame)frame, inliningTarget, callee, pArguments);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CallDispatchers.class, PythonOptions.class})
    public static abstract class FunctionCachedInvokeNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, PFunction var3, Object[] var4);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        static Object callFunctionCached(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, @Cached(value="callee", weak=true) PFunction cachedCallee, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached.Shared @Cached FunctionDirectInvokeNode invoke) {
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, arguments);
        }

        @Specialization(guards={"sameCallTarget(callee.getCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()", replaces={"callFunctionCached"})
        static Object callFunctionCachedCt(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached.Shared @Cached FunctionDirectInvokeNode invoke) {
            return invoke.execute(frame, inliningTarget, callNode, callee, arguments);
        }

        @Specialization(replaces={"callFunctionCached", "callFunctionCachedCt"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        static Object callFunctionMegamorphic(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, @Cached FunctionIndirectInvokeNode invoke) {
            return invoke.execute((Frame)frame, inliningTarget, callee, arguments);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class FunctionIndirectInvokeNode
    extends Node {
        public abstract Object execute(Frame var1, Node var2, PFunction var3, Object[] var4);

        @Specialization
        static Object doDirect(VirtualFrame frame, Node inliningTarget, PFunction callee, Object[] arguments, @Cached SimpleIndirectInvokeNode invoke, @Cached InlinedConditionProfile generatorProfile) {
            PArguments.setGlobals(arguments, callee.getGlobals());
            PArguments.setClosure(arguments, callee.getClosure());
            RootCallTarget callTarget = callee.getCallTarget();
            if (generatorProfile.profile(inliningTarget, CallDispatchers.isGeneratorFunction(callTarget))) {
                PArguments.setGeneratorFunction(arguments, callee);
            }
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FunctionDirectInvokeNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, DirectCallNode var3, PFunction var4, Object[] var5);

        @Specialization
        static Object doDirect(VirtualFrame frame, Node inliningTarget, DirectCallNode callNode, PFunction callee, Object[] arguments, @Cached SimpleDirectInvokeNode invoke) {
            assert (callee.getCallTarget() == callNode.getCallTarget());
            PArguments.setGlobals(arguments, callee.getGlobals());
            PArguments.setClosure(arguments, callee.getClosure());
            RootCallTarget callTarget = (RootCallTarget)callNode.getCurrentCallTarget();
            if (CallDispatchers.isGeneratorFunction(callTarget)) {
                PArguments.setGeneratorFunction(arguments, callee);
            }
            return invoke.execute(frame, inliningTarget, callNode, arguments);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CallDispatchers.class, PythonOptions.class})
    public static abstract class BuiltinMethodCachedCallNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, PBuiltinMethod var3, Object[] var4, PKeyword[] var5);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object callBuiltinMethodCached(VirtualFrame frame, Node inliningTarget, PBuiltinMethod callee, Object[] arguments, PKeyword[] keywords, @Cached(value="callee", weak=true) PBuiltinMethod cachedCallee, @Bind(value="cachedCallee.getBuiltinFunction()") PBuiltinFunction function, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached(value="createDirectCallNodeFor(function)") DirectCallNode callNode, @Cached @Cached.Shared SimpleDirectInvokeNode invoke) {
            Object[] pArguments = createArgs.execute(inliningTarget, cachedCallee, arguments, keywords, function.getSignature(), callee.getSelf(), callee.getClassObject(), function.getDefaults(), function.getKwDefaults(), BuiltinMethodCachedCallNode.isMethodcall(callee));
            return invoke.execute(frame, inliningTarget, callNode, pArguments);
        }

        @Specialization(guards={"sameCallTarget(function.getCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()", replaces={"callBuiltinMethodCached"})
        static Object callBuiltinMethodCachedCt(VirtualFrame frame, Node inliningTarget, PBuiltinMethod callee, Object[] arguments, PKeyword[] keywords, @Bind(value="callee.getBuiltinFunction()") PBuiltinFunction function, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached(value="createDirectCallNodeFor(function)") DirectCallNode callNode, @Cached @Cached.Shared SimpleDirectInvokeNode invoke) {
            Signature signature = CompilerDirectives.inCompiledCode() ? Signature.fromCallTarget((RootCallTarget)callNode.getCallTarget()) : function.getSignature();
            Object[] pArguments = createArgs.execute(inliningTarget, callee, arguments, keywords, signature, callee.getSelf(), callee.getClassObject(), function.getDefaults(), function.getKwDefaults(), BuiltinMethodCachedCallNode.isMethodcall(callee));
            return invoke.execute(frame, inliningTarget, callNode, pArguments);
        }

        @Specialization(replaces={"callBuiltinMethodCached", "callBuiltinMethodCachedCt"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        static Object callBuiltinMethodMegamorphic(VirtualFrame frame, Node inliningTarget, PBuiltinMethod callee, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached SimpleIndirectInvokeNode invoke) {
            PBuiltinFunction function = callee.getBuiltinFunction();
            Object[] pArguments = createArgs.execute(inliningTarget, callee, arguments, keywords, function.getSignature(), callee.getSelf(), callee.getClassObject(), function.getDefaults(), function.getKwDefaults(), BuiltinMethodCachedCallNode.isMethodcall(callee));
            return invoke.execute((Frame)frame, inliningTarget, function.getCallTarget(), pArguments);
        }

        private static boolean isMethodcall(PBuiltinMethod callee) {
            return !(callee.getSelf() instanceof PythonModule);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CallDispatchers.class, PythonOptions.class})
    public static abstract class BuiltinFunctionCachedCallNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, PBuiltinFunction var3, Object[] var4, PKeyword[] var5);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object callBuiltinFunctionCached(VirtualFrame frame, Node inliningTarget, PBuiltinFunction callee, Object[] arguments, PKeyword[] keywords, @Cached(value="callee") PBuiltinFunction cachedCallee, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached.Shared @Cached SimpleDirectInvokeNode invoke) {
            Object[] pArguments = createArgs.execute(inliningTarget, cachedCallee, arguments, keywords, cachedCallee.getSignature(), null, null, cachedCallee.getDefaults(), cachedCallee.getKwDefaults(), false);
            return invoke.execute(frame, inliningTarget, callNode, pArguments);
        }

        @Specialization(guards={"sameCallTarget(callee.getCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()", replaces={"callBuiltinFunctionCached"})
        static Object callBuiltinFunctionCachedCt(VirtualFrame frame, Node inliningTarget, PBuiltinFunction callee, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached.Shared @Cached SimpleDirectInvokeNode invoke) {
            Signature signature = CompilerDirectives.inCompiledCode() ? Signature.fromCallTarget((RootCallTarget)callNode.getCallTarget()) : callee.getSignature();
            Object[] pArguments = createArgs.execute(inliningTarget, callee, arguments, keywords, signature, null, null, callee.getDefaults(), callee.getKwDefaults(), false);
            return invoke.execute(frame, inliningTarget, callNode, pArguments);
        }

        @Specialization(replaces={"callBuiltinFunctionCached", "callBuiltinFunctionCachedCt"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        static Object callBuiltinFunctionMegamorphic(VirtualFrame frame, Node inliningTarget, PBuiltinFunction callee, Object[] arguments, PKeyword[] keywords, @Cached.Shared @Cached CreateArgumentsNode createArgs, @Cached SimpleIndirectInvokeNode invoke) {
            Object[] pArguments = createArgs.execute(inliningTarget, callee, arguments, keywords, callee.getSignature(), null, null, callee.getDefaults(), callee.getKwDefaults(), false);
            return invoke.execute((Frame)frame, inliningTarget, callee.getCallTarget(), pArguments);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CallDispatchers.class, PythonOptions.class})
    public static abstract class BuiltinFunctionCachedInvokeNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, PBuiltinFunction var3, Object[] var4);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object callBuiltinFunctionCached(VirtualFrame frame, Node inliningTarget, PBuiltinFunction callee, Object[] arguments, @Cached(value="callee") PBuiltinFunction cachedCallee, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached @Cached.Shared SimpleDirectInvokeNode invoke) {
            return invoke.execute(frame, inliningTarget, callNode, arguments);
        }

        @Specialization(guards={"sameCallTarget(callee.getCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()", replaces={"callBuiltinFunctionCached"})
        static Object callBuiltinFunctionCachedCt(VirtualFrame frame, Node inliningTarget, PBuiltinFunction callee, Object[] arguments, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached @Cached.Shared SimpleDirectInvokeNode invoke) {
            return invoke.execute(frame, inliningTarget, callNode, arguments);
        }

        @Specialization(replaces={"callBuiltinFunctionCached", "callBuiltinFunctionCachedCt"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        static Object callBuiltinFunctionMegamorphic(VirtualFrame frame, Node inliningTarget, PBuiltinFunction callee, Object[] arguments, @Cached SimpleIndirectInvokeNode invoke) {
            return invoke.execute((Frame)frame, inliningTarget, callee.getCallTarget(), arguments);
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class SimpleIndirectInvokeNode
    extends Node {
        public abstract Object execute(Frame var1, Node var2, RootCallTarget var3, Object[] var4);

        public final Object executeCached(VirtualFrame frame, RootCallTarget callTarget, Object[] arguments) {
            return this.execute((Frame)frame, this, callTarget, arguments);
        }

        public static Object executeUncached(RootCallTarget callTarget, Object[] arguments) {
            return CallDispatchersFactory.SimpleIndirectInvokeNodeGen.getUncached().execute(null, null, callTarget, arguments);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doDirect(VirtualFrame frame, Node inliningTarget, RootCallTarget callTarget, Object[] arguments, @Cached InlinedConditionProfile profileIsNullFrame, @Cached ExecutionContext.CallContext callContext, @Cached(inline=false) IndirectCallNode callNode) {
            if (profileIsNullFrame.profile(inliningTarget, frame == null)) {
                PythonContext context = PythonContext.get(inliningTarget);
                PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage(inliningTarget));
                Object state = ExecutionContext.IndirectCalleeContext.enterIndirect(threadState, arguments);
                try {
                    Object object = callNode.call((CallTarget)callTarget, arguments);
                    return object;
                }
                finally {
                    ExecutionContext.IndirectCalleeContext.exit(threadState, state);
                }
            }
            callContext.prepareIndirectCall(frame, arguments, (Node)callNode);
            return callNode.call((CallTarget)callTarget, arguments);
        }

        @NeverDefault
        public static SimpleIndirectInvokeNode create() {
            return CallDispatchersFactory.SimpleIndirectInvokeNodeGen.create();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SimpleDirectInvokeNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, DirectCallNode var3, Object[] var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doDirect(VirtualFrame frame, Node inliningTarget, DirectCallNode callNode, Object[] arguments, @Cached InlinedConditionProfile profileIsNullFrame, @Cached ExecutionContext.CallContext callContext) {
            RootCallTarget callTarget = (RootCallTarget)callNode.getCurrentCallTarget();
            if (profileIsNullFrame.profile(inliningTarget, frame == null)) {
                PythonContext context = PythonContext.get(inliningTarget);
                PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage(inliningTarget));
                Object state = ExecutionContext.IndirectCalleeContext.enter(threadState, arguments, callTarget);
                try {
                    Object object = callNode.call(arguments);
                    return object;
                }
                finally {
                    ExecutionContext.IndirectCalleeContext.exit(threadState, state);
                }
            }
            callContext.prepareCall(frame, arguments, callTarget, (Node)callNode);
            return callNode.call(arguments);
        }
    }
}

