/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBDriver;
import org.duckdb.DuckDBHugeInt;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.JdbcUtils;
import org.duckdb.QueryProgress;
import org.duckdb.StatementReturnType;
import org.duckdb.io.IOUtils;

public class DuckDBPreparedStatement
implements PreparedStatement {
    private DuckDBConnection conn;
    private ByteBuffer stmtRef = null;
    final ReentrantLock stmtRefLock = new ReentrantLock();
    volatile boolean closeOnCompletion = false;
    private DuckDBResultSet selectResult = null;
    private long updateResult = 0L;
    private boolean returnsChangedRows = false;
    private boolean returnsNothing = false;
    private boolean returnsResultSet = false;
    private Object[] params = new Object[0];
    private DuckDBResultSetMetaData meta = null;
    private final List<Object[]> batchedParams = new ArrayList<Object[]>();
    private final List<String> batchedStatements = new ArrayList<String>();
    private Boolean isBatch = false;
    private Boolean isPreparedStatement = false;
    private int queryTimeoutSeconds = 0;
    private ScheduledFuture<?> cancelQueryFuture = null;

    public DuckDBPreparedStatement(DuckDBConnection conn) throws SQLException {
        if (conn == null) {
            throw new SQLException("connection parameter cannot be null");
        }
        this.conn = conn;
    }

    public DuckDBPreparedStatement(DuckDBConnection conn, String sql) throws SQLException {
        if (conn == null) {
            throw new SQLException("connection parameter cannot be null");
        }
        if (sql == null) {
            throw new SQLException("sql query parameter cannot be null");
        }
        this.conn = conn;
        this.isPreparedStatement = true;
        this.prepare(sql);
    }

    private boolean isConnAutoCommit() throws SQLException {
        this.checkOpen();
        try {
            return this.conn.autoCommit;
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startTransaction() throws SQLException {
        this.checkOpen();
        try {
            if (this.conn.transactionRunning) {
                return false;
            }
            this.conn.transactionRunning = true;
            try (Statement s = this.conn.createStatement();){
                s.execute("BEGIN TRANSACTION");
                boolean bl = true;
                return bl;
            }
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    private void prepare(String sql) throws SQLException {
        this.checkOpen();
        if (sql == null) {
            throw new SQLException("sql query parameter cannot be null");
        }
        this.stmtRefLock.lock();
        try {
            this.checkOpen();
            if (this.stmtRef != null) {
                DuckDBNative.duckdb_jdbc_release(this.stmtRef);
                this.stmtRef = null;
            }
            this.meta = null;
            this.params = new Object[0];
            if (this.selectResult != null) {
                this.selectResult.close();
            }
            this.selectResult = null;
            this.updateResult = 0L;
            this.conn.connRefLock.lock();
            try {
                this.conn.checkOpen();
                if (!this.isConnAutoCommit()) {
                    this.startTransaction();
                }
                this.stmtRef = DuckDBNative.duckdb_jdbc_prepare(this.conn.connRef, sql.getBytes(StandardCharsets.UTF_8));
                this.conn.preparedStatements.add(this);
            }
            finally {
                this.conn.connRefLock.unlock();
            }
            this.meta = DuckDBNative.duckdb_jdbc_prepared_statement_meta(this.stmtRef);
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        finally {
            this.stmtRefLock.unlock();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        this.checkPrepared();
        Lock connLock = this.getConnRefLock();
        connLock.lock();
        connLock.unlock();
        ByteBuffer resultRef = null;
        this.stmtRefLock.lock();
        try {
            this.checkOpen();
            this.checkPrepared();
            if (this.selectResult != null) {
                this.selectResult.close();
            }
            this.selectResult = null;
            if (!this.isConnAutoCommit()) {
                this.startTransaction();
            }
            if (this.queryTimeoutSeconds > 0) {
                this.cleanupCancelQueryTask();
                try {
                    if (!DuckDBDriver.scheduler.isShutdown()) {
                        this.cancelQueryFuture = DuckDBDriver.scheduler.schedule(new CancelQueryTask(), (long)this.queryTimeoutSeconds, TimeUnit.SECONDS);
                    }
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            resultRef = DuckDBNative.duckdb_jdbc_execute(this.stmtRef, this.params);
            this.cleanupCancelQueryTask();
            DuckDBResultSetMetaData resultMeta = DuckDBNative.duckdb_jdbc_query_result_meta(resultRef);
            this.selectResult = new DuckDBResultSet(this.conn, this, resultMeta, resultRef);
            this.returnsResultSet = resultMeta.return_type.equals((Object)StatementReturnType.QUERY_RESULT);
            this.returnsChangedRows = resultMeta.return_type.equals((Object)StatementReturnType.CHANGED_ROWS);
            this.returnsNothing = resultMeta.return_type.equals((Object)StatementReturnType.NOTHING);
        }
        catch (SQLException e) {
            if (this.selectResult != null) {
                this.selectResult.close();
            } else if (resultRef != null) {
                DuckDBNative.duckdb_jdbc_free_result(resultRef);
                resultRef = null;
            }
            this.close();
            throw e;
        }
        finally {
            this.stmtRefLock.unlock();
        }
        if (this.returnsChangedRows) {
            if (this.selectResult.next()) {
                this.updateResult = this.selectResult.getLong(1);
            }
            this.selectResult.close();
        }
        return this.returnsResultSet;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.requireNonBatch();
        this.execute();
        if (!this.returnsResultSet) {
            throw new SQLException("executeQuery() can only be used with queries that return a ResultSet");
        }
        return this.selectResult;
    }

    @Override
    public int executeUpdate() throws SQLException {
        long res = this.executeLargeUpdate();
        return this.intFromLong(res);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.requireNonBatch();
        this.execute();
        if (!this.returnsChangedRows && !this.returnsNothing) {
            throw new SQLException("executeUpdate() can only be used with queries that return nothing (eg, a DDL statement), or update rows");
        }
        return this.getUpdateCountInternal();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.requireNonBatch();
        this.prepare(sql);
        return this.execute();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.prepare(sql);
        return this.executeQuery();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long res = this.executeLargeUpdate(sql);
        return this.intFromLong(res);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.prepare(sql);
        return this.executeLargeUpdate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        this.checkPrepared();
        return this.meta;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        this.checkPrepared();
        return this.meta.param_meta;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        int paramsCount = this.getParameterMetaData().getParameterCount();
        if (parameterIndex < 1 || parameterIndex > paramsCount) {
            throw new SQLException("Parameter index out of bounds");
        }
        if (this.params.length == 0) {
            this.params = new Object[paramsCount];
        }
        if (x instanceof BigInteger) {
            x = new DuckDBHugeInt((BigInteger)x);
        }
        this.params[parameterIndex - 1] = x;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.params = new Object[0];
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.stmtRefLock.lock();
        try {
            if (this.isClosed()) {
                return;
            }
            this.cleanupCancelQueryTask();
            if (this.selectResult != null) {
                this.selectResult.close();
                this.selectResult = null;
            }
            if (this.stmtRef != null) {
                DuckDBNative.duckdb_jdbc_release(this.stmtRef);
                if (!this.conn.closing) {
                    this.conn.connRefLock.lock();
                    try {
                        this.conn.preparedStatements.remove(this);
                    }
                    finally {
                        this.conn.connRefLock.unlock();
                    }
                }
                this.stmtRef = null;
            }
            this.conn = null;
        }
        finally {
            this.stmtRefLock.unlock();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null || this.conn.connRef == null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return 0L;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException("Invalid negative timeout value: " + seconds);
        }
        this.queryTimeoutSeconds = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        if (!this.stmtRefLock.isLocked()) {
            return;
        }
        try {
            Lock connLock = this.getConnRefLock();
            connLock.lock();
            try {
                if (!this.stmtRefLock.isLocked()) {
                    return;
                }
                this.conn.interrupt();
            }
            finally {
                connLock.unlock();
            }
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    public QueryProgress getQueryProgress() throws SQLException {
        this.checkOpen();
        try {
            return this.conn.queryProgress();
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmtRef == null) {
            throw new SQLException("Prepare something first");
        }
        if (!this.returnsResultSet) {
            return null;
        }
        DuckDBResultSet to_return = this.selectResult;
        this.selectResult = null;
        return to_return;
    }

    private long getUpdateCountInternal() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmtRef == null) {
            return -1L;
        }
        if (this.returnsResultSet || this.returnsNothing || this.selectResult.isFinished()) {
            return -1L;
        }
        return this.updateResult;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        long res = this.getUpdateCountInternal();
        this.updateResult = -1L;
        return res;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long res = this.getLargeUpdateCount();
        return this.intFromLong(res);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction == 1000) {
            return;
        }
        throw new SQLFeatureNotSupportedException("setFetchDirection");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return DuckDBNative.duckdb_jdbc_fetch_size();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this.requireNonPreparedStatement();
        this.batchedStatements.add(sql);
        this.isBatch = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        this.batchedParams.clear();
        this.batchedStatements.clear();
        this.isBatch = false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long[] res = this.executeLargeBatch();
        return this.intArrayFromLong(res);
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkOpen();
        if (this.isPreparedStatement.booleanValue()) {
            return this.executeBatchedPreparedStatement();
        }
        return this.executeBatchedStatements();
    }

    private long[] executeBatchedPreparedStatement() throws SQLException {
        this.stmtRefLock.lock();
        boolean tranStarted = false;
        DuckDBConnection conn = this.conn;
        try {
            this.checkOpen();
            this.checkPrepared();
            tranStarted = this.startTransaction();
            long[] updateCounts = new long[this.batchedParams.size()];
            for (int i = 0; i < this.batchedParams.size(); ++i) {
                this.params = this.batchedParams.get(i);
                this.execute();
                updateCounts[i] = this.getUpdateCountInternal();
            }
            this.clearBatch();
            if (tranStarted && this.isConnAutoCommit()) {
                this.conn.commit();
            }
            long[] lArray = updateCounts;
            return lArray;
        }
        catch (SQLException e) {
            if (tranStarted && conn.getAutoCommit()) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            this.stmtRefLock.unlock();
        }
    }

    private long[] executeBatchedStatements() throws SQLException {
        this.stmtRefLock.lock();
        boolean tranStarted = false;
        DuckDBConnection conn = this.conn;
        try {
            this.checkOpen();
            tranStarted = this.startTransaction();
            long[] updateCounts = new long[this.batchedStatements.size()];
            for (int i = 0; i < this.batchedStatements.size(); ++i) {
                this.prepare(this.batchedStatements.get(i));
                this.execute();
                updateCounts[i] = this.getUpdateCountInternal();
            }
            this.clearBatch();
            if (tranStarted && this.isConnAutoCommit()) {
                this.conn.commit();
            }
            long[] lArray = updateCounts;
            return lArray;
        }
        catch (SQLException e) {
            if (tranStarted && conn.getAutoCommit()) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            this.stmtRefLock.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long res = this.executeLargeUpdate(sql, autoGeneratedKeys);
        return this.intFromLong(res);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (2 == autoGeneratedKeys) {
            return this.executeLargeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException("executeUpdate(String sql, int autoGeneratedKeys)");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long res = this.executeLargeUpdate(sql, columnIndexes);
        return this.intFromLong(res);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.executeLargeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException("executeUpdate(String sql, int[] columnIndexes)");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long res = this.executeLargeUpdate(sql, columnNames);
        return this.intFromLong(res);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException("executeUpdate(String sql, String[] columnNames)");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (2 == autoGeneratedKeys) {
            return this.execute(sql);
        }
        throw new SQLFeatureNotSupportedException("execute(String sql, int autoGeneratedKeys)");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new SQLFeatureNotSupportedException("execute(String sql, int[] columnIndexes)");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            return this.execute(sql);
        }
        throw new SQLFeatureNotSupportedException("execute(String sql, String[] columnNames)");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStreamInternal(parameterIndex, x, length, StandardCharsets.UTF_8);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -7: 
            case 16: {
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).byteValue() == 1);
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Boolean.parseBoolean((String)x));
                    break;
                }
                throw new SQLException("Can't convert value to boolean " + x.getClass().toString());
            }
            case -6: {
                if (x instanceof Byte) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).byteValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Byte.parseByte((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to byte " + x.getClass().toString());
            }
            case 5: {
                if (x instanceof Short) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Short.parseShort((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to short " + x.getClass().toString());
            }
            case 4: {
                if (x instanceof Integer) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).intValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Integer.parseInt((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to int " + x.getClass().toString());
            }
            case -5: {
                if (x instanceof Long) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).longValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Long.parseLong((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to long " + x.getClass().toString());
            }
            case 6: 
            case 7: {
                if (x instanceof Float) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, Float.valueOf(((Number)x).floatValue()));
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Float.valueOf(Float.parseFloat((String)x)));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, Float.valueOf((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to float " + x.getClass().toString());
            }
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Double) {
                    this.setObject(parameterIndex, new BigDecimal((Double)x));
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, new BigDecimal((String)x));
                    break;
                }
                throw new SQLException("Can't convert value to double " + x.getClass().toString());
            }
            case 2: 
            case 8: {
                if (x instanceof Double) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Double.parseDouble((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to double " + x.getClass().toString());
            }
            case -1: 
            case 1: 
            case 12: {
                if (x instanceof String) {
                    this.setObject(parameterIndex, (String)x);
                    break;
                }
                this.setObject(parameterIndex, x.toString());
                break;
            }
            case 93: 
            case 2014: {
                if (x instanceof Timestamp) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof LocalDateTime) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof OffsetDateTime) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                throw new SQLException("Can't convert value to timestamp " + x.getClass().toString());
            }
            default: {
                throw new SQLException("Unknown target type " + targetSqlType);
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        this.batchedParams.add(this.params);
        this.clearParameters();
        this.isBatch = true;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (null == x || null == cal) {
            this.setObject(parameterIndex, x);
            return;
        }
        Instant instant = Instant.ofEpochMilli(x.getTime());
        ZoneId zoneId = cal.getTimeZone().toZoneId();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        LocalDate ld = zdt.toLocalDate();
        this.setObject(parameterIndex, ld);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (null == x || null == cal) {
            this.setObject(parameterIndex, x);
            return;
        }
        Instant instant = Instant.ofEpochMilli(x.getTime());
        ZoneId zoneId = cal.getTimeZone().toZoneId();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        LocalTime lt = zdt.toLocalTime();
        this.setObject(parameterIndex, lt);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (null == x || null == cal) {
            this.setObject(parameterIndex, x);
            return;
        }
        Instant instant = Instant.ofEpochMilli(x.getTime());
        ZoneId zoneId = cal.getTimeZone().toZoneId();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        LocalDateTime ldt = zdt.toLocalDateTime();
        this.setObject(parameterIndex, ldt);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setURL");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setCharacterStreamInternal(parameterIndex, x, length, StandardCharsets.US_ASCII);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkOpen();
        InputStream stream = IOUtils.wrapStreamWithMaxBytes(x, length);
        byte[] bytes = IOUtils.readAllBytes(stream);
        this.setObject(parameterIndex, bytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterReaderInternal(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setNCharacterStream(parameterIndex, value, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    public void setHugeInt(int parameterIndex, DuckDBHugeInt hi) throws SQLException {
        this.setObject(parameterIndex, hi);
    }

    public void setBigInteger(int parameterIndex, BigInteger bi) throws SQLException {
        this.setObject(parameterIndex, bi);
    }

    private void requireNonBatch() throws SQLException {
        if (this.isBatch.booleanValue()) {
            throw new SQLException("Batched queries must be executed with executeBatch.");
        }
    }

    private void requireNonPreparedStatement() throws SQLException {
        if (this.isPreparedStatement.booleanValue()) {
            throw new SQLException("Cannot add batched SQL statement to PreparedStatement");
        }
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
    }

    private void checkPrepared() throws SQLException {
        if (this.stmtRef == null) {
            throw new SQLException("Prepare something first");
        }
    }

    private void setCharacterStreamInternal(int parameterIndex, InputStream x, long length, Charset charset) throws SQLException {
        this.checkOpen();
        InputStream stream = IOUtils.wrapStreamWithMaxBytes(x, length);
        InputStreamReader reader = new InputStreamReader(stream, charset);
        String str = IOUtils.readToString(reader);
        this.setObject(parameterIndex, str);
    }

    private void setCharacterReaderInternal(int parameterIndex, Reader reader, long lenght) throws SQLException {
        this.checkOpen();
        Reader wrappedReader = IOUtils.wrapReaderWithMaxChars(reader, lenght);
        String str = IOUtils.readToString(wrappedReader);
        this.setObject(parameterIndex, str);
    }

    private int intFromLong(long val) {
        if (val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        return Integer.MAX_VALUE;
    }

    private int[] intArrayFromLong(long[] arr) {
        int[] res = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = this.intFromLong(arr[i]);
        }
        return res;
    }

    private Lock getConnRefLock() throws SQLException {
        try {
            return this.conn.connRefLock;
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    private void cleanupCancelQueryTask() {
        if (this.cancelQueryFuture != null) {
            this.cancelQueryFuture.cancel(false);
            this.cancelQueryFuture = null;
        }
    }

    private class CancelQueryTask
    implements Runnable {
        private CancelQueryTask() {
        }

        @Override
        public void run() {
            try {
                if (DuckDBPreparedStatement.this.isClosed()) {
                    return;
                }
                DuckDBPreparedStatement.this.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

