/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspReader;

public final class Mark {
    int cursor;
    int line;
    int col;
    char[] stream = null;
    private String fileName;
    private JspCompilationContext ctxt;

    Mark(JspReader jspReader, char[] cArray, String string) {
        this.ctxt = jspReader.getJspCompilationContext();
        this.stream = cArray;
        this.cursor = 0;
        this.line = 1;
        this.col = 1;
        this.fileName = string;
    }

    Mark(Mark mark) {
        this.init(mark, false);
    }

    void update(int n, int n2, int n3) {
        this.cursor = n;
        this.line = n2;
        this.col = n3;
    }

    void init(Mark mark, boolean bl) {
        this.cursor = mark.cursor;
        this.line = mark.line;
        this.col = mark.col;
        if (!bl) {
            this.ctxt = mark.ctxt;
            this.stream = mark.stream;
            this.fileName = mark.fileName;
        }
    }

    Mark(JspCompilationContext jspCompilationContext, String string, int n, int n2) {
        this.ctxt = jspCompilationContext;
        this.stream = null;
        this.cursor = 0;
        this.line = n;
        this.col = n2;
        this.fileName = string;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.col;
    }

    public String toString() {
        return this.getFile() + "(" + this.line + "," + this.col + ")";
    }

    public String getFile() {
        return this.fileName;
    }

    public URL getURL() throws MalformedURLException {
        return this.ctxt.getResource(this.getFile());
    }

    public boolean equals(Object object) {
        if (object instanceof Mark) {
            Mark mark = (Mark)object;
            return this.cursor == mark.cursor && this.line == mark.line && this.col == mark.col;
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.col;
        n = 31 * n + this.cursor;
        n = 31 * n + this.line;
        return n;
    }
}

