// SPDX-License-Identifier: LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
// SPDX-FileCopyrightText: 2017 The Qt Company Ltd.
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>

import QtQuick
import QtQuick.Templates as T

import org.kde.union.impl as Union

T.ProgressBar {
    id: control

    Union.Element.type: "ProgressBar"
    Union.Element.states {
        enabled: control.enabled
    }
    Union.Element.hints: Union.ElementHint { name: "indeterminate"; when: control.indeterminate }

    implicitWidth: Math.max(implicitBackgroundWidth + leftInset + rightInset,
                            implicitContentWidth + leftPadding + rightPadding)
    implicitHeight: Math.max(implicitBackgroundHeight + topInset + bottomInset,
                             implicitContentHeight + topPadding + bottomPadding)

    hoverEnabled: false

    leftPadding: Union.Style.properties.layout.padding.left
    rightPadding: Union.Style.properties.layout.padding.right
    topPadding: Union.Style.properties.layout.padding.top
    bottomPadding:  Union.Style.properties.layout.padding.bottom

    leftInset: Union.Style.properties.layout.inset.left
    rightInset: Union.Style.properties.layout.inset.right
    topInset: Union.Style.properties.layout.inset.top
    bottomInset: Union.Style.properties.layout.inset.bottom

    contentItem: Item {
        id: trackContainer

        Union.StyledRectangle {
            id: track
            Union.Element.type: "Track"

            property real indeterminatePosition: 0

            x: control.indeterminate ? indeterminatePosition * (parent.width - width) : 0
            // TODO: Find a way to style the indeterminate width here
            width: control.indeterminate ? 0.25 * parent.width : control.visualPosition * parent.width
            height: parent.height

            // TODO: Some way of controlling what kind of animation to use from
            // the style.
            SequentialAnimation on indeterminatePosition {
                loops: Animation.Infinite
                running: control.indeterminate && control.contentItem.visible

                NumberAnimation {
                    duration: 1000
                    easing.type: Easing.InOutSine
                    to: 1
                }
                NumberAnimation {
                    duration: 1000
                    easing.type: Easing.InOutSine
                    to: 0
                }

            }
        }
    }

    background: Union.StyledRectangle { }
}
