/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openide.util.RequestProcessor;

final class LineStruct {
    private static final int MAX = 0x3FFFFFFF;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("LineStruct Processor", 1, false, false);
    private List<Info> list = new LinkedList<Info>();

    public LineStruct() {
        this.list.add(new Info(0x3FFFFFFF, 0x3FFFFFFF));
    }

    public int convert(int n, final boolean bl) {
        class Compute
        implements Runnable {
            public int result;

            public Compute(int n) {
                this.result = n;
            }

            @Override
            public void run() {
                this.result = bl ? LineStruct.this.originalToCurrentImpl(this.result) : LineStruct.this.currentToOriginalImpl(this.result);
            }
        }
        Compute compute = new Compute(n);
        PROCESSOR.post((Runnable)compute).waitFinished();
        return compute.result;
    }

    public void insertLines(final int n, final int n2) {
        PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                LineStruct.this.insertLinesImpl(n, n2);
            }
        });
    }

    public void deleteLines(final int n, final int n2) {
        PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                LineStruct.this.deleteLinesImpl(n, n2);
            }
        });
    }

    private int originalToCurrentImpl(int n) {
        Iterator<Info> iterator = this.list.iterator();
        int n2 = 0;
        while (true) {
            Info info = iterator.next();
            if (info.original > n) {
                return n > info.current ? n2 + info.current : n2 + n;
            }
            n2 += info.current;
            n -= info.original;
        }
    }

    private int currentToOriginalImpl(int n) {
        Iterator<Info> iterator = this.list.iterator();
        int n2 = 0;
        while (true) {
            Info info = iterator.next();
            if (info.current > n) {
                return n > info.original ? n2 + info.original : n2 + n;
            }
            n2 += info.original;
            n -= info.current;
        }
    }

    private void insertLinesImpl(int n, int n2) {
        ListIterator<Info> listIterator = this.list.listIterator();
        while (true) {
            Info info = listIterator.next();
            if (info.current >= n) {
                while (true) {
                    if ((n2 = info.insert(n, n2, listIterator)) == 0) {
                        return;
                    }
                    info = listIterator.next();
                    n = 0;
                }
            }
            n -= info.current;
        }
    }

    private void deleteLinesImpl(int n, int n2) {
        ListIterator<Info> listIterator = this.list.listIterator();
        while (true) {
            Info info = listIterator.next();
            if (info.current >= n) {
                Info info2 = new Info(n2, 0);
                while (true) {
                    info2 = info.delete(n, info2, listIterator);
                    if (info2.original == 0) break;
                    info = listIterator.next();
                    n = 0;
                }
                if (info2.current > 0 && listIterator.hasPrevious()) {
                    Info info3 = listIterator.previous();
                    boolean bl = listIterator.hasPrevious();
                    if (bl) {
                        info3 = listIterator.previous();
                    }
                    if (info3.current == 0) {
                        info3.original += info2.current;
                    } else {
                        if (bl) {
                            listIterator.next();
                        }
                        listIterator.add(new Info(info2.current, 0));
                    }
                }
                return;
            }
            n -= info.current;
        }
    }

    private static final class Info {
        public static final int AREA_ORIGINAL = 0;
        public static final int AREA_INSERT = 1;
        public static final int AREA_REMOVE = -1;
        public int original;
        public int current;

        public Info(int n, int n2) {
            this.original = n;
            this.current = n2;
        }

        public int type() {
            if (this.current == this.original) {
                return 0;
            }
            if (this.current == 0) {
                return -1;
            }
            if (this.original == 0) {
                return 1;
            }
            throw new IllegalStateException("Original: " + this.original + " current: " + this.current);
        }

        public int insert(int n, int n2, ListIterator<Info> listIterator) {
            switch (this.type()) {
                case 1: {
                    this.current += n2;
                    return 0;
                }
                case 0: {
                    if (n == this.current) {
                        return n2;
                    }
                    if (n == 0) {
                        Info info = new Info(this.original, this.original);
                        this.original = 0;
                        this.current = n2;
                        listIterator.add(info);
                        return 0;
                    }
                    Info info = new Info(this.original - n, this.original - n);
                    this.original = this.current = n;
                    listIterator.add(new Info(0, n2));
                    listIterator.add(info);
                    return 0;
                }
                case -1: {
                    if (n != 0) {
                        throw new IllegalStateException("Pos: " + n);
                    }
                    Info info = listIterator.previous();
                    if (listIterator.hasPrevious()) {
                        info = listIterator.previous();
                        listIterator.next();
                    }
                    listIterator.next();
                    if (n2 < this.original) {
                        if (info.type() == 0) {
                            info.original += n2;
                            info.current += n2;
                            this.original -= n2;
                        } else {
                            Info info2 = new Info(this.original - n2, 0);
                            this.original = this.current = n2;
                            listIterator.add(info2);
                        }
                        return 0;
                    }
                    if (info.type() == 0) {
                        info.current += this.original;
                        info.original += this.original;
                        listIterator.remove();
                        return n2 - this.original;
                    }
                    this.current = this.original;
                    return n2 - this.current;
                }
            }
            throw new IllegalStateException("Type: " + this.type());
        }

        public Info delete(int n, Info info, ListIterator<Info> listIterator) {
            switch (this.type()) {
                case 0: {
                    if (n != 0) {
                        int n2 = this.current - n;
                        this.current = this.original = n;
                        if (n2 >= info.original) {
                            Info info2 = new Info(n2, n2);
                            listIterator.add(info2);
                            info.current += info.original;
                            info.original = 0;
                            return info;
                        }
                        info.original -= n2;
                        info.current += n2;
                        return info;
                    }
                    if (this.current >= info.original) {
                        info.current += info.original;
                        this.current -= info.original;
                        this.original = this.current;
                        info.original = 0;
                        return info;
                    }
                    listIterator.remove();
                    info.current += this.current;
                    info.original -= this.current;
                    return info;
                }
                case 1: {
                    if (n != 0) {
                        int n3 = this.current - n;
                        if (n3 >= info.original) {
                            this.current -= info.original;
                            info.original = 0;
                            return info;
                        }
                        this.current = n;
                        info.original -= n3;
                        return info;
                    }
                    if (this.current >= info.original) {
                        this.current -= info.original;
                        info.original = 0;
                        listIterator.remove();
                        return info;
                    }
                    listIterator.remove();
                    info.original -= this.current;
                    return info;
                }
                case -1: {
                    this.original += info.current;
                    info.current = 0;
                    return info;
                }
            }
            throw new IllegalStateException("Type: " + this.type());
        }
    }
}

