/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.GUI.SelectListener;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class EditPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private BufferedImage image;
    private Color color1 = Color.BLUE;
    private Color color2 = Color.BLACK;
    private int width;
    private int height;
    private int ofsX;
    private int ofsY;
    private int imgWidth;
    private int imgHeight;
    private static double screenRatioIn = 2.3333333333333335;
    private static double cineBarFactor = 0.11904761904761904;
    private static final double screenRatio = 1.7777777777777777;
    private int cropOfsY = 0;
    static final int inset = 2;
    private boolean layoutPane;
    private int selectStartX;
    private int selectEndX;
    private int selectStartY;
    private int selectEndY;
    private boolean allowSelection;
    private boolean validSelection;
    private boolean leftButtonPressed;
    private boolean excluded;
    SelectListener selectListener;
    private double xScaleCaption;
    private double yScaleCaption;
    private int yCrop;

    public EditPane(boolean isLayoutPane) {
        this.layoutPane = isLayoutPane;
        this.width = 1920;
        this.height = 1080;
        this.imgWidth = 0;
        this.imgHeight = 0;
        this.image = null;
        this.selectStartX = -1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.allowSelection = false;
    }

    public EditPane() {
        this(false);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.draw(g);
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.draw(g);
    }

    public void draw(Graphics g) {
        int xl;
        int yl;
        int hl;
        int wl;
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.layoutPane) {
            g2.setColor(UIManager.getColor("Panel.background"));
            g2.fillRect(0, 0, w, h);
            wl = w - 4;
            hl = (wl * 9 + 8) / 16;
            if (hl > h) {
                hl = h - 2;
                wl = (hl * 32 + 8) / 18;
            }
            yl = (h - hl + 1) / 2;
            xl = (w - wl + 1) / 2;
        } else {
            wl = w;
            hl = h;
            xl = 0;
            yl = 0;
        }
        int cineH = (int)((double)hl * cineBarFactor + 0.5);
        g2.setPaint(new GradientPaint(xl, yl, this.color1, wl, hl, this.color2));
        g2.fillRect(xl, yl + cineH, wl, hl - cineH);
        g2.setPaint(Color.BLACK);
        g2.fillRect(xl, yl, wl, cineH);
        g2.fillRect(xl, yl + hl - cineH, wl, cineH);
        this.yCrop = this.ofsY;
        if (this.yCrop < this.cropOfsY) {
            this.yCrop = this.cropOfsY;
        } else {
            int yMax = this.height - this.imgHeight - this.cropOfsY;
            if (this.yCrop > yMax) {
                this.yCrop = yMax;
            }
        }
        double sx = (double)wl / (double)this.width;
        double sy = (double)hl / (double)this.height;
        this.xScaleCaption = sx;
        this.yScaleCaption = sy;
        if (this.imgWidth > 0 && this.image != null) {
            int wi = (int)((double)this.imgWidth * sx + 0.5);
            int hi = (int)((double)this.imgHeight * sy + 0.5);
            int xi = xl + (int)((double)this.ofsX * sx + 0.5);
            int yi = yl + (int)((double)this.yCrop * sy + 0.5);
            g2.setColor(Color.GREEN);
            g2.drawRect(xi, yi, wi - 1, hi - 1);
            g2.drawImage(this.image, xi, yi, wi, hi, this);
            if (this.validSelection && !this.leftButtonPressed) {
                if (this.selectStartX >= this.imgWidth + this.ofsX || this.selectEndX <= this.ofsX || this.selectStartY >= this.imgHeight + this.yCrop || this.selectEndY < this.yCrop) {
                    this.validSelection = false;
                } else {
                    if (this.selectStartX < this.ofsX) {
                        this.selectStartX = this.ofsX;
                    }
                    if (this.selectEndX >= this.imgWidth + this.ofsX) {
                        this.selectEndX = this.imgWidth + this.ofsX - 1;
                    }
                    if (this.selectStartY < this.yCrop) {
                        this.selectStartY = this.yCrop;
                    }
                    if (this.selectEndY >= this.imgHeight + this.yCrop) {
                        this.selectEndY = this.imgHeight + this.yCrop - 1;
                    }
                }
            }
        }
        if (this.cropOfsY > 0) {
            g2.setPaint(Color.RED);
            int y = yl + (int)((double)this.cropOfsY * sy + 0.5);
            g2.drawLine(xl, y, wl - 1, y);
            y = yl + hl - (int)((double)this.cropOfsY * sy + 0.5) - 1;
            g2.drawLine(xl, y, wl - 1, y);
        }
        if (this.validSelection) {
            g2.setPaint(Color.YELLOW);
            g2.drawRect((int)((double)this.selectStartX * sx + 0.5), (int)((double)this.selectStartY * sy + 0.5), (int)((double)(this.selectEndX - this.selectStartX) * sx + 0.5), (int)((double)(this.selectEndY - this.selectStartY) * sy + 0.5));
        }
        if (this.excluded) {
            g2.setPaint(Color.RED);
            g2.drawLine(xl, yl, xl + wl - 1, yl + hl - 1);
            g2.drawLine(xl + wl, yl, xl - 1, yl + hl - 1);
        }
    }

    public void setImage(BufferedImage img, int w, int h) {
        this.image = img;
        this.imgWidth = w;
        this.imgHeight = h;
    }

    public void setDim(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setOffsets(int x, int y) {
        this.ofsX = x;
        this.ofsY = y < this.cropOfsY ? this.cropOfsY : y;
    }

    public void setScreenRatio(double sr) {
        screenRatioIn = sr;
        cineBarFactor = (1.0 - 1.7777777777777777 / screenRatioIn) / 2.0;
    }

    public void setCropOfsY(int ofs) {
        this.cropOfsY = ofs;
    }

    public void setAllowSelection(boolean e) {
        this.allowSelection = e;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.allowSelection && e.getButton() == 1) {
            this.selectStartX = (int)((double)e.getX() / this.xScaleCaption + 0.5);
            this.selectStartY = (int)((double)e.getY() / this.yScaleCaption + 0.5);
            this.leftButtonPressed = true;
            this.validSelection = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.allowSelection && e.getButton() == 1) {
            this.selectEndX = (int)((double)e.getX() / this.xScaleCaption + 0.5);
            this.selectEndY = (int)((double)e.getY() / this.yScaleCaption + 0.5);
            this.leftButtonPressed = false;
            if (this.selectStartX >= 0 && this.selectEndX > this.selectStartX && this.selectEndY > this.selectStartY) {
                this.validSelection = true;
            }
            this.repaint();
            this.selectListener.selectionPerformed(this.validSelection);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.leftButtonPressed) {
            this.selectEndX = (int)((double)e.getX() / this.xScaleCaption + 0.5);
            this.selectEndY = (int)((double)e.getY() / this.yScaleCaption + 0.5);
            if (this.selectStartX >= 0 && this.selectEndX > this.selectStartX && this.selectEndY > this.selectStartY) {
                this.validSelection = true;
            }
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    public int[] getSelection() {
        if (!this.allowSelection || !this.validSelection) {
            return null;
        }
        int[] ret = new int[]{this.selectStartX - this.ofsX, this.selectStartY - this.yCrop, this.selectEndX - this.ofsX, this.selectEndY - this.yCrop};
        return ret;
    }

    public void removeSelection() {
        if (this.allowSelection && this.validSelection) {
            this.validSelection = false;
        }
    }

    public void addSelectListener(SelectListener s) {
        this.selectListener = s;
    }
}

