/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.Filters.Filter;
import deadbeef.Filters.FilterOp;
import deadbeef.SupTools.BitmapBounds;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.PaletteBitmap;
import deadbeef.Tools.QuantizeFilter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;

public class Bitmap {
    private final int width;
    private final int height;
    private final byte[] img;

    public Bitmap(int w, int h, int col) {
        this.width = w;
        this.height = h;
        this.img = new byte[this.width * this.height];
        this.clear(col);
    }

    public Bitmap(int w, int h) {
        this.width = w;
        this.height = h;
        this.img = new byte[this.width * this.height];
    }

    public Bitmap(int w, int h, byte[] buf) {
        this.width = w;
        this.height = h;
        this.img = buf;
    }

    public Bitmap(Bitmap bm) {
        this.width = bm.width;
        this.height = bm.height;
        this.img = new byte[this.width * this.height];
        int i = 0;
        while (i < this.img.length) {
            this.img[i] = bm.img[i];
            ++i;
        }
    }

    public void clear(int color) {
        byte b = (byte)color;
        int i = 0;
        while (i < this.width * this.height) {
            this.img[i] = b;
            ++i;
        }
    }

    public void fillRect(int x, int y, int w, int h, int color) {
        int yMax;
        byte b = (byte)color;
        int xMax = x + w;
        if (xMax > this.width) {
            xMax = this.width;
        }
        if ((yMax = y + h) > this.height) {
            yMax = this.height;
        }
        int yt = y;
        while (yt < yMax) {
            int yOfs = yt * this.width;
            int xt = x;
            while (xt < xMax) {
                this.img[yOfs + xt] = b;
                ++xt;
            }
            ++yt;
        }
    }

    public void setPixel(int x, int y, byte color) {
        this.img[x + this.width * y] = color;
    }

    public byte getPixel(int x, int y) {
        return this.img[x + this.width * y];
    }

    public BufferedImage getImage(Palette pal) {
        DataBufferByte dbuf = new DataBufferByte(this.img, this.width * this.height, 0);
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, this.width, this.height, new int[]{255});
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
        return new BufferedImage(pal.getColorModel(), raster, false, null);
    }

    public int getPrimaryColorIndex(Palette pal, int alphaThr) {
        int[] hist = new int[pal.getSize()];
        int i = 0;
        while (i < hist.length) {
            hist[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.img.length) {
            int n = this.img[i] & 0xFF;
            hist[n] = hist[n] + 1;
            ++i;
        }
        i = 0;
        while (i < hist.length) {
            int alpha = pal.getAlpha(i);
            if (alpha < alphaThr) {
                alpha = 0;
            }
            hist[i] = (hist[i] * alpha + 128) / 256;
            hist[i] = (hist[i] * (pal.getY()[i] & 0xFF) + 128) / 256;
            ++i;
        }
        int max = 0;
        int col = 0;
        int i2 = 0;
        while (i2 < hist.length) {
            if (hist[i2] > max) {
                max = hist[i2];
                col = i2;
            }
            ++i2;
        }
        return col;
    }

    public int getHighestColorIndex(Palette p) {
        int maxIdx = 0;
        int i = 0;
        while (i < this.img.length) {
            int idx = this.img[i] & 0xFF;
            if (p.getAlpha(idx) > 0 && idx > maxIdx && (maxIdx = idx) == 255) break;
            ++i;
        }
        return maxIdx;
    }

    public Bitmap convertLm(Palette pal, int alphaThr, int[] lumThr) {
        byte[] cy = pal.getY();
        byte[] a = pal.getAlpha();
        Bitmap bm = new Bitmap(this.width, this.height);
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < this.img.length) {
            int colIdx;
            int idx = this.img[i] & 0xFF;
            int alpha = a[idx] & 0xFF;
            int cyp = cy[idx] & 0xFF;
            Integer idxEx = (Integer)p.get(alpha << 8 | cyp);
            if (idxEx != null) {
                colIdx = idxEx;
            } else {
                colIdx = 0;
                if (alpha < alphaThr) {
                    colIdx = 0;
                } else {
                    colIdx = 1;
                    int n = 0;
                    while (n < lumThr.length) {
                        if (cyp > lumThr[n]) break;
                        ++colIdx;
                        ++n;
                    }
                }
                p.put(alpha << 8 | cyp, colIdx);
            }
            bm.img[i] = (byte)colIdx;
            ++i;
        }
        return bm;
    }

    public Bitmap scaleBilinearLm(int sizeX, int sizeY, Palette pal, int alphaThr, int[] lumThr) {
        byte[] cy = pal.getY();
        byte[] a = pal.getAlpha();
        double scaleX = (double)(this.width - 1) / (double)(sizeX - 1);
        double scaleY = (double)(this.height - 1) / (double)(sizeY - 1);
        int lastCY = 0;
        int lastA = 0;
        int lastColIdx = 0;
        Bitmap trg = new Bitmap(sizeX, sizeY);
        int yt = 0;
        while (yt < sizeY) {
            double ys = (double)yt * scaleY;
            int ysi = (int)ys;
            double wy = ys - (double)ysi;
            double wy1 = 1.0 - wy;
            int xt = 0;
            while (xt < sizeX) {
                double xs = (double)xt * scaleX;
                int xsi = (int)xs;
                double wx = xs - (double)xsi;
                double wx1 = 1.0 - wx;
                double w = wx1 * wy1;
                int idx = this.getPixel(xsi, ysi) & 0xFF;
                double at = (double)(a[idx] & 0xFF) * w;
                double cyt = (double)(cy[idx] & 0xFF) * w;
                if (xsi < this.width - 1) {
                    w = wx * wy1;
                    idx = this.getPixel(xsi + 1, ysi) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    cyt += (double)(cy[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1) {
                    w = wx1 * wy;
                    idx = this.getPixel(xsi, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    cyt += (double)(cy[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1 && xsi < this.width - 1) {
                    w = wx * wy;
                    idx = this.getPixel(xsi + 1, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    cyt += (double)(cy[idx] & 0xFF) * w;
                }
                int ati = (int)at;
                int cyti = (int)cyt;
                int colIdx = lastColIdx;
                if (ati != lastA || cyti != lastCY) {
                    if (ati < alphaThr) {
                        colIdx = 0;
                    } else {
                        colIdx = 1;
                        int n = 0;
                        while (n < lumThr.length) {
                            if (cyti > lumThr[n]) break;
                            ++colIdx;
                            ++n;
                        }
                    }
                    lastA = ati;
                    lastCY = cyti;
                    lastColIdx = colIdx;
                }
                trg.setPixel(xt, yt, (byte)colIdx);
                ++xt;
            }
            ++yt;
        }
        return trg;
    }

    public Bitmap scaleFilterLm(int sizeX, int sizeY, Palette pal, int alphaThr, int[] lumThr, Filter f) {
        FilterOp fOp = new FilterOp();
        fOp.setFilter(f);
        int[] trg = fOp.filter(this, pal, sizeX, sizeY);
        Bitmap bm = new Bitmap(sizeX, sizeY);
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < trg.length) {
            int colIdx;
            int color = trg[i];
            Integer idxEx = (Integer)p.get(color);
            if (idxEx != null) {
                colIdx = idxEx;
            } else {
                colIdx = 0;
                int alpha = color >> 24 & 0xFF;
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int cyp = Palette.RGB2YCbCr(red, green, blue, false)[0];
                if (alpha < alphaThr) {
                    colIdx = 0;
                } else {
                    colIdx = 1;
                    int n = 0;
                    while (n < lumThr.length) {
                        if (cyp > lumThr[n]) break;
                        ++colIdx;
                        ++n;
                    }
                }
                p.put(color, colIdx);
            }
            bm.img[i] = (byte)colIdx;
            ++i;
        }
        return bm;
    }

    public Bitmap scaleBilinear(int sizeX, int sizeY, Palette pal) {
        byte[] r = pal.getR();
        byte[] g = pal.getG();
        byte[] b = pal.getB();
        byte[] a = pal.getAlpha();
        double scaleX = (double)(this.width - 1) / (double)(sizeX - 1);
        double scaleY = (double)(this.height - 1) / (double)(sizeY - 1);
        int lastR = 0;
        int lastG = 0;
        int lastB = 0;
        int lastA = 0;
        int lastColIdx = pal.getTransparentIndex();
        Bitmap trg = new Bitmap(sizeX, sizeY);
        int yt = 0;
        while (yt < sizeY) {
            double ys = (double)yt * scaleY;
            int ysi = (int)ys;
            double wy = ys - (double)ysi;
            double wy1 = 1.0 - wy;
            int xt = 0;
            while (xt < sizeX) {
                double xs = (double)xt * scaleX;
                int xsi = (int)xs;
                double wx = xs - (double)xsi;
                double wx1 = 1.0 - wx;
                double w = wx1 * wy1;
                int idx = this.getPixel(xsi, ysi) & 0xFF;
                double at = (double)(a[idx] & 0xFF) * w;
                double rt = (double)(r[idx] & 0xFF) * w;
                double gt = (double)(g[idx] & 0xFF) * w;
                double bt = (double)(b[idx] & 0xFF) * w;
                if (xsi < this.width - 1) {
                    w = wx * wy1;
                    idx = this.getPixel(xsi + 1, ysi) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1) {
                    w = wx1 * wy;
                    idx = this.getPixel(xsi, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1 && xsi < this.width - 1) {
                    w = wx * wy;
                    idx = this.getPixel(xsi + 1, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                int ati = (int)(at + 0.5);
                int rti = (int)(rt + 0.5);
                int gti = (int)(gt + 0.5);
                int bti = (int)(bt + 0.5);
                int colIdx = lastColIdx;
                if (ati != lastA || rti != lastR || gti != lastG || bti != lastB) {
                    int minDistance = 0xFFFFFF;
                    idx = 0;
                    while (idx < pal.getSize()) {
                        int rd = rti - (r[idx] & 0xFF);
                        int gd = gti - (g[idx] & 0xFF);
                        int bd = bti - (b[idx] & 0xFF);
                        int ad = ati - (a[idx] & 0xFF);
                        int distance = rd * rd + gd * gd + bd * bd + ad * ad;
                        if (distance < minDistance) {
                            colIdx = idx;
                            minDistance = distance;
                            if (minDistance == 0) break;
                        }
                        ++idx;
                    }
                    lastA = ati;
                    lastR = rti;
                    lastG = gti;
                    lastB = bti;
                    lastColIdx = colIdx;
                }
                trg.setPixel(xt, yt, (byte)colIdx);
                ++xt;
            }
            ++yt;
        }
        return trg;
    }

    public PaletteBitmap scaleBilinear(int sizeX, int sizeY, Palette pal, boolean dither) {
        byte[] r = pal.getR();
        byte[] g = pal.getG();
        byte[] b = pal.getB();
        byte[] a = pal.getAlpha();
        double scaleX = (double)(this.width - 1) / (double)(sizeX - 1);
        double scaleY = (double)(this.height - 1) / (double)(sizeY - 1);
        int[] trg = new int[sizeX * sizeY];
        int yt = 0;
        while (yt < sizeY) {
            double ys = (double)yt * scaleY;
            int ysi = (int)ys;
            double wy = ys - (double)ysi;
            double wy1 = 1.0 - wy;
            int ofsY = yt * sizeX;
            int xt = 0;
            while (xt < sizeX) {
                int y;
                double xs = (double)xt * scaleX;
                int xsi = (int)xs;
                double wx = xs - (double)xsi;
                double wx1 = 1.0 - wx;
                double w = wx1 * wy1;
                int idx = this.getPixel(xsi, ysi) & 0xFF;
                double at = (double)(a[idx] & 0xFF) * w;
                double rt = (double)(r[idx] & 0xFF) * w;
                double gt = (double)(g[idx] & 0xFF) * w;
                double bt = (double)(b[idx] & 0xFF) * w;
                int x = xsi + 1;
                if (x < this.width) {
                    w = wx * wy1;
                    idx = this.getPixel(x, ysi) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                if ((y = ysi + 1) < this.height) {
                    w = wx1 * wy;
                    idx = this.getPixel(xsi, y) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                x = xsi + 1;
                y = ysi + 1;
                if (x < this.width && y < this.height) {
                    w = wx * wy;
                    idx = this.getPixel(x, y) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                int ati = (int)at;
                int rti = (int)rt;
                int gti = (int)gt;
                int bti = (int)bt;
                trg[xt + ofsY] = ati << 24 | rti << 16 | gti << 8 | bti;
                ++xt;
            }
            ++yt;
        }
        QuantizeFilter qf = new QuantizeFilter();
        Bitmap bm = new Bitmap(sizeX, sizeY);
        int[] ct = qf.quantize(trg, bm.img, sizeX, sizeY, 255, dither, dither);
        int size = ct.length;
        if (size > 255) {
            size = 255;
            Core.printWarn("Quantizer failed.\n");
        }
        Palette trgPal = new Palette(256);
        int i = 0;
        while (i < size) {
            trgPal.setARGB(i, ct[i]);
            ++i;
        }
        return new PaletteBitmap(bm, trgPal);
    }

    public Bitmap scaleFilter(int sizeX, int sizeY, Palette pal, Filter f) {
        byte[] r = pal.getR();
        byte[] g = pal.getG();
        byte[] b = pal.getB();
        byte[] a = pal.getAlpha();
        FilterOp fOp = new FilterOp();
        fOp.setFilter(f);
        int[] trg = fOp.filter(this, pal, sizeX, sizeY);
        Bitmap bm = new Bitmap(sizeX, sizeY);
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < trg.length) {
            int colIdx;
            int color = trg[i];
            Integer idxEx = (Integer)p.get(color);
            if (idxEx != null) {
                colIdx = idxEx;
            } else {
                colIdx = 0;
                int minDistance = 0xFFFFFF;
                int alpha = color >> 24 & 0xFF;
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int idx = 0;
                while (idx < pal.getSize()) {
                    int rd = red - (r[idx] & 0xFF);
                    int gd = green - (g[idx] & 0xFF);
                    int bd = blue - (b[idx] & 0xFF);
                    int ad = alpha - (a[idx] & 0xFF);
                    int distance = rd * rd + gd * gd + bd * bd + ad * ad;
                    if (distance < minDistance) {
                        colIdx = idx;
                        minDistance = distance;
                        if (minDistance == 0) break;
                    }
                    ++idx;
                }
                p.put(color, colIdx);
            }
            bm.img[i] = (byte)colIdx;
            ++i;
        }
        return bm;
    }

    public PaletteBitmap scaleFilter(int sizeX, int sizeY, Palette pal, Filter f, boolean dither) {
        FilterOp fOp = new FilterOp();
        fOp.setFilter(f);
        int[] trg = fOp.filter(this, pal, sizeX, sizeY);
        QuantizeFilter qf = new QuantizeFilter();
        Bitmap bm = new Bitmap(sizeX, sizeY);
        int[] ct = qf.quantize(trg, bm.img, sizeX, sizeY, 255, dither, dither);
        int size = ct.length;
        if (size > 255) {
            size = 255;
            Core.printWarn("Quantizer failed.\n");
        }
        Palette trgPal = new Palette(256);
        int i = 0;
        while (i < size) {
            trgPal.setARGB(i, ct[i]);
            ++i;
        }
        return new PaletteBitmap(bm, trgPal);
    }

    public int[] toARGB(Palette pal) {
        int[] t = new int[this.img.length];
        int i = 0;
        while (i < t.length) {
            t[i] = pal.getARGB(this.img[i] & 0xFF);
            ++i;
        }
        return t;
    }

    public Bitmap crop(int x, int y, int w, int h) {
        Bitmap bm = new Bitmap(w, h);
        int yOfsSrc = y * this.width;
        int yOfsTrg = 0;
        int yt = 0;
        while (yt < h) {
            int xt = 0;
            while (xt < w) {
                bm.img[xt + yOfsTrg] = this.img[x + xt + yOfsSrc];
                ++xt;
            }
            ++yt;
            yOfsSrc += this.width;
            yOfsTrg += w;
        }
        return bm;
    }

    public BitmapBounds getBounds(Palette pal, int alphaThr) {
        int y;
        int idx;
        int x;
        byte[] a = pal.getAlpha();
        int yMax = this.height - 1;
        int yOfs = yMax * this.width;
        int y2 = this.height - 1;
        block0: while (y2 > 0) {
            yMax = y2;
            x = 0;
            while (x < this.width) {
                idx = this.img[x + yOfs] & 0xFF;
                if ((a[idx] & 0xFF) >= alphaThr) break block0;
                ++x;
            }
            --y2;
            yOfs -= this.width;
        }
        int yMin = 0;
        yOfs = 0;
        y2 = 0;
        block2: while (y2 < yMax) {
            yMin = y2;
            x = 0;
            while (x < this.width) {
                idx = this.img[x + yOfs] & 0xFF;
                if ((a[idx] & 0xFF) >= alphaThr) break block2;
                ++x;
            }
            ++y2;
            yOfs += this.width;
        }
        int xMax = this.width - 1;
        int x2 = this.width - 1;
        block4: while (x2 > 0) {
            xMax = x2;
            yOfs = yMin * this.width;
            y = yMin;
            while (y < yMax) {
                idx = this.img[x2 + yOfs] & 0xFF;
                if ((a[idx] & 0xFF) >= alphaThr) break block4;
                ++y;
                yOfs += this.width;
            }
            --x2;
        }
        int xMin = 0;
        x2 = 0;
        block6: while (x2 < xMax) {
            xMin = x2;
            yOfs = yMin * this.width;
            y = yMin;
            while (y < yMax) {
                idx = this.img[x2 + yOfs] & 0xFF;
                if ((a[idx] & 0xFF) >= alphaThr) break block6;
                ++y;
                yOfs += this.width;
            }
            ++x2;
        }
        return new BitmapBounds(xMin, xMax, yMin, yMax);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getImg() {
        return this.img;
    }
}

