/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

public class BitStream {
    private final byte[] buf;
    private int byteOfs;
    private int b;
    private int bits;

    public BitStream(byte[] buffer) {
        this.buf = buffer;
        this.byteOfs = 0;
        this.b = this.buf[0] & 0xFF;
        this.bits = 8;
    }

    public int bitsLeft() {
        return 8 * (this.buf.length - this.byteOfs) - (8 - this.bits);
    }

    public int readBits(int n) {
        int retval = 0;
        while (n > 0) {
            retval <<= 1;
            if ((this.b & 0x80) == 128) {
                retval |= 1;
            }
            this.b <<= 1;
            --n;
            if (--this.bits != 0) continue;
            if (this.byteOfs < this.buf.length - 1) {
                this.b = this.buf[++this.byteOfs] & 0xFF;
                this.bits = 8;
                continue;
            }
            this.bits = 0;
        }
        return retval;
    }

    public void syncToByte() {
        if (this.bits != 8) {
            if (this.byteOfs < this.buf.length - 1) {
                this.b = this.buf[++this.byteOfs] & 0xFF;
                this.bits = 8;
            } else {
                this.bits = 0;
            }
        }
    }
}

